/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql.protocol;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.graphql.protocol.DefaultGraphqlRequest;
import java.util.Map;
import java.util.Objects;

public interface GraphqlRequest {
    public static GraphqlRequest of(String query) {
        return GraphqlRequest.of(query, null, (Map<String, Object>)ImmutableMap.of(), (Map<String, Object>)ImmutableMap.of(), MediaType.GRAPHQL_JSON);
    }

    public static GraphqlRequest of(String query, @Nullable String operationName, Map<String, Object> variables, Map<String, Object> extensions, @Nullable MediaType produceType) {
        Objects.requireNonNull(query, "query");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query is empty");
        Objects.requireNonNull(variables, "variables");
        Objects.requireNonNull(extensions, "extensions");
        return new DefaultGraphqlRequest(query, operationName, variables, extensions, produceType);
    }

    public String query();

    @Nullable
    public String operationName();

    public Map<String, Object> variables();

    public Map<String, Object> extensions();

    @Nullable
    public MediaType produceType();
}

