/*
 * Decompiled with CFR 0.152.
 */
package com.lin.timeline;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TimeLineDecoration
extends RecyclerView.ItemDecoration {
    public static final int NORMAL = 0;
    public static final int BEGIN = 1;
    public static final int END = 2;
    public static final int END_FULL = 3;
    public static final int LINE = 4;
    public static final int LINE_FULL = 5;
    public static final int CUSTOM = 6;
    private float dividerHeight;
    private float dividerPaddingLeft;
    private float dividerPaddingRight;
    @NonNull
    private Paint dividerPaint;
    private int lineWidth;
    @NonNull
    private Paint linePaint;
    private int leftDistance;
    private int topDistance;
    @NonNull
    private Paint markerPaint;
    private int markerRadius;
    @Nullable
    private Drawable beginMarker;
    private int beginMarkerRadius;
    @Nullable
    private Drawable endMarker;
    private int endMarkerRadius;
    @Nullable
    private Drawable normalMarker;
    private int normalMarkerRadius;
    @Nullable
    private Drawable customMarker;
    private int customMarkerRadius;
    private final Context context;
    @Nullable
    private TimeLineCallback callback;

    public TimeLineDecoration(@NonNull Context context) {
        this.context = context;
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStyle(Paint.Style.FILL);
        this.linePaint = new Paint();
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStyle(Paint.Style.FILL);
        this.linePaint.setColor(this.getColor(17170444));
        this.markerPaint = new Paint();
        this.markerPaint.setAntiAlias(true);
        this.markerPaint.setStyle(Paint.Style.FILL);
        this.markerPaint.setColor(context.getResources().getIdentifier("colorPrimary", "attr", context.getPackageName()));
    }

    public TimeLineDecoration setDividerHeight(@FloatRange(from=0.0) float height) {
        this.dividerHeight = this.dp2px(height);
        return this;
    }

    public TimeLineDecoration setDividerColor(@ColorRes int color2) {
        this.dividerPaint.setColor(this.getColor(color2));
        return this;
    }

    public TimeLineDecoration setDividerPaddingLeft(@FloatRange(from=0.0) float padding) {
        this.dividerPaddingLeft = this.dp2px(padding);
        return this;
    }

    public TimeLineDecoration setDividerPaddingRight(@FloatRange(from=0.0) float padding) {
        this.dividerPaddingRight = this.dp2px(padding);
        return this;
    }

    public TimeLineDecoration setLineColor(@ColorRes int color2) {
        this.linePaint.setColor(this.getColor(color2));
        return this;
    }

    public TimeLineDecoration setLineWidth(@FloatRange(from=0.0) float width) {
        this.lineWidth = this.dp2px(width);
        return this;
    }

    public TimeLineDecoration setLeftDistance(@IntRange(from=0L) int distance) {
        this.leftDistance = this.dp2px(distance);
        return this;
    }

    public TimeLineDecoration setTopDistance(@IntRange(from=0L) int distance) {
        this.topDistance = this.dp2px(distance);
        return this;
    }

    public TimeLineDecoration setMarkerColor(@ColorRes int color2) {
        this.markerPaint.setColor(this.getColor(color2));
        return this;
    }

    public TimeLineDecoration setMarkerRadius(@FloatRange(from=0.0) float radius) {
        this.markerRadius = this.dp2px(radius);
        return this;
    }

    public TimeLineDecoration setBeginMarkerRadius(@FloatRange(from=0.0) float radius) {
        this.beginMarkerRadius = this.dp2px(radius);
        return this;
    }

    public TimeLineDecoration setBeginMarker(@DrawableRes int resId) {
        return this.setBeginMarker(this.getDrawable(resId));
    }

    public TimeLineDecoration setBeginMarker(@NonNull Drawable drawable) {
        this.beginMarker = drawable;
        this.beginMarkerRadius = this.beginMarker.getIntrinsicWidth() / 2;
        return this;
    }

    public TimeLineDecoration setEndMarkerRadius(@FloatRange(from=0.0) float radius) {
        this.endMarkerRadius = this.dp2px(radius);
        return this;
    }

    public TimeLineDecoration setEndMarker(@DrawableRes int resId) {
        return this.setEndMarker(this.getDrawable(resId));
    }

    public TimeLineDecoration setEndMarker(@NonNull Drawable drawable) {
        this.endMarker = drawable;
        this.endMarkerRadius = this.endMarker.getIntrinsicWidth() / 2;
        return this;
    }

    public TimeLineDecoration setNormalMarkerRadius(@FloatRange(from=0.0) float radius) {
        this.normalMarkerRadius = this.dp2px(radius);
        return this;
    }

    public TimeLineDecoration setNormalMarker(@DrawableRes int resId) {
        return this.setNormalMarker(this.getDrawable(resId));
    }

    public TimeLineDecoration setNormalMarker(@NonNull Drawable drawable) {
        this.normalMarker = drawable;
        this.normalMarkerRadius = this.normalMarker.getIntrinsicWidth() / 2;
        return this;
    }

    public TimeLineDecoration setCustomMarker(@DrawableRes int resId) {
        return this.setCustomMarker(this.getDrawable(resId));
    }

    public TimeLineDecoration setCustomMarker(@NonNull Drawable drawable) {
        this.customMarker = drawable;
        this.customMarkerRadius = this.customMarker.getIntrinsicWidth() / 2;
        return this;
    }

    public TimeLineDecoration setCallback(@Nullable TimeLineCallback callback) {
        this.callback = callback;
        return this;
    }

    private int dp2px(@FloatRange(from=0.0) float dpValue) {
        return TimeLineDecoration.dp2px(this.context, dpValue);
    }

    public static int dp2px(Context context, @FloatRange(from=0.0) float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private Drawable getDrawable(@DrawableRes int resId) {
        return ContextCompat.getDrawable((Context)this.context, (int)resId);
    }

    @ColorInt
    private int getColor(@ColorRes int resId) {
        return ContextCompat.getColor((Context)this.context, (int)resId);
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        if (this.callback == null) {
            return;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(view);
            if (!this.callback.isShowDivider(position)) continue;
            this.drawDivider(canvas, view, parent.getRight());
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.callback == null) {
            outRect.set(0, 0, 0, 0);
        } else {
            Rect rect = this.callback.getRect(parent.getChildAdapterPosition(view));
            outRect.set(rect == null ? new Rect() : rect);
        }
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        if (this.callback == null) {
            return;
        }
        int childCount = parent.getChildCount();
        block9: for (int i = 0; i < childCount; ++i) {
            View view = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(view);
            Rect rect = this.callback.getRect(position);
            int bottomMargin = ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).bottomMargin + (rect == null ? 0 : rect.bottom);
            int topMargin = ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).topMargin + (rect == null ? 0 : rect.top);
            switch (this.callback.getTimeLineType(position)) {
                case 0: {
                    this.drawLine(canvas, view.getTop() - topMargin, view.getBottom() + bottomMargin);
                    this.drawMarkerOrCircle(canvas, view, this.normalMarker, this.normalMarkerRadius);
                    continue block9;
                }
                case 1: {
                    this.drawLine(canvas, view.getTop() + this.topDistance + this.beginMarkerRadius, view.getBottom() + bottomMargin);
                    this.drawMarkerOrCircle(canvas, view, this.beginMarker, this.beginMarkerRadius);
                    continue block9;
                }
                case 2: {
                    this.drawLine(canvas, view.getTop() - topMargin, view.getTop() + bottomMargin + this.topDistance + (this.endMarker == null ? this.markerRadius : this.endMarkerRadius));
                    this.drawMarkerOrCircle(canvas, view, this.endMarker, this.endMarkerRadius);
                    continue block9;
                }
                case 3: {
                    this.drawLine(canvas, view.getTop() - topMargin, parent.getBottom());
                    this.drawMarkerOrCircle(canvas, view, this.endMarker, this.endMarkerRadius);
                    continue block9;
                }
                case 4: {
                    this.drawLine(canvas, view.getTop() - topMargin, view.getBottom() + bottomMargin);
                    continue block9;
                }
                case 5: {
                    this.drawLine(canvas, view.getTop() - topMargin, parent.getBottom());
                    continue block9;
                }
                case 6: {
                    this.drawLine(canvas, view.getTop() - topMargin, view.getBottom() + bottomMargin);
                    this.drawMarkerOrCircle(canvas, view, this.customMarker, this.customMarkerRadius);
                }
            }
        }
    }

    private void drawDivider(Canvas canvas, View view, int right) {
        canvas.drawRect(this.dividerPaddingLeft, (float)view.getBottom() - this.dividerHeight, (float)right - this.dividerPaddingRight, (float)view.getBottom(), this.dividerPaint);
    }

    private void drawLine(Canvas canvas, float top, float bottom) {
        canvas.drawRect((float)this.leftDistance, top, (float)(this.leftDistance + this.lineWidth), bottom, this.linePaint);
    }

    private void drawMarkerOrCircle(Canvas canvas, View view, Drawable marker, int radius) {
        if (marker != null) {
            this.drawMarker(canvas, view, marker, radius);
        } else {
            this.drawCircle(canvas, view);
        }
    }

    private void drawCircle(Canvas canvas, View view) {
        canvas.drawCircle((float)(this.leftDistance + this.lineWidth / 2), (float)(view.getTop() + this.topDistance + this.markerRadius * 2), (float)this.markerRadius, this.markerPaint);
    }

    private void drawMarker(Canvas canvas, View view, Drawable marker, int radius) {
        marker.setBounds(this.leftDistance + this.lineWidth / 2 - radius, view.getTop() + this.topDistance, this.leftDistance + this.lineWidth / 2 + radius, view.getTop() + this.topDistance + radius * 2);
        marker.draw(canvas);
    }

    public static interface TimeLineCallback {
        public boolean isShowDivider(int var1);

        @Nullable
        public Rect getRect(int var1);

        public int getTimeLineType(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeLineType {
    }
}

