/*
 * Decompiled with CFR 0.152.
 */
package upack;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import upack.MsgPackWriter$;
import upack.MsgVisitor;
import upickle.core.ArrVisitor;
import upickle.core.ByteBuilder;
import upickle.core.ByteBuilder$;
import upickle.core.ObjVisitor;
import upickle.core.Visitor;

public class MsgPackWriter<T extends OutputStream>
implements MsgVisitor<T, T> {
    public final T upack$MsgPackWriter$$out;
    public final ByteBuilder upack$MsgPackWriter$$byteBuilder;
    public int upack$MsgPackWriter$$depth;

    public static <T extends OutputStream> ByteArrayOutputStream $lessinit$greater$default$1() {
        return MsgPackWriter$.MODULE$.$lessinit$greater$default$1();
    }

    public MsgPackWriter(T out) {
        this.upack$MsgPackWriter$$out = out;
        this.upack$MsgPackWriter$$byteBuilder = new ByteBuilder(ByteBuilder$.MODULE$.$lessinit$greater$default$1());
        this.upack$MsgPackWriter$$depth = 0;
    }

    public void flushElemBuilder() {
        this.upack$MsgPackWriter$$byteBuilder.writeOutToIfLongerThan(this.upack$MsgPackWriter$$out, this.upack$MsgPackWriter$$depth == 0 ? 0 : 1000);
    }

    public ArrVisitor<T, T> visitArray(int length, int index) {
        return new ArrVisitor<T, T>(length, this){
            private final /* synthetic */ MsgPackWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Predef$.MODULE$.require(length$1 != -1, MsgPackWriter::upack$MsgPackWriter$$anon$1$$_$$lessinit$greater$$anonfun$1);
                ++$outer.upack$MsgPackWriter$$depth;
                if (length$1 <= 15) {
                    $outer.upack$MsgPackWriter$$byteBuilder.append(0x90 | length$1);
                } else if (length$1 <= 65535) {
                    $outer.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
                    byte[] arr = $outer.upack$MsgPackWriter$$byteBuilder.arr();
                    int arrLength = $outer.upack$MsgPackWriter$$byteBuilder.length();
                    arr[arrLength] = (byte)220;
                    $outer.writeUInt16(arr, arrLength, length$1);
                    $outer.upack$MsgPackWriter$$byteBuilder.length_$eq($outer.upack$MsgPackWriter$$byteBuilder.length() + 3);
                } else {
                    $outer.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
                    byte[] arr = $outer.upack$MsgPackWriter$$byteBuilder.arr();
                    int arrLength = $outer.upack$MsgPackWriter$$byteBuilder.length();
                    arr[arrLength] = (byte)221;
                    $outer.writeUInt32(arr, arrLength, length$1);
                    $outer.upack$MsgPackWriter$$byteBuilder.length_$eq($outer.upack$MsgPackWriter$$byteBuilder.length() + 5);
                }
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public void visitValue(OutputStream v, int index) {
            }

            public OutputStream visitEnd(int index) {
                --this.$outer.upack$MsgPackWriter$$depth;
                this.$outer.flushElemBuilder();
                return this.$outer.upack$MsgPackWriter$$out;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{upack$MsgPackWriter$$anon$1$$_$$lessinit$greater$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public ObjVisitor<T, T> visitObject(int length, boolean jsonableKeys, int index) {
        return new ObjVisitor<T, T>(length, this){
            private final /* synthetic */ MsgPackWriter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Predef$.MODULE$.require(length$2 != -1, MsgPackWriter::upack$MsgPackWriter$$anon$2$$_$$lessinit$greater$$anonfun$2);
                ++$outer.upack$MsgPackWriter$$depth;
                if (length$2 <= 15) {
                    $outer.upack$MsgPackWriter$$byteBuilder.append(0x80 | length$2);
                } else if (length$2 <= 65535) {
                    $outer.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
                    byte[] arr = $outer.upack$MsgPackWriter$$byteBuilder.arr();
                    int arrLength = $outer.upack$MsgPackWriter$$byteBuilder.length();
                    arr[arrLength] = (byte)222;
                    $outer.writeUInt16(arr, arrLength, length$2);
                    $outer.upack$MsgPackWriter$$byteBuilder.length_$eq($outer.upack$MsgPackWriter$$byteBuilder.length() + 3);
                } else {
                    $outer.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
                    byte[] arr = $outer.upack$MsgPackWriter$$byteBuilder.arr();
                    int arrLength = $outer.upack$MsgPackWriter$$byteBuilder.length();
                    arr[arrLength] = (byte)223;
                    $outer.writeUInt32(arr, arrLength, length$2);
                    $outer.upack$MsgPackWriter$$byteBuilder.length_$eq($outer.upack$MsgPackWriter$$byteBuilder.length() + 5);
                }
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public Visitor visitKey(int index) {
                return this.$outer;
            }

            public void visitKeyValue(Object s) {
            }

            public void visitValue(OutputStream v, int index) {
            }

            public OutputStream visitEnd(int index) {
                --this.$outer.upack$MsgPackWriter$$depth;
                this.$outer.flushElemBuilder();
                return this.$outer.upack$MsgPackWriter$$out;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{upack$MsgPackWriter$$anon$2$$_$$lessinit$greater$$anonfun$2()}, serializedLambda);
            }
        };
    }

    public T visitNull(int index) {
        this.upack$MsgPackWriter$$byteBuilder.append(192);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitFalse(int index) {
        this.upack$MsgPackWriter$$byteBuilder.append(194);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitTrue(int index) {
        this.upack$MsgPackWriter$$byteBuilder.append(195);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    @Override
    public T visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return (T)this.visitFloat64(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s.toString())), index);
    }

    public T visitFloat64(double d, int index) {
        this.upack$MsgPackWriter$$byteBuilder.ensureLength(9);
        byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
        int length = this.upack$MsgPackWriter$$byteBuilder.length();
        arr[length] = (byte)203;
        this.writeUInt64(arr, length, Double.doubleToLongBits(d));
        this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 9);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitFloat32(float d, int index) {
        this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
        byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
        int length = this.upack$MsgPackWriter$$byteBuilder.length();
        arr[length] = (byte)202;
        this.writeUInt32(arr, length, Float.floatToIntBits(d));
        this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitInt32(int i, int index) {
        if (i >= 0) {
            if (i <= 127) {
                this.upack$MsgPackWriter$$byteBuilder.append(i);
            } else if (i <= 255) {
                this.upack$MsgPackWriter$$byteBuilder.ensureLength(2);
                byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                int length = this.upack$MsgPackWriter$$byteBuilder.length();
                arr[length] = (byte)204;
                arr[length + 1] = (byte)i;
                this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 2);
            } else if (i <= Short.MAX_VALUE) {
                this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
                byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                int length = this.upack$MsgPackWriter$$byteBuilder.length();
                arr[length] = (byte)209;
                this.writeUInt16(arr, length, i);
                this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
            } else if (i <= 65535) {
                this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
                byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                int length = this.upack$MsgPackWriter$$byteBuilder.length();
                arr[length] = (byte)205;
                this.writeUInt16(arr, length, i);
                this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
            } else {
                this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
                byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                int length = this.upack$MsgPackWriter$$byteBuilder.length();
                arr[length] = (byte)210;
                this.writeUInt32(arr, length, i);
                this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
            }
        } else if (i >= -32) {
            this.upack$MsgPackWriter$$byteBuilder.append(i | 0xE0);
        } else if (i >= -128) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(2);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)208;
            arr[length + 1] = (byte)i;
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 2);
        } else if (i >= Short.MIN_VALUE) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)209;
            this.writeUInt16(arr, length, i);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
        } else {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)210;
            this.writeUInt32(arr, length, i);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
        }
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitInt64(long i, int index) {
        Object object;
        if (i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) {
            object = this.visitInt32((int)i, index);
        } else if (i >= 0L && i <= 0xFFFFFFFFL) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)206;
            this.writeUInt32(arr, length, (int)i);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
            object = BoxedUnit.UNIT;
        } else {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(9);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)211;
            this.writeUInt64(arr, length, i);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 9);
            object = BoxedUnit.UNIT;
        }
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitUInt64(long i, int index) {
        Object object;
        if (i >= 0L) {
            object = this.visitInt64(i, index);
        } else {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(9);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)207;
            this.writeUInt64(arr, length, i);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 9);
            object = BoxedUnit.UNIT;
        }
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitString(CharSequence s, int index) {
        byte[] strBytes = s.toString().getBytes(StandardCharsets.UTF_8);
        int strLength = strBytes.length;
        if (strLength <= 31) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(1 + strLength);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)(0xA0 | strLength);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 1);
        } else if (strLength <= 255) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(2 + strLength);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)217;
            this.writeUInt8(arr, length, strLength);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 2);
        } else if (strLength <= 65535) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(3 + strLength);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)218;
            this.writeUInt16(arr, length, strLength);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
        } else {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(5 + strLength);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)219;
            this.writeUInt32(arr, length, strLength);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
        }
        this.upack$MsgPackWriter$$byteBuilder.appendAll(strBytes, strLength);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitBinary(byte[] bytes, int offset, int len, int index) {
        if (len <= 255) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(2);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)196;
            this.writeUInt8(arr, length, len);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 2);
        } else if (len <= 65535) {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)197;
            this.writeUInt16(arr, length, len);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
        } else {
            this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
            byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
            int length = this.upack$MsgPackWriter$$byteBuilder.length();
            arr[length] = (byte)198;
            this.writeUInt32(arr, length, len);
            this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
        }
        this.upack$MsgPackWriter$$byteBuilder.appendAll(bytes, offset, len);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public void writeUInt8(byte[] arr, int length, int i) {
        arr[length + 1] = (byte)i;
    }

    public void writeUInt16(byte[] arr, int length, int i) {
        arr[length + 1] = (byte)(i >> 8 & 0xFF);
        arr[length + 2] = (byte)(i >> 0 & 0xFF);
    }

    public void writeUInt32(byte[] arr, int length, int i) {
        arr[length + 1] = (byte)(i >> 24 & 0xFF);
        arr[length + 2] = (byte)(i >> 16 & 0xFF);
        arr[length + 3] = (byte)(i >> 8 & 0xFF);
        arr[length + 4] = (byte)(i >> 0 & 0xFF);
    }

    public void writeUInt64(byte[] arr, int length, long i) {
        arr[length + 1] = (byte)(i >> 56 & 0xFFL);
        arr[length + 2] = (byte)(i >> 48 & 0xFFL);
        arr[length + 3] = (byte)(i >> 40 & 0xFFL);
        arr[length + 4] = (byte)(i >> 32 & 0xFFL);
        arr[length + 5] = (byte)(i >> 24 & 0xFFL);
        arr[length + 6] = (byte)(i >> 16 & 0xFFL);
        arr[length + 7] = (byte)(i >> 8 & 0xFFL);
        arr[length + 8] = (byte)(i >> 0 & 0xFFL);
    }

    public T visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
        int n = len;
        switch (n) {
            case 1: {
                this.upack$MsgPackWriter$$byteBuilder.append(212);
                break;
            }
            case 2: {
                this.upack$MsgPackWriter$$byteBuilder.append(213);
                break;
            }
            case 4: {
                this.upack$MsgPackWriter$$byteBuilder.append(214);
                break;
            }
            case 8: {
                this.upack$MsgPackWriter$$byteBuilder.append(215);
                break;
            }
            case 16: {
                this.upack$MsgPackWriter$$byteBuilder.append(216);
                break;
            }
            default: {
                if (len <= 255) {
                    this.upack$MsgPackWriter$$byteBuilder.ensureLength(2);
                    byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                    int length = this.upack$MsgPackWriter$$byteBuilder.length();
                    arr[length] = (byte)199;
                    this.writeUInt8(arr, length, len);
                    this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 2);
                    break;
                }
                if (len <= 65535) {
                    this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
                    byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                    int length = this.upack$MsgPackWriter$$byteBuilder.length();
                    arr[length] = (byte)200;
                    this.writeUInt16(arr, length, len);
                    this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
                    break;
                }
                this.upack$MsgPackWriter$$byteBuilder.ensureLength(5);
                byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
                int length = this.upack$MsgPackWriter$$byteBuilder.length();
                this.writeUInt32(arr, length, len);
                arr[length] = (byte)201;
                this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 5);
                break;
            }
        }
        this.upack$MsgPackWriter$$byteBuilder.append(tag);
        this.upack$MsgPackWriter$$byteBuilder.appendAll(bytes, offset, len);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public T visitChar(char s, int index) {
        this.upack$MsgPackWriter$$byteBuilder.ensureLength(3);
        byte[] arr = this.upack$MsgPackWriter$$byteBuilder.arr();
        int length = this.upack$MsgPackWriter$$byteBuilder.length();
        arr[length] = (byte)205;
        this.writeUInt16(arr, length, Char$.MODULE$.char2int(s));
        this.upack$MsgPackWriter$$byteBuilder.length_$eq(length + 3);
        this.flushElemBuilder();
        return this.upack$MsgPackWriter$$out;
    }

    public void writeUInt8(int i) {
        this.writeUInt8(this.upack$MsgPackWriter$$byteBuilder.arr(), this.upack$MsgPackWriter$$byteBuilder.length(), i);
    }

    public void writeUInt16(int i) {
        this.writeUInt16(this.upack$MsgPackWriter$$byteBuilder.arr(), this.upack$MsgPackWriter$$byteBuilder.length(), i);
    }

    public void writeUInt32(int i) {
        this.writeUInt32(this.upack$MsgPackWriter$$byteBuilder.arr(), this.upack$MsgPackWriter$$byteBuilder.length(), i);
    }

    public void writeUInt64(long i) {
        this.writeUInt64(this.upack$MsgPackWriter$$byteBuilder.arr(), this.upack$MsgPackWriter$$byteBuilder.length(), i);
    }

    public static final Object upack$MsgPackWriter$$anon$1$$_$$lessinit$greater$$anonfun$1() {
        return "Length of upack array must be known up front";
    }

    public static final Object upack$MsgPackWriter$$anon$2$$_$$lessinit$greater$$anonfun$2() {
        return "Length of upack object must be known up front";
    }
}

