/*
 * Decompiled with CFR 0.152.
 */
package upack;

import scala.Byte$;
import scala.Float$;
import scala.MatchError;
import scala.Predef$;
import scala.Short$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;
import upickle.core.ArrVisitor;
import upickle.core.BufferingByteParser;
import upickle.core.ObjVisitor;
import upickle.core.Visitor;

public abstract class BaseMsgPackReader
implements BufferingByteParser {
    private byte[] upickle$core$BufferingByteParser$$buffer;
    private int upickle$core$BufferingByteParser$$bufferGrowCount;
    private int upickle$core$BufferingByteParser$$bufferCopyCount;
    private int upickle$core$BufferingByteParser$$firstIdx;
    private int upickle$core$BufferingByteParser$$lastIdx;
    private int upickle$core$BufferingByteParser$$dropped;
    private int upickle$core$BufferingByteParser$$knownEof;
    private int index;

    public BaseMsgPackReader() {
        BufferingByteParser.$init$((BufferingByteParser)this);
        this.index = 0;
    }

    public byte[] upickle$core$BufferingByteParser$$buffer() {
        return this.upickle$core$BufferingByteParser$$buffer;
    }

    public int upickle$core$BufferingByteParser$$bufferGrowCount() {
        return this.upickle$core$BufferingByteParser$$bufferGrowCount;
    }

    public int upickle$core$BufferingByteParser$$bufferCopyCount() {
        return this.upickle$core$BufferingByteParser$$bufferCopyCount;
    }

    public int upickle$core$BufferingByteParser$$firstIdx() {
        return this.upickle$core$BufferingByteParser$$firstIdx;
    }

    public int upickle$core$BufferingByteParser$$lastIdx() {
        return this.upickle$core$BufferingByteParser$$lastIdx;
    }

    public int upickle$core$BufferingByteParser$$dropped() {
        return this.upickle$core$BufferingByteParser$$dropped;
    }

    public int upickle$core$BufferingByteParser$$knownEof() {
        return this.upickle$core$BufferingByteParser$$knownEof;
    }

    public void upickle$core$BufferingByteParser$$buffer_$eq(byte[] x$1) {
        this.upickle$core$BufferingByteParser$$buffer = x$1;
    }

    public void upickle$core$BufferingByteParser$$bufferGrowCount_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$bufferGrowCount = x$1;
    }

    public void upickle$core$BufferingByteParser$$bufferCopyCount_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$bufferCopyCount = x$1;
    }

    public void upickle$core$BufferingByteParser$$firstIdx_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$firstIdx = x$1;
    }

    public void upickle$core$BufferingByteParser$$lastIdx_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$lastIdx = x$1;
    }

    public void upickle$core$BufferingByteParser$$dropped_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$dropped = x$1;
    }

    public void upickle$core$BufferingByteParser$$knownEof_$eq(int x$1) {
        this.upickle$core$BufferingByteParser$$knownEof = x$1;
    }

    public int getIndex() {
        return this.index;
    }

    public <T> T parse(Visitor<?, T> visitor) {
        byte n = this.getByteSafe(this.index);
        int n2 = n & 0xFF;
        switch (n2) {
            case 192: {
                ++this.index;
                return (T)visitor.visitNull(this.index);
            }
            case 194: {
                ++this.index;
                return (T)visitor.visitFalse(this.index);
            }
            case 195: {
                ++this.index;
                return (T)visitor.visitTrue(this.index);
            }
            case 196: {
                return this.parseBin(this.parseUInt8(this.index + 1), visitor);
            }
            case 197: {
                return this.parseBin(this.parseUInt16(this.index + 1), visitor);
            }
            case 198: {
                return this.parseBin(this.parseUInt32(this.index + 1), visitor);
            }
            case 199: {
                return this.parseExt(this.parseUInt8(this.index + 1), visitor);
            }
            case 200: {
                return this.parseExt(this.parseUInt16(this.index + 1), visitor);
            }
            case 201: {
                return this.parseExt(this.parseUInt32(this.index + 1), visitor);
            }
            case 202: {
                return (T)visitor.visitFloat64(Float$.MODULE$.float2double(Float.intBitsToFloat(this.parseUInt32(this.index + 1))), this.index);
            }
            case 203: {
                return (T)visitor.visitFloat64(Double.longBitsToDouble(this.parseUInt64(this.index + 1)), this.index);
            }
            case 204: {
                return (T)visitor.visitInt32(this.parseUInt8(this.index + 1), this.index);
            }
            case 205: {
                return (T)visitor.visitInt32(this.parseUInt16(this.index + 1), this.index);
            }
            case 206: {
                return (T)visitor.visitInt64((long)this.parseUInt32(this.index + 1) & 0xFFFFFFFFL, this.index);
            }
            case 207: {
                return (T)visitor.visitUInt64(this.parseUInt64(this.index + 1), this.index);
            }
            case 208: {
                return (T)visitor.visitInt32(Byte$.MODULE$.byte2int((byte)this.parseUInt8(this.index + 1)), this.index);
            }
            case 209: {
                return (T)visitor.visitInt32(Short$.MODULE$.short2int((short)this.parseUInt16(this.index + 1)), this.index);
            }
            case 210: {
                return (T)visitor.visitInt32(this.parseUInt32(this.index + 1), this.index);
            }
            case 211: {
                return (T)visitor.visitInt64(this.parseUInt64(this.index + 1), this.index);
            }
            case 212: {
                ++this.index;
                return this.parseExt(1, visitor);
            }
            case 213: {
                ++this.index;
                return this.parseExt(2, visitor);
            }
            case 214: {
                ++this.index;
                return this.parseExt(4, visitor);
            }
            case 215: {
                ++this.index;
                return this.parseExt(8, visitor);
            }
            case 216: {
                ++this.index;
                return this.parseExt(16, visitor);
            }
            case 217: {
                return this.parseStr(this.parseUInt8(this.index + 1), visitor);
            }
            case 218: {
                return this.parseStr(this.parseUInt16(this.index + 1), visitor);
            }
            case 219: {
                return this.parseStr(this.parseUInt32(this.index + 1), visitor);
            }
            case 220: {
                return this.parseArray(this.parseUInt16(this.index + 1), visitor);
            }
            case 221: {
                return this.parseArray(this.parseUInt32(this.index + 1), visitor);
            }
            case 222: {
                return this.parseMap(this.parseUInt16(this.index + 1), visitor);
            }
            case 223: {
                return this.parseMap(this.parseUInt32(this.index + 1), visitor);
            }
        }
        int x = n2;
        if (x <= 127) {
            ++this.index;
            return (T)visitor.visitInt32(x & 0x7F, this.index);
        }
        if (x <= 143) {
            int n3 = x & 0xF;
            ++this.index;
            return this.parseMap(n3, visitor);
        }
        if (x <= 159) {
            int n4 = x & 0xF;
            ++this.index;
            return this.parseArray(n4, visitor);
        }
        if (x <= 191) {
            int n5 = x & 0x1F;
            ++this.index;
            return this.parseStr(n5, visitor);
        }
        if (x >= 224) {
            ++this.index;
            return (T)visitor.visitInt32(x | 0xFFFFFFE0, this.index);
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public <T> T parseExt(int n, Visitor<?, T> visitor) {
        Tuple3 tuple3 = this.sliceArr(this.index + 1, n);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        byte[] arr = (byte[])tuple3._1();
        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)arr, (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j));
        byte[] arr2 = (byte[])tuple32._1();
        int i2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int j2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Object res = visitor.visitExt(this.getByteSafe(this.index), arr2, i2, j2, this.index);
        this.index += n + 1;
        return (T)res;
    }

    public <T> T parseStr(int n, Visitor<?, T> visitor) {
        Object res = visitor.visitString((CharSequence)this.sliceString(this.index, this.index + n), this.index);
        this.index += n;
        return (T)res;
    }

    public <T> T parseBin(int n, Visitor<?, T> visitor) {
        Tuple3 tuple3 = this.sliceArr(this.index, n);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        byte[] arr = (byte[])tuple3._1();
        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)arr, (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j));
        byte[] arr2 = (byte[])tuple32._1();
        int i2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int j2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Object res = visitor.visitBinary(arr2, i2, j2, this.index);
        this.index += n;
        return (T)res;
    }

    public <T> T parseMap(int n, Visitor<?, T> visitor) {
        ObjVisitor obj = visitor.visitObject(n, true, this.index);
        for (int i = 0; i < n; ++i) {
            Visitor keyVisitor = obj.visitKey(this.index);
            obj.visitKeyValue(this.parse(keyVisitor));
            obj.narrow().visitValue(this.parse(obj.subVisitor()), this.index);
            this.dropBufferUntil(this.index);
        }
        return (T)obj.visitEnd(this.index);
    }

    public <T> T parseArray(int n, Visitor<?, T> visitor) {
        ArrVisitor arr = visitor.visitArray(n, this.index);
        for (int i = 0; i < n; ++i) {
            T v = this.parse(arr.subVisitor());
            arr.narrow().visitValue(v, this.index);
            this.dropBufferUntil(this.index);
        }
        return (T)arr.visitEnd(this.index);
    }

    public int parseUInt8(int i) {
        this.index = i + 1;
        return this.getByteSafe(i) & 0xFF;
    }

    public int parseUInt16(int i) {
        this.index = i + 2;
        this.requestUntil(i + 1);
        return (this.getByteUnsafe(i) & 0xFF) << 8 | this.getByteUnsafe(i + 1) & 0xFF;
    }

    public int parseUInt32(int i) {
        this.index = i + 4;
        this.requestUntil(i + 3);
        return (this.getByteUnsafe(i) & 0xFF) << 24 | (this.getByteUnsafe(i + 1) & 0xFF) << 16 | (this.getByteUnsafe(i + 2) & 0xFF) << 8 | this.getByteUnsafe(i + 3) & 0xFF;
    }

    public long parseUInt64(int i) {
        this.index = i + 8;
        this.requestUntil(i + 7);
        return ((long)this.getByteUnsafe(i + 0) & 0xFFL) << 56 | ((long)this.getByteUnsafe(i + 1) & 0xFFL) << 48 | ((long)this.getByteUnsafe(i + 2) & 0xFFL) << 40 | ((long)this.getByteUnsafe(i + 3) & 0xFFL) << 32 | ((long)this.getByteUnsafe(i + 4) & 0xFFL) << 24 | ((long)this.getByteUnsafe(i + 5) & 0xFFL) << 16 | ((long)this.getByteUnsafe(i + 6) & 0xFFL) << 8 | ((long)this.getByteUnsafe(i + 7) & 0xFFL) << 0;
    }
}

