/*
 * Decompiled with CFR 0.152.
 */
package com.lihaodong.pdf.http;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;

public class OkHttpClientManager {
    private static OkHttpClientManager mInstance;
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private Handler mDelivery;

    private OkHttpClientManager() {
        this.mOkHttpClient.setCookieHandler((CookieHandler)new CookieManager(null, CookiePolicy.ACCEPT_ORIGINAL_SERVER));
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClientManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<OkHttpClientManager> clazz = OkHttpClientManager.class;
        synchronized (OkHttpClientManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void _downloadAsyn(final String url, final String fileName, final String destFileDir, final ResultCallback callback) {
        Request request = new Request.Builder().url(url).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                OkHttpClientManager.this.sendFailedStringCallback(request, e, callback);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Response response) {
                InputStream is = null;
                byte[] buf = new byte[2048];
                int sum = 0;
                int len = 0;
                FileOutputStream fos = null;
                try {
                    is = response.body().byteStream();
                    long total = response.body().contentLength();
                    String savePath = OkHttpClientManager.this.isExistDir(destFileDir);
                    File file = new File(savePath, OkHttpClientManager.this.getFileName(url, fileName));
                    fos = new FileOutputStream(file);
                    int a = 0;
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                        int progress = (int)((float)(sum += len) * 1.0f / (float)total * 100.0f);
                        if (a == progress) continue;
                        a = progress;
                        OkHttpClientManager.this.setDownloadingResultCallback(progress, callback);
                    }
                    fos.flush();
                    OkHttpClientManager.this.sendSuccessResultCallback(file, callback);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    OkHttpClientManager.this.sendFailedStringCallback(response.request(), e, callback);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        OkHttpClientManager.this.sendFailedStringCallback(response.request(), e, callback);
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        OkHttpClientManager.this.sendFailedStringCallback(response.request(), e, callback);
                    }
                }
            }
        });
    }

    private String isExistDir(String saveDir) throws IOException {
        File downloadFile = new File(saveDir);
        if (!downloadFile.mkdirs()) {
            downloadFile.createNewFile();
        }
        String savePath = downloadFile.getAbsolutePath();
        return savePath;
    }

    private String getFileName(String path, String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            int separatorIndex = path.lastIndexOf("/");
            return separatorIndex < 0 ? path : path.substring(separatorIndex + 1, path.length());
        }
        return fileName;
    }

    public static void downloadAsyn(String url, String fileName, String destDir, ResultCallback callback) {
        OkHttpClientManager.getInstance()._downloadAsyn(url, fileName, destDir, callback);
    }

    private void sendFailedStringCallback(final Request request, final Exception e, final ResultCallback callback) {
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onError(request, e);
                }
            }
        });
    }

    private void sendSuccessResultCallback(final File file, final ResultCallback callback) {
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onResponse(file);
                }
            }
        });
    }

    private void setDownloadingResultCallback(final int object, final ResultCallback callback) {
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onDownloading(object);
                }
            }
        });
    }

    public static abstract class ResultCallback {
        public abstract void onError(Request var1, Exception var2);

        public abstract void onResponse(File var1);

        public abstract void onDownloading(int var1);
    }
}

