/*
 * Decompiled with CFR 0.152.
 */
package com.lihaodong.pdf;

import android.graphics.PointF;
import com.lihaodong.pdf.PDFView;
import com.lihaodong.pdf.util.DragPinchListener;

class DragPinchManager
implements DragPinchListener.OnDragListener,
DragPinchListener.OnPinchListener,
DragPinchListener.OnDoubleTapListener {
    private PDFView pdfView;
    private DragPinchListener dragPinchListener;
    private long startDragTime;
    private float startDragX;
    private float startDragY;
    private boolean isSwipeEnabled;
    private boolean swipeVertical;

    public DragPinchManager(PDFView pdfView) {
        this.pdfView = pdfView;
        this.isSwipeEnabled = false;
        this.swipeVertical = pdfView.isSwipeVertical();
        this.dragPinchListener = new DragPinchListener();
        this.dragPinchListener.setOnDragListener(this);
        this.dragPinchListener.setOnPinchListener(this);
        this.dragPinchListener.setOnDoubleTapListener(this);
        pdfView.setOnTouchListener(this.dragPinchListener);
    }

    public void enableDoubletap(boolean enableDoubletap) {
        if (enableDoubletap) {
            this.dragPinchListener.setOnDoubleTapListener(this);
        } else {
            this.dragPinchListener.setOnDoubleTapListener(null);
        }
    }

    @Override
    public void onPinch(float dr, PointF pivot) {
        float wantedZoom = this.pdfView.getZoom() * dr;
        if (wantedZoom < 1.0f) {
            dr = 1.0f / this.pdfView.getZoom();
        } else if (wantedZoom > 10.0f) {
            dr = 10.0f / this.pdfView.getZoom();
        }
        this.pdfView.zoomCenteredRelativeTo(dr, pivot);
    }

    @Override
    public void startDrag(float x, float y) {
        this.startDragTime = System.currentTimeMillis();
        this.startDragX = x;
        this.startDragY = y;
    }

    @Override
    public void onDrag(float dx, float dy) {
        if (this.isZooming() || this.isSwipeEnabled) {
            this.pdfView.moveRelativeTo(dx, dy);
        }
    }

    @Override
    public void endDrag(float x, float y) {
        if (!this.isZooming()) {
            if (this.isSwipeEnabled) {
                int diff;
                float distance = this.swipeVertical ? y - this.startDragY : x - this.startDragX;
                long time = System.currentTimeMillis() - this.startDragTime;
                int n = diff = distance > 0.0f ? -1 : 1;
                if (this.isQuickMove(distance, time) || this.isPageChange(distance)) {
                    this.pdfView.showPage(this.pdfView.getCurrentPage() + diff);
                } else {
                    this.pdfView.showPage(this.pdfView.getCurrentPage());
                }
            }
        } else {
            this.pdfView.loadPages();
        }
    }

    public boolean isZooming() {
        return this.pdfView.isZooming();
    }

    private boolean isPageChange(float distance) {
        return Math.abs(distance) > Math.abs(this.pdfView.toCurrentScale(this.pdfView.getOptimalPageWidth()) / 2.0f);
    }

    private boolean isQuickMove(float dx, long dt) {
        return Math.abs(dx) >= 50.0f && dt <= 250L;
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.isSwipeEnabled = isSwipeEnabled;
    }

    @Override
    public void onDoubleTap(float x, float y) {
        if (this.isZooming()) {
            this.pdfView.resetZoomWithAnimation();
        }
    }

    public void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }
}

