/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal;

import android.os.MessageQueue;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.ItemUpdate;
import com.lightstreamer.client.LSLightstreamerClient;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.SubscriptionListener;
import com.lightstreamer.client.internal.ClientMachine;
import com.lightstreamer.client.internal.MpnBadgeResetRequest;
import com.lightstreamer.client.internal.MpnClientMachine;
import com.lightstreamer.client.internal.MpnFilterUnsubscriptionRequest;
import com.lightstreamer.client.internal.MpnRegisterRequest;
import com.lightstreamer.client.internal.MpnSubscriptionManager;
import com.lightstreamer.client.internal._ParseTools.ParseTools_Fields_;
import com.lightstreamer.client.mpn.LSMpnDevice;
import com.lightstreamer.client.mpn.LSMpnSubscription;
import com.lightstreamer.client.mpn.MpnSubscriptionStatus;
import com.lightstreamer.internal.MyArray;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.RequestBuilder;
import com.lightstreamer.internal.Set;
import com.lightstreamer.internal._ArrayTools.ArrayTools_Fields_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.IMap;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Lambda;
import haxe.root.Std;
import java.net.ProtocolFamily;
import java.nio.file.DirectoryStream;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;

@ClassReflectionInformation(hasSuperClass=true)
public class MpnClientMachine
extends ClientMachine {
    public MyArray<MpnSubscriptionManager> mpnSubscriptionManagers;
    public LSMpnDevice mpn_device;
    public String mpn_deviceId;
    public String mpn_deviceToken;
    public String mpn_adapterName;
    public Integer mpn_lastRegisterReqId;
    public Array<LSMpnDevice> mpn_candidate_devices;
    public LSSubscription mpn_deviceSubscription;
    public LSSubscription mpn_itemSubscription;
    public MpnDeviceDelegate mpn_deviceListener;
    public MpnItemDelegate mpn_itemListener;
    public Set<String> mpn_snapshotSet;
    public Array<MPNSubscriptionStatus> mpn_filter_pendings;
    public Integer mpn_filter_lastDeactivateReqId;
    public boolean mpn_badge_reset_requested;
    public Integer mpn_badge_lastResetReqId;
    public MpnRegisterRequest mpnRegisterRequest;
    public MpnFilterUnsubscriptionRequest mpnFilterUnsubscriptionRequest;
    public MpnBadgeResetRequest mpnBadgeResetRequest;

    @Override
    public boolean evtExtConnect_NextRegion() {
        MpnClientMachine _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_evtExtConnect_NextRegion_0(_gthis)));
    }

    public boolean evtExtConnect_MpnRegion() {
        boolean forward = true;
        if (this.state.s_mpn.m == 401) {
            this.state.s_mpn.m = 403;
            this.state.traceState();
            forward = this.evtExtConnect_NetworkReachabilityRegion();
            this.genSendMpnRegister();
        }
        if (forward) {
            this.evtExtConnect_NetworkReachabilityRegion();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean evtREQOK_Forward(int reqId) {
        this.traceEvent("mpn:REQOK");
        boolean forward = true;
        if (this.state.s_mpn.m == 403) {
            Integer n = this.mpn_lastRegisterReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.state.s_mpn.m = 404;
                this.state.traceState();
                return this.evtREQOK_TransportRegion(reqId);
            }
        }
        if (this.state.s_mpn.m == 406) {
            Integer n = this.mpn_lastRegisterReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.state.s_mpn.m = 407;
                this.state.traceState();
                return this.evtREQOK_TransportRegion(reqId);
            }
        }
        Integer n = this.state.s_mpn.tk;
        if (n == null ? false : Jvm.toInt(n) == 453) {
            Integer n2 = this.mpn_lastRegisterReqId;
            if (n2 == null ? false : reqId == Jvm.toInt(n2)) {
                this.state.s_mpn.tk = 454;
                this.state.traceState();
                return this.evtREQOK_TransportRegion(reqId);
            }
        }
        Integer n3 = this.state.s_mpn.ft;
        if (n3 == null ? false : Jvm.toInt(n3) == 432) {
            Integer n4 = this.mpn_filter_lastDeactivateReqId;
            if (n4 == null ? false : reqId == Jvm.toInt(n4)) {
                this.doREQMpnUnsubscribeFilter();
                this.state.s_mpn.ft = 430;
                this.state.traceState();
                forward = this.evtREQOK_TransportRegion(reqId);
                this.evtMpnCheckFilter();
                return forward;
            }
        }
        Integer n5 = this.state.s_mpn.bg;
        if (!(n5 == null ? false : Jvm.toInt(n5) == 442)) return forward;
        Integer n6 = this.mpn_badge_lastResetReqId;
        if (!(n6 == null ? false : reqId == Jvm.toInt(n6))) return forward;
        this.doREQOKMpnResetBadge();
        forward = this.evtREQOK_TransportRegion(reqId);
        this.state.s_mpn.bg = 440;
        this.state.traceState();
        this.evtMpnCheckReset();
        return forward;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean evtREQERR_Forward(int reqId, int code, String msg) {
        this.traceEvent("mpn:REQERR");
        boolean forward = true;
        if (this.state.s_mpn.m == 403) {
            Integer n = this.mpn_lastRegisterReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.notifyDeviceError(code, msg);
                this.state.s_mpn.m = 402;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                this.evtMpnCheckNext();
                return forward;
            }
        }
        if (this.state.s_mpn.m == 406) {
            Integer n = this.mpn_lastRegisterReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.notifyDeviceError(code, msg);
                this.state.s_mpn.m = 408;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                this.evtMpnCheckNext();
                return forward;
            }
        }
        Integer n = this.state.s_mpn.tk;
        if (n == null ? false : Jvm.toInt(n) == 453) {
            Integer n2 = this.mpn_lastRegisterReqId;
            if (n2 == null ? false : reqId == Jvm.toInt(n2)) {
                this.notifyDeviceError(code, msg);
                this.state.s_mpn.tk = 452;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                this.evtMpnCheckNext();
                return forward;
            }
        }
        Integer n3 = this.state.s_mpn.ft;
        if (n3 == null ? false : Jvm.toInt(n3) == 432) {
            Integer n4 = this.mpn_filter_lastDeactivateReqId;
            if (n4 == null ? false : reqId == Jvm.toInt(n4)) {
                this.doREQMpnUnsubscribeFilter();
                this.state.s_mpn.ft = 430;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                this.evtMpnCheckFilter();
                return forward;
            }
        }
        Integer n5 = this.state.s_mpn.bg;
        if (!(n5 == null ? false : Jvm.toInt(n5) == 442)) return forward;
        Integer n6 = this.mpn_badge_lastResetReqId;
        if (!(n6 == null ? false : reqId == Jvm.toInt(n6))) return forward;
        this.doREQERRMpnResetBadge();
        this.notifyOnBadgeResetFailed(code, msg);
        this.state.s_mpn.bg = 440;
        this.state.traceState();
        forward = this.evtREQERR_TransportRegion(reqId, code, msg);
        this.evtMpnCheckReset();
        return forward;
    }

    @Override
    public boolean evtRetry_NextRegion() {
        return this.evtRetry_MpnRegion();
    }

    public boolean evtRetry_MpnRegion() {
        switch (this.state.s_mpn.m) {
            default: {
                break;
            }
            case 403: 
            case 404: {
                this.state.s_mpn.m = 403;
                this.state.traceState();
                break;
            }
            case 405: {
                this.doRemoveMpnSpecialListeners();
                this.state.s_mpn.m = 406;
                this.state.s_mpn.st = null;
                this.state.s_mpn.tk = null;
                this.state.s_mpn.sbs = null;
                this.state.s_mpn.ft = null;
                this.state.s_mpn.bg = null;
                this.state.traceState();
                this.genUnsubscribeMpnSpecialItems();
                break;
            }
            case 406: 
            case 407: {
                this.state.s_mpn.m = 406;
                this.state.traceState();
            }
        }
        return false;
    }

    @Override
    public boolean evtTerminate_NextRegion() {
        return this.evtTerminate_MpnRegion();
    }

    public boolean evtTerminate_MpnRegion() {
        boolean forward = true;
        switch (this.state.s_mpn.m) {
            default: {
                break;
            }
            case 403: 
            case 404: {
                this.state.s_mpn.m = 401;
                this.state.traceState();
                forward = this.evtTerminate_NetworkReachabilityRegion();
                this.evtResetMpnDevice();
                break;
            }
            case 405: {
                this.doRemoveMpnSpecialListeners();
                this.state.s_mpn.m = 401;
                this.state.s_mpn.st = null;
                this.state.s_mpn.tk = null;
                this.state.s_mpn.sbs = null;
                this.state.s_mpn.ft = null;
                this.state.s_mpn.bg = null;
                this.state.traceState();
                forward = this.evtTerminate_NetworkReachabilityRegion();
                this.genUnsubscribeMpnSpecialItems();
                this.evtResetMpnDevice();
                break;
            }
            case 406: 
            case 407: {
                this.state.s_mpn.m = 401;
                this.state.traceState();
                forward = this.evtTerminate_NetworkReachabilityRegion();
                this.evtResetMpnDevice();
            }
        }
        if (forward) {
            this.evtTerminate_NetworkReachabilityRegion();
        }
        return false;
    }

    @Override
    public boolean evtMessage(String line) {
        if (!super.evtMessage(line)) {
            if (line.startsWith("MPNREG")) {
                Array args = StringExt.split(line, ",");
                String deviceId = (String)args.__get(1);
                String adapterName = (String)args.__get(2);
                this.evtMPNREG(deviceId, adapterName);
            } else if (line.startsWith("MPNZERO")) {
                Array args = StringExt.split(line, ",");
                String deviceId = (String)args.__get(1);
                this.evtMPNZERO(deviceId);
            } else if (line.startsWith("MPNOK")) {
                Array args = StringExt.split(line, ",");
                int subId = ParseTools_Fields_.parseInt((String)args.__get(1));
                String mpnSubId = (String)args.__get(2);
                this.evtMPNOK(subId, mpnSubId);
            } else if (line.startsWith("MPNDEL")) {
                Array args = StringExt.split(line, ",");
                String mpnSubId = (String)args.__get(1);
                this.evtMPNDEL(mpnSubId);
            } else if (line.startsWith("MPNCONF")) {
                Array args = StringExt.split(line, ",");
                String mpnSubId = (String)args.__get(1);
                this.evtMPNCONF(mpnSubId);
            }
        }
        return true;
    }

    public void evtExtMpnRegister() {
        this.traceEvent("mpn.register");
        if (this.state.s_mpn.m == 400) {
            this.state.s_mpn.m = 402;
            this.state.traceState();
            this.evtMpnCheckNext();
            return;
        }
        if (this.state.s_mpn.m == 401) {
            this.state.s_mpn.m = 402;
            this.state.traceState();
            this.evtMpnCheckNext();
            return;
        }
        Integer n = this.state.s_mpn.tk;
        if (n == null ? false : Jvm.toInt(n) == 451) {
            this.state.s_mpn.tk = 452;
            this.state.traceState();
            this.evtMpnCheckNext();
        }
    }

    public void evtMpnCheckNext() {
        this.traceEvent("mpn.check.next");
        if (this.state.s_mpn.m == 402) {
            if (Lambda.empty(this.mpn_candidate_devices)) {
                this.state.s_mpn.m = 401;
                this.state.traceState();
                this.evtResetMpnDevice();
                return;
            }
            this.doRegisterMpnDevice();
            this.state.s_mpn.m = 403;
            this.state.traceState();
            this.genSendMpnRegister();
            return;
        }
        if (this.state.s_mpn.m == 408) {
            if (Lambda.empty(this.mpn_candidate_devices)) {
                this.state.s_mpn.m = 401;
                this.state.traceState();
                this.evtResetMpnDevice();
                return;
            }
            this.doRegisterMpnDevice();
            this.state.s_mpn.m = 406;
            this.state.traceState();
            this.genSendMpnRegister();
            return;
        }
        Integer n = this.state.s_mpn.tk;
        if (n == null ? false : Jvm.toInt(n) == 452) {
            if (Lambda.empty(this.mpn_candidate_devices)) {
                this.doRemoveMpnSpecialListeners();
                this.state.s_mpn.m = 401;
                this.state.s_mpn.st = null;
                this.state.s_mpn.tk = null;
                this.state.s_mpn.sbs = null;
                this.state.s_mpn.ft = null;
                this.state.s_mpn.bg = null;
                this.state.traceState();
                this.genUnsubscribeMpnSpecialItems();
                this.evtResetMpnDevice();
            } else {
                this.doRegisterMpnDevice();
                this.state.s_mpn.tk = 453;
                this.state.traceState();
                this.genSendMpnRegister();
            }
        }
    }

    public void evtResetMpnDevice() {
        this.traceEvent("reset.mpn.device");
        if (this.state.s_mpn.m == 401) {
            this.doResetMpnDevice();
            this.notifyDeviceReset();
            this.state.s_mpn.m = 401;
            this.state.traceState();
        }
    }

    public void evtMpnError(int code, String msg) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtMpnError_0(_gthis, code, msg));
    }

    public void evtMPNREG(String deviceId, String adapterName) {
        this.traceEvent("MPNREG");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MPNREG " + deviceId + " " + adapterName, null);
        }
        boolean forward = true;
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMPNREG();
                boolean inStreaming = this.state.inStreaming();
                forward = this.evtMPNREG_MpnRegion(deviceId, adapterName);
                if (inStreaming) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                boolean inStreaming = this.state.inStreaming();
                forward = this.evtMPNREG_MpnRegion(deviceId, adapterName);
                if (inStreaming) {
                    this.evtRestartKeepalive();
                }
            }
        }
        if (forward) {
            this.evtMPNREG_MpnRegion(deviceId, adapterName);
        }
    }

    public boolean evtMPNREG_MpnRegion(String deviceId, String adapterName) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (this.state.s_mpn.m != 403 && this.state.s_mpn.m != 404) break block7;
                        this.doMPNREG_Register(deviceId, adapterName);
                        this.notifyDeviceRegistered(0L);
                        this.state.s_mpn.m = 405;
                        this.state.s_mpn.st = 410;
                        this.state.s_mpn.sbs = 420;
                        this.state.s_mpn.ft = 430;
                        this.state.s_mpn.bg = 440;
                        this.state.s_mpn.tk = 450;
                        this.state.traceState();
                        this.genDeviceActive();
                        this.genSubscribeSpecialItems();
                        this.evtMpnCheckPending();
                        this.evtSUBS_Init();
                        this.evtMpnCheckFilter();
                        this.evtMpnCheckReset();
                        break block8;
                    }
                    if (this.state.s_mpn.m != 406 && this.state.s_mpn.m != 407) break block9;
                    if (Jvm.stringCompare(deviceId, this.mpn_deviceId) == 0 && Jvm.stringCompare(adapterName, this.mpn_adapterName) == 0) {
                        this.doMPNREG_Register(deviceId, adapterName);
                        this.notifyDeviceRegistered(0L);
                        this.state.s_mpn.m = 405;
                        this.state.s_mpn.st = 410;
                        this.state.s_mpn.sbs = 420;
                        this.state.s_mpn.ft = 430;
                        this.state.s_mpn.bg = 440;
                        this.state.s_mpn.tk = 450;
                        this.state.traceState();
                        this.genDeviceActive();
                        this.genSubscribeSpecialItems();
                        this.evtMpnCheckPending();
                        this.evtSUBS_Init();
                        this.evtMpnCheckFilter();
                        this.evtMpnCheckReset();
                    } else {
                        this.doMPNREG_Error();
                        this.notifyDeviceError_DifferentDevice();
                        this.state.s_mpn.m = 408;
                        this.state.traceState();
                        this.evtMpnCheckNext();
                    }
                    break block8;
                }
                Integer n = this.state.s_mpn.tk;
                if (!(n == null ? true : Jvm.toInt(n) != 453)) break block10;
                Integer n2 = this.state.s_mpn.tk;
                if (!(n2 == null ? false : Jvm.toInt(n2) == 454)) break block8;
            }
            if (Jvm.stringCompare(deviceId, this.mpn_deviceId) == 0 && Jvm.stringCompare(adapterName, this.mpn_adapterName) == 0) {
                this.doMPNREG_RefreshToken(deviceId, adapterName);
                this.state.s_mpn.tk = 450;
                this.state.traceState();
                this.evtMpnCheckPending();
            } else {
                this.doMPNREG_Error();
                this.notifyDeviceError_DifferentDevice();
                this.state.s_mpn.tk = 452;
                this.state.traceState();
                this.evtMpnCheckNext();
            }
        }
        return false;
    }

    public void evtMPNZERO(String deviceId) {
        this.traceEvent("MPNZERO");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MPNZERO " + deviceId, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMPNZERO(deviceId);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtMPNOK(int subId, String mpnSubId) {
        this.traceEvent("MPNOK");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MPNOK " + subId + " " + mpnSubId, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMPNOK(subId, mpnSubId);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtMPNDEL(String mpnSubId) {
        this.traceEvent("MPNDEL");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MPNDEL " + mpnSubId, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMPNDEL(mpnSubId);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtMPNCONF(String mpnSubId) {
        this.traceEvent("MPNCONF");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MPNCONF " + mpnSubId, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMPNCONF(mpnSubId);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtDEV_Update(String status, long timestamp) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtDEV_Update_0(_gthis, status, timestamp));
    }

    public void evtMpnCheckPending() {
        this.traceEvent("mpn.check.pending");
        Integer n = this.state.s_mpn.tk;
        if (n == null ? false : Jvm.toInt(n) == 450) {
            if (Lambda.empty(this.mpn_candidate_devices)) {
                this.state.s_mpn.tk = 451;
                this.state.traceState();
            } else {
                this.state.s_mpn.tk = 452;
                this.state.traceState();
                this.evtMpnCheckNext();
            }
        }
    }

    public void evtSUBS_Init() {
        this.traceEvent("SUBS.init");
        Integer n = this.state.s_mpn.sbs;
        if (n == null ? false : Jvm.toInt(n) == 420) {
            this.doClearMpnSnapshot();
            this.state.s_mpn.sbs = 421;
            this.state.traceState();
        }
    }

    public void evtSUBS_Update(String mpnSubId, ItemUpdate update) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtSUBS_Update_0(_gthis, update, mpnSubId));
    }

    public void evtSUBS_EOS() {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtSUBS_EOS_0(_gthis));
    }

    public void evtExtMpnUnsubscribeFilter() {
        this.traceEvent("mpn.unsubscribe.filter");
        Integer n = this.state.s_mpn.ft;
        if (n == null ? false : Jvm.toInt(n) == 431) {
            this.state.s_mpn.ft = 430;
            this.state.traceState();
            this.evtMpnCheckFilter();
        }
    }

    public void evtMpnCheckFilter() {
        this.traceEvent("mpn.check.filter");
        Integer n = this.state.s_mpn.ft;
        if (n == null ? false : Jvm.toInt(n) == 430) {
            if (Lambda.empty(this.mpn_filter_pendings)) {
                this.state.s_mpn.ft = 431;
                this.state.traceState();
            } else {
                this.state.s_mpn.ft = 432;
                this.state.traceState();
                this.genSendMpnUnsubscribeFilter();
            }
        }
    }

    public void evtExtMpnResetBadge() {
        this.traceEvent("mpn.reset.badge");
        Integer n = this.state.s_mpn.bg;
        if (n == null ? false : Jvm.toInt(n) == 441) {
            this.state.s_mpn.bg = 440;
            this.state.traceState();
            this.evtMpnCheckReset();
        }
    }

    public void evtMpnCheckReset() {
        this.traceEvent("mpn.check.reset");
        Integer n = this.state.s_mpn.bg;
        if (n == null ? false : Jvm.toInt(n) == 440) {
            if (this.mpn_badge_reset_requested) {
                this.state.s_mpn.bg = 442;
                this.state.traceState();
                this.genSendMpnResetBadge();
            } else {
                this.state.s_mpn.bg = 441;
                this.state.traceState();
            }
        }
    }

    @Override
    public void doREQOK(int reqId) {
        super.doREQOK(reqId);
        MyArray.MyArrayIterator<MpnSubscriptionManager> sub = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sub.hasNext()) {
            MpnSubscriptionManager sub2 = sub.next();
            sub2.evtREQOK(reqId);
        }
        this.mpnSubscriptionManagers.compact();
    }

    @Override
    public void doREQERR(int reqId, int errorCode, String errorMsg) {
        super.doREQERR(reqId, errorCode, errorMsg);
        MyArray.MyArrayIterator<MpnSubscriptionManager> sub = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sub.hasNext()) {
            MpnSubscriptionManager sub2 = sub.next();
            sub2.evtREQERR(reqId, errorCode, errorMsg);
        }
        this.mpnSubscriptionManagers.compact();
    }

    @Override
    public void genAbortSubscriptions() {
        super.genAbortSubscriptions();
        MyArray.MyArrayIterator<MpnSubscriptionManager> sub = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sub.hasNext()) {
            MpnSubscriptionManager sub2 = sub.next();
            sub2.evtAbort();
        }
        this.mpnSubscriptionManagers.compact();
    }

    @Override
    public Array getPendingControls() {
        Array res = super.getPendingControls();
        if (this.mpnRegisterRequest.isPending()) {
            res.push(this.mpnRegisterRequest);
        }
        MyArray.MyArrayIterator<MpnSubscriptionManager> sub = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers.filter(Closure_getPendingControls_0.MpnClientMachine$Closure_getPendingControls_0));
        while (sub.hasNext()) {
            MpnSubscriptionManager sub2 = sub.next();
            res.push(sub2);
        }
        if (this.mpnFilterUnsubscriptionRequest.isPending()) {
            res.push(this.mpnFilterUnsubscriptionRequest);
        }
        if (this.mpnBadgeResetRequest.isPending()) {
            res.push(this.mpnBadgeResetRequest);
        }
        return res;
    }

    public void doRegisterMpnDevice() {
        if (Lambda.empty(this.mpn_candidate_devices)) {
            throw new IllegalStateException("Assertion failure: " + "!mpn_candidate_devices.empty()");
        }
        this.mpn_device = this.mpn_candidate_devices.shift();
    }

    public void doRemoveMpnSpecialListeners() {
        this.mpn_deviceSubscription.removeListener(this.mpn_deviceListener);
        this.mpn_deviceListener.disable();
        this.mpn_deviceListener = null;
        this.mpn_itemSubscription.removeListener(this.mpn_itemListener);
        this.mpn_itemListener.disable();
        this.mpn_itemListener = null;
    }

    public void genSendMpnRegister() {
        this.evtSendControl(this.mpnRegisterRequest);
    }

    public void genUnsubscribeMpnSpecialItems() {
        this.client.unsubscribe(NullTools.sure(this.mpn_deviceSubscription));
        this.client.unsubscribe(NullTools.sure(this.mpn_itemSubscription));
    }

    public void doResetMpnDevice() {
        this.mpn_deviceId = null;
        this.mpn_deviceToken = null;
        this.mpn_adapterName = null;
        this.mpn_lastRegisterReqId = null;
        this.mpn_deviceSubscription = null;
        this.mpn_itemSubscription = null;
        this.mpn_deviceListener = null;
        this.mpn_itemListener = null;
        this.mpn_snapshotSet.removeAll();
        ArrayTools_Fields_.removeAll(this.mpn_filter_pendings);
        this.mpn_filter_lastDeactivateReqId = null;
        this.mpn_badge_reset_requested = false;
        this.mpn_badge_lastResetReqId = null;
    }

    public void notifyDeviceReset() {
        NullTools.sure(this.mpn_device).onReset();
    }

    public void notifyDeviceError(int code, String msg) {
        NullTools.sure(this.mpn_device).onError(code, msg);
    }

    public void doMPNREG() {
        this.onFreshData();
    }

    public void doMPNREG_Register(String deviceId, String adapterName) {
        if (this.mpn_device == null) {
            throw new IllegalStateException("Assertion failure: " + "mpn_device != null");
        }
        this.mpn_deviceId = deviceId;
        this.mpn_deviceToken = this.mpn_device.getDeviceToken();
        this.mpn_adapterName = adapterName;
        this.mpn_device.setDeviceId(deviceId, adapterName);
        this.createSpecialItems(deviceId, adapterName);
    }

    public void doMPNZERO(String deviceId) {
        this.onFreshData();
        if (this.mpn_deviceId != null && Jvm.stringCompare(deviceId, this.mpn_deviceId) == 0) {
            NullTools.sure(this.mpn_device).fireOnBadgeReset();
        }
    }

    public void createSpecialItems(String deviceId, String adapterName) {
        this.mpn_deviceListener = new MpnDeviceDelegate(this);
        Array<String> a = Array.ofNative(new String[]{"DEV-" + deviceId});
        String[] ret = new String[a.length];
        int _g = 0;
        int _g1 = a.length;
        while (_g < _g1) {
            int i = _g++;
            ret[i] = a.__get(i);
        }
        String[] deviceSub = ret;
        Array<String> a2 = Array.ofNative(new String[]{"status", "status_timestamp"});
        String[] ret2 = new String[a2.length];
        int _g2 = 0;
        int _g12 = a2.length;
        while (_g2 < _g12) {
            int i = _g2++;
            ret2[i] = a2.__get(i);
        }
        LSSubscription deviceSub2 = new LSSubscription("MERGE", deviceSub, ret2, null);
        deviceSub2.setInternal();
        deviceSub2.setDataAdapter(adapterName);
        deviceSub2.setRequestedMaxFrequency("unfiltered");
        deviceSub2.addListener(this.mpn_deviceListener);
        this.mpn_deviceSubscription = deviceSub2;
        this.mpn_itemListener = new MpnItemDelegate(this);
        Array<String> a3 = Array.ofNative(new String[]{"SUBS-" + deviceId});
        String[] ret3 = new String[a3.length];
        int _g3 = 0;
        int _g13 = a3.length;
        while (_g3 < _g13) {
            int i = _g3++;
            ret3[i] = a3.__get(i);
        }
        String[] itemSub = ret3;
        Array<String> a4 = Array.ofNative(new String[]{"key", "command"});
        String[] ret4 = new String[a4.length];
        int _g4 = 0;
        int _g14 = a4.length;
        while (_g4 < _g14) {
            int i = _g4++;
            ret4[i] = a4.__get(i);
        }
        LSSubscription itemSub2 = new LSSubscription("COMMAND", itemSub, ret4, null);
        itemSub2.setInternal();
        itemSub2.setDataAdapter(adapterName);
        itemSub2.setRequestedMaxFrequency("unfiltered");
        Array<String> a5 = Array.ofNative(new String[]{"status", "status_timestamp", "notification_format", "trigger", "group", "schema", "adapter", "mode", "requested_buffer_size", "requested_max_frequency"});
        String[] ret5 = new String[a5.length];
        int _g5 = 0;
        int _g15 = a5.length;
        while (_g5 < _g15) {
            int i = _g5++;
            ret5[i] = a5.__get(i);
        }
        itemSub2.setCommandSecondLevelFields(ret5);
        itemSub2.setCommandSecondLevelDataAdapter(adapterName);
        itemSub2.addListener(this.mpn_itemListener);
        this.mpn_itemSubscription = itemSub2;
    }

    public void genDeviceActive() {
        MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sm.hasNext()) {
            MpnSubscriptionManager sm2 = sm.next();
            sm2.evtDeviceActive();
        }
        this.mpnSubscriptionManagers.compact();
    }

    public void genSubscribeSpecialItems() {
        if (this.mpn_deviceSubscription == null) {
            throw new IllegalStateException("Assertion failure: " + "mpn_deviceSubscription != null");
        }
        if (this.mpn_itemSubscription == null) {
            throw new IllegalStateException("Assertion failure: " + "mpn_itemSubscription != null");
        }
        this.subscribeExt(this.mpn_deviceSubscription, true);
        this.subscribeExt(this.mpn_itemSubscription, true);
    }

    public void doMPNREG_Error() {
    }

    public void notifyDeviceError_DifferentDevice() {
        NullTools.sure(this.mpn_device).onError(62, "DeviceId or Adapter Name has unexpectedly been changed");
    }

    public void doMPNREG_RefreshToken(String deviceId, String adapterName) {
        if (this.mpn_device == null) {
            throw new IllegalStateException("Assertion failure: " + "mpn_device != null");
        }
        this.mpn_deviceToken = this.mpn_device.getDeviceToken();
        this.mpn_device.setDeviceId(deviceId, adapterName);
    }

    public void notifyDeviceRegistered(long timestamp) {
        NullTools.sure(this.mpn_device).onRegistered(timestamp);
    }

    public void notifyDeviceSuspended(long timestamp) {
        NullTools.sure(this.mpn_device).onSuspend(timestamp);
    }

    public void notifyDeviceResume(long timestamp) {
        NullTools.sure(this.mpn_device).onResume(timestamp);
    }

    public void doClearMpnSnapshot() {
        this.mpn_snapshotSet.removeAll();
    }

    public boolean exists(String mpnSubId) {
        return Lambda.exists(this.mpnSubscriptionManagers, new Closure_exists_0(mpnSubId));
    }

    public void genSUBS_update(String mpnSubId, ItemUpdate update) {
        MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sm.hasNext()) {
            MpnSubscriptionManager sm2 = sm.next();
            if (Jvm.stringCompare(mpnSubId, sm2.fetch_mpnSubId()) != 0) continue;
            sm2.evtMpnUpdate(update);
        }
        this.mpnSubscriptionManagers.compact();
    }

    public void doAddToMpnSnapshot(String mpnSubId) {
        this.mpn_snapshotSet.insert(mpnSubId);
    }

    public void doRemoveFromMpnSnapshot(String mpnSubId) {
        this.mpn_snapshotSet.remove(mpnSubId);
    }

    public void doAddMpnSubscription(String mpnSubId) {
        MpnSubscriptionManager sm = new MpnSubscriptionManager(MpnSubscriptionManager.CtorArgs.Ctor2(mpnSubId, this));
        sm.start();
    }

    public void notifyOnSubscriptionsUpdated() {
        NullTools.sure(this.mpn_device).fireOnSubscriptionsUpdated();
    }

    public void genSUBS_EOS() {
        MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sm.hasNext()) {
            MpnSubscriptionManager sm2 = sm.next();
            sm2.evtMpnEOS();
        }
        this.mpnSubscriptionManagers.compact();
    }

    public void genSendMpnUnsubscribeFilter() {
        this.evtSendControl(this.mpnFilterUnsubscriptionRequest);
    }

    public void genSendMpnResetBadge() {
        this.evtSendControl(this.mpnBadgeResetRequest);
    }

    public void doREQMpnUnsubscribeFilter() {
        this.mpn_filter_pendings.shift();
    }

    public void doREQOKMpnResetBadge() {
        this.mpn_badge_reset_requested = false;
    }

    public void doREQERRMpnResetBadge() {
        this.mpn_badge_reset_requested = false;
    }

    public void notifyOnBadgeResetFailed(int code, String msg) {
        NullTools.sure(this.mpn_device).fireOnBadgeResetFailed(code, msg);
    }

    public void doMPNOK(int subId, String mpnSubId) {
        this.onFreshData();
        MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sm.hasNext()) {
            MpnSubscriptionManager sm2 = sm.next();
            Integer n = sm2.m_subId;
            if (!(n == null ? false : Jvm.toInt(n) == subId)) continue;
            sm2.evtMPNOK(mpnSubId);
        }
        this.mpnSubscriptionManagers.compact();
    }

    public void doMPNDEL(String mpnSubId) {
        this.onFreshData();
        MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this.mpnSubscriptionManagers);
        while (sm.hasNext()) {
            MpnSubscriptionManager sm2 = sm.next();
            if (Jvm.stringCompare(sm2.fetch_mpnSubId(), mpnSubId) != 0) continue;
            sm2.evtMPNDEL();
        }
        this.mpnSubscriptionManagers.compact();
    }

    public void doMPNCONF(String mpnSubId) {
        this.onFreshData();
    }

    public String encodeMpnRegister() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeMpnRegister_0(_gthis));
    }

    public String encodeMpnRefreshToken() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeMpnRefreshToken_0(_gthis));
    }

    public String encodeMpnRestore() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeMpnRestore_0(_gthis));
    }

    public String encodeDeactivateFilter() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeDeactivateFilter_0(_gthis));
    }

    public String encodeBadgeReset() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeBadgeReset_0(_gthis));
    }

    public void relate(MpnSubscriptionManager subManager) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_relate_0(_gthis, subManager));
    }

    public void unrelate(MpnSubscriptionManager subManager) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unrelate_0(_gthis, subManager));
    }

    public String fetch_mpn_deviceId() {
        MpnClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_mpn_deviceId_0(_gthis));
    }

    public LSMpnDevice fetch_mpn_device() {
        MpnClientMachine _gthis = this;
        return (LSMpnDevice)this.lock.synchronized(new Closure_fetch_mpn_device_0(_gthis));
    }

    public void registerForMpn(LSMpnDevice mpnDevice) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_registerForMpn_0(mpnDevice, _gthis));
    }

    public void subscribeMpn(LSMpnSubscription mpnSubscription, boolean coalescing) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_subscribeMpn_0(_gthis, mpnSubscription, coalescing));
    }

    public void unsubscribeMpn(LSMpnSubscription mpnSubscription) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unsubscribeMpn_0(_gthis, mpnSubscription));
    }

    public void unsubscribeMpnSubscriptions(String filter) {
        MpnClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unsubscribeMpnSubscriptions_0(_gthis, filter));
    }

    public Array getMpnSubscriptions(String filter) {
        MpnClientMachine _gthis = this;
        return (Array)this.lock.synchronized(new Closure_getMpnSubscriptions_0(_gthis, filter));
    }

    public LSMpnSubscription findMpnSubscription(String subscriptionId) {
        MpnClientMachine _gthis = this;
        return (LSMpnSubscription)this.lock.synchronized(new Closure_findMpnSubscription_0(subscriptionId, _gthis));
    }

    public MpnClientMachine(LSLightstreamerClient client, haxe.jvm.Function wsFactory, haxe.jvm.Function httpFactory, haxe.jvm.Function ctrlFactory, haxe.jvm.Function timerFactory, haxe.jvm.Function randomGenerator, haxe.jvm.Function reachabilityFactory) {
        this.mpnSubscriptionManagers = new MyArray();
        this.mpn_candidate_devices = new Array();
        this.mpn_snapshotSet = new Set(null);
        this.mpn_filter_pendings = new Array();
        this.mpn_badge_reset_requested = false;
        super(client, wsFactory, httpFactory, ctrlFactory, timerFactory, randomGenerator, reachabilityFactory);
        this.mpnRegisterRequest = new MpnRegisterRequest(this);
        this.mpnFilterUnsubscriptionRequest = new MpnFilterUnsubscriptionRequest(this);
        this.mpnBadgeResetRequest = new MpnBadgeResetRequest(this);
    }

    public /* synthetic */ MpnClientMachine(EmptyConstructor _) {
        super(_);
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class MpnDeviceDelegate
    extends SubscriptionDelegateBase {
        @Override
        public void onItemUpdate(ItemUpdate itemUpdate) {
            MpnDeviceDelegate _gthis = this;
            this.synchronized(new Closure_onItemUpdate_0(itemUpdate, _gthis));
        }

        @Override
        public void onSubscriptionError(int code, String message) {
            MpnDeviceDelegate _gthis = this;
            this.synchronized(new Closure_onSubscriptionError_0(_gthis));
        }

        @Override
        public void onUnsubscription() {
            MpnDeviceDelegate _gthis = this;
            this.synchronized(new Closure_onUnsubscription_0(_gthis));
        }

        public /* synthetic */ MpnDeviceDelegate(EmptyConstructor _) {
            super(_);
        }

        /*
         * WARNING - void declaration
         */
        public MpnDeviceDelegate(MpnClientMachine mpnClientMachine) {
            super((MpnClientMachine)client);
            void client;
        }

        public static final class Closure_onSubscriptionError_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final MpnDeviceDelegate _gthis;

            public Closure_onSubscriptionError_0(MpnDeviceDelegate _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                this._gthis.client.evtMpnError(62, "MPN device activation can't be completed (62/1)");
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onItemUpdate_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final ItemUpdate itemUpdate;
            public final MpnDeviceDelegate _gthis;

            /*
             * WARNING - void declaration
             */
            public Closure_onItemUpdate_0(ItemUpdate itemUpdate, MpnDeviceDelegate mpnDeviceDelegate) {
                void _gthis;
                this.itemUpdate = itemUpdate;
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                String status = this.itemUpdate.getValue("status");
                String timestamp = this.itemUpdate.getValue("status_timestamp");
                if (status != null) {
                    this._gthis.client.evtDEV_Update(status, ParseTools_Fields_.parseLong(timestamp != null ? timestamp : "0"));
                }
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onUnsubscription_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final MpnDeviceDelegate _gthis;

            public Closure_onUnsubscription_0(MpnDeviceDelegate _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                this._gthis.client.evtMpnError(62, "MPN device activation can't be completed (62/2)");
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeMpnRegister_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_encodeMpnRegister_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException("Assertion failure: " + "mpn_device != null");
            }
            RequestBuilder req = new RequestBuilder();
            String deviceToken = this._gthis.mpn_device.getDeviceToken();
            String prevDeviceToken = this._gthis.mpn_device.getPreviousDeviceToken();
            this._gthis.mpn_lastRegisterReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.mpn_lastRegisterReqId));
            req.LS_op("register");
            req.PN_type(this._gthis.mpn_device.getPlatform());
            req.PN_appId(this._gthis.mpn_device.getApplicationId());
            if (prevDeviceToken == null || Jvm.stringCompare(prevDeviceToken, deviceToken) == 0) {
                req.PN_deviceToken(deviceToken);
            } else {
                req.PN_deviceToken(prevDeviceToken);
                req.PN_newDeviceToken(deviceToken);
            }
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending MPNDevice register: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_unsubscribeMpnSubscriptions_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final String filter;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribeMpnSubscriptions_0(MpnClientMachine _gthis, String string) {
            void filter;
            this._gthis = _gthis;
            this.filter = filter;
        }

        @Override
        public void invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException(MpnClientMachine_Fields_.NO_DEVICE);
            }
            MPNSubscriptionStatus filter = MpnClientMachine_Fields_.parseStatusFilter(this.filter);
            this._gthis.mpn_filter_pendings.push(filter);
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("Multiple MPN Unsubscriptions requested: " + Std.string((Object)filter), null);
            }
            this._gthis.evtExtMpnUnsubscribeFilter();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeDeactivateFilter_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_encodeDeactivateFilter_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            RequestBuilder req = new RequestBuilder();
            this._gthis.mpn_filter_lastDeactivateReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.mpn_filter_lastDeactivateReqId));
            req.LS_op("deactivate");
            req.PN_deviceId(NullTools.sure(this._gthis.mpn_deviceId));
            switch (this._gthis.mpn_filter_pendings.__get(0).ordinal()) {
                default: {
                    break;
                }
                case 1: {
                    req.PN_subscriptionStatus("ACTIVE");
                    break;
                }
                case 2: {
                    req.PN_subscriptionStatus("TRIGGERED");
                }
            }
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending multiple MPNSubscription deactivate: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeMpnRestore_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_encodeMpnRestore_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException("Assertion failure: " + "mpn_device != null");
            }
            RequestBuilder req = new RequestBuilder();
            this._gthis.mpn_lastRegisterReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.mpn_lastRegisterReqId));
            req.LS_op("register");
            req.PN_type(this._gthis.mpn_device.getPlatform());
            req.PN_appId(this._gthis.mpn_device.getApplicationId());
            req.PN_deviceToken(NullTools.sure(this._gthis.mpn_deviceToken));
            req.PN_newDeviceToken(this._gthis.mpn_device.getDeviceToken());
            req.LS_cause("restore.token");
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending MPNDevice restore: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtDEV_Update_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final String status;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public Closure_evtDEV_Update_0(MpnClientMachine _gthis, String string, long l) {
            void timestamp;
            void status;
            this._gthis = _gthis;
            this.status = status;
            this.timestamp = timestamp;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("DEV.update");
            Integer n = this._gthis.state.s_mpn.st;
            if (n == null ? false : Jvm.toInt(n) == 410) {
                if (Jvm.stringCompare(this.status, "ACTIVE") == 0) {
                    if (!NullTools.sure(this._gthis.mpn_device).isRegistered()) {
                        this._gthis.notifyDeviceRegistered(this.timestamp);
                    }
                    this._gthis.state.s_mpn.st = 410;
                    this._gthis.state.traceState();
                    return;
                }
                if (Jvm.stringCompare(this.status, "SUSPENDED") == 0) {
                    if (!NullTools.sure(this._gthis.mpn_device).isSuspended()) {
                        this._gthis.notifyDeviceSuspended(this.timestamp);
                    }
                    this._gthis.state.s_mpn.st = 411;
                    this._gthis.state.traceState();
                }
                return;
            }
            Integer n2 = this._gthis.state.s_mpn.st;
            if ((n2 == null ? false : Jvm.toInt(n2) == 411) && Jvm.stringCompare(this.status, "ACTIVE") == 0) {
                this._gthis.notifyDeviceResume(this.timestamp);
                this._gthis.state.s_mpn.st = 410;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class MpnItemDelegate
    extends SubscriptionDelegateBase {
        @Override
        public void onItemUpdate(ItemUpdate itemUpdate) {
            MpnItemDelegate _gthis = this;
            this.synchronized(new Closure_onItemUpdate_0(itemUpdate, _gthis));
        }

        @Override
        public void onEndOfSnapshot(String itemName, int itemPos) {
            MpnItemDelegate _gthis = this;
            this.synchronized(new Closure_onEndOfSnapshot_0(_gthis));
        }

        @Override
        public void onSubscriptionError(int code, String message) {
            MpnItemDelegate _gthis = this;
            this.synchronized(new Closure_onSubscriptionError_0(_gthis));
        }

        @Override
        public void onUnsubscription() {
            MpnItemDelegate _gthis = this;
            this.synchronized(new Closure_onUnsubscription_0(_gthis));
        }

        @Override
        public void onCommandSecondLevelSubscriptionError(int code, String message, String key) {
            this.synchronized(new Closure_onCommandSecondLevelSubscriptionError_0(key));
        }

        public /* synthetic */ MpnItemDelegate(EmptyConstructor _) {
            super(_);
        }

        /*
         * WARNING - void declaration
         */
        public MpnItemDelegate(MpnClientMachine mpnClientMachine) {
            super((MpnClientMachine)client);
            void client;
        }

        public static final class Closure_onUnsubscription_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final MpnItemDelegate _gthis;

            public Closure_onUnsubscription_0(MpnItemDelegate _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                this._gthis.client.evtMpnError(62, "MPN device activation can't be completed (62/4)");
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onCommandSecondLevelSubscriptionError_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final String key;

            public Closure_onCommandSecondLevelSubscriptionError_0(String key) {
                this.key = key;
            }

            @Override
            public void invoke() {
                if (LoggerTools_Fields_.mpnDeviceLogger.isWarnEnabled()) {
                    LoggerTools_Fields_.mpnDeviceLogger.warn("MPN device can't complete the subscription of " + this.key, null);
                }
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onSubscriptionError_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final MpnItemDelegate _gthis;

            public Closure_onSubscriptionError_0(MpnItemDelegate _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                this._gthis.client.evtMpnError(62, "MPN device activation can't be completed (62/3)");
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onItemUpdate_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final ItemUpdate itemUpdate;
            public final MpnItemDelegate _gthis;

            /*
             * WARNING - void declaration
             */
            public Closure_onItemUpdate_0(ItemUpdate itemUpdate, MpnItemDelegate mpnItemDelegate) {
                void _gthis;
                this.itemUpdate = itemUpdate;
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                String key = this.itemUpdate.getValue("key");
                if (key != null) {
                    Integer endIndex = null;
                    String mpnSubId = StringExt.substring(key, 4, endIndex);
                    this._gthis.client.evtSUBS_Update(mpnSubId, this.itemUpdate);
                }
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        public static final class Closure_onEndOfSnapshot_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final MpnItemDelegate _gthis;

            public Closure_onEndOfSnapshot_0(MpnItemDelegate _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public void invoke() {
                this._gthis.client.evtSUBS_EOS();
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeMpnRefreshToken_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_encodeMpnRefreshToken_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException("Assertion failure: " + "mpn_device != null");
            }
            RequestBuilder req = new RequestBuilder();
            this._gthis.mpn_lastRegisterReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.mpn_lastRegisterReqId));
            req.LS_op("register");
            req.PN_type(this._gthis.mpn_device.getPlatform());
            req.PN_appId(this._gthis.mpn_device.getApplicationId());
            req.PN_deviceToken(NullTools.sure(this._gthis.mpn_deviceToken));
            req.PN_newDeviceToken(this._gthis.mpn_device.getDeviceToken());
            req.LS_cause("refresh.token");
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending MPNDevice refresh: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtSUBS_EOS_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;

        public Closure_evtSUBS_EOS_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("SUBS.EOS");
            Integer n = this._gthis.state.s_mpn.sbs;
            if (n == null ? false : Jvm.toInt(n) == 421) {
                this._gthis.state.s_mpn.sbs = 424;
                this._gthis.state.traceState();
                this._gthis.genSUBS_EOS();
                this._gthis.notifyOnSubscriptionsUpdated();
                return;
            }
            Integer n2 = this._gthis.state.s_mpn.sbs;
            if (n2 == null ? false : Jvm.toInt(n2) == 423) {
                if (this._gthis.mpn_snapshotSet.count() > 0) {
                    this._gthis.state.s_mpn.sbs = 424;
                    this._gthis.state.traceState();
                    this._gthis.genSUBS_EOS();
                } else {
                    this._gthis.state.s_mpn.sbs = 424;
                    this._gthis.state.traceState();
                    this._gthis.genSUBS_EOS();
                    this._gthis.notifyOnSubscriptionsUpdated();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtSUBS_Update_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final ItemUpdate update;
        public final String mpnSubId;

        /*
         * WARNING - void declaration
         */
        public Closure_evtSUBS_Update_0(MpnClientMachine _gthis, ItemUpdate itemUpdate, String string) {
            void mpnSubId;
            void update;
            this._gthis = _gthis;
            this.update = update;
            this.mpnSubId = mpnSubId;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("SUBS.update");
            String command = this.update.getValue("command");
            String status = this.update.getValue("status");
            if (this._gthis.state.s_mpn.sbs != null && this._gthis.exists(this.mpnSubId)) {
                this._gthis.state.traceState();
                this._gthis.genSUBS_update(this.mpnSubId, this.update);
                return;
            }
            Integer n = this._gthis.state.s_mpn.sbs;
            if ((n == null ? false : Jvm.toInt(n) == 421) && Jvm.stringCompare(command, "DELETE") != 0 && !this._gthis.exists(this.mpnSubId)) {
                if (status == null) {
                    this._gthis.doAddToMpnSnapshot(this.mpnSubId);
                    this._gthis.state.s_mpn.sbs = 423;
                    this._gthis.state.traceState();
                    return;
                }
                this._gthis.doRemoveFromMpnSnapshot(this.mpnSubId);
                this._gthis.doAddMpnSubscription(this.mpnSubId);
                this._gthis.state.s_mpn.sbs = 423;
                this._gthis.state.traceState();
                this._gthis.genSUBS_update(this.mpnSubId, this.update);
                return;
            }
            Integer n2 = this._gthis.state.s_mpn.sbs;
            if ((n2 == null ? false : Jvm.toInt(n2) == 423) && Jvm.stringCompare(command, "DELETE") != 0 && !this._gthis.exists(this.mpnSubId)) {
                if (status == null) {
                    this._gthis.doAddToMpnSnapshot(this.mpnSubId);
                    this._gthis.state.s_mpn.sbs = 423;
                    this._gthis.state.traceState();
                    return;
                }
                this._gthis.doRemoveFromMpnSnapshot(this.mpnSubId);
                this._gthis.doAddMpnSubscription(this.mpnSubId);
                this._gthis.state.s_mpn.sbs = 423;
                this._gthis.state.traceState();
                this._gthis.genSUBS_update(this.mpnSubId, this.update);
                return;
            }
            Integer n3 = this._gthis.state.s_mpn.sbs;
            if ((n3 == null ? false : Jvm.toInt(n3) == 424) && Jvm.stringCompare(command, "DELETE") != 0 && status != null && !this._gthis.exists(this.mpnSubId)) {
                if (this._gthis.mpn_snapshotSet.count() == 0 || this._gthis.mpn_snapshotSet.count() == 1 && this._gthis.mpn_snapshotSet.contains(this.mpnSubId)) {
                    this._gthis.doRemoveFromMpnSnapshot(this.mpnSubId);
                    this._gthis.doAddMpnSubscription(this.mpnSubId);
                    this._gthis.state.s_mpn.sbs = 424;
                    this._gthis.state.traceState();
                    this._gthis.genSUBS_update(this.mpnSubId, this.update);
                    this._gthis.notifyOnSubscriptionsUpdated();
                } else if (this._gthis.mpn_snapshotSet.count() == 1 && !this._gthis.mpn_snapshotSet.contains(this.mpnSubId) || this._gthis.mpn_snapshotSet.count() > 1) {
                    this._gthis.doRemoveFromMpnSnapshot(this.mpnSubId);
                    this._gthis.doAddMpnSubscription(this.mpnSubId);
                    this._gthis.state.s_mpn.sbs = 424;
                    this._gthis.state.traceState();
                    this._gthis.genSUBS_update(this.mpnSubId, this.update);
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_exists_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MpnSubscriptionManager>,
    Function<MpnSubscriptionManager, Boolean>,
    Predicate<MpnSubscriptionManager>,
    Function1<MpnSubscriptionManager, Boolean> {
        public final String mpnSubId;

        public Closure_exists_0(String mpnSubId) {
            this.mpnSubId = mpnSubId;
        }

        public boolean invoke(MpnSubscriptionManager sub) {
            return Jvm.stringCompare(sub.fetch_mpnSubId(), this.mpnSubId) == 0;
        }

        @Override
        public boolean test(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mpn_deviceId_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_fetch_mpn_deviceId_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.mpn_deviceId;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_evtExtConnect_NextRegion_0
    extends haxe.jvm.Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final MpnClientMachine _gthis;

        public Closure_evtExtConnect_NextRegion_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.evtExtConnect_MpnRegion();
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @ClassReflectionInformation(hasSuperClass=false)
    public static class SubscriptionDelegateBase
    extends haxe.jvm.Object
    implements SubscriptionListener {
        public MpnClientMachine client;
        public boolean m_disabled;

        public void disable() {
            SubscriptionDelegateBase _gthis = this;
            this.client.lock.synchronized(new Closure_disable_0(_gthis));
        }

        public void synchronized(haxe.jvm.Function block) {
            SubscriptionDelegateBase _gthis = this;
            this.client.lock.synchronized(new Closure_synchronized_0(_gthis, block));
        }

        @Override
        public void onClearSnapshot(String itemName, int itemPos) {
        }

        @Override
        public void onCommandSecondLevelItemLostUpdates(int lostUpdates, String key) {
        }

        @Override
        public void onCommandSecondLevelSubscriptionError(int code, String message, String key) {
        }

        @Override
        public void onEndOfSnapshot(String itemName, int itemPos) {
        }

        @Override
        public void onItemLostUpdates(String itemName, int itemPos, int lostUpdates) {
        }

        @Override
        public void onItemUpdate(ItemUpdate update) {
        }

        @Override
        public void onListenEnd() {
        }

        @Override
        public void onListenStart() {
        }

        @Override
        public void onSubscription() {
        }

        @Override
        public void onSubscriptionError(int code, String message) {
        }

        @Override
        public void onUnsubscription() {
        }

        @Override
        public void onRealMaxFrequency(String frequency) {
        }

        public SubscriptionDelegateBase(MpnClientMachine client) {
            this.m_disabled = false;
            this.client = client;
        }

        public /* synthetic */ SubscriptionDelegateBase(EmptyConstructor _) {
        }

        public static final class Closure_synchronized_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final SubscriptionDelegateBase _gthis;
            public final haxe.jvm.Function block;

            /*
             * WARNING - void declaration
             */
            public Closure_synchronized_0(SubscriptionDelegateBase _gthis, haxe.jvm.Function function) {
                void block;
                this._gthis = _gthis;
                this.block = block;
            }

            @Override
            public void invoke() {
                if (!this._gthis.m_disabled) {
                    this.block.invoke();
                }
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        public static final class Closure_disable_0
        extends haxe.jvm.Function
        implements MessageQueue.IdleHandler,
        PrivilegedAction<Boolean>,
        PrivilegedExceptionAction<Boolean>,
        Callable<Boolean>,
        Supplier<Boolean>,
        ClassReflectionInformation,
        Function0<Boolean> {
            public final SubscriptionDelegateBase _gthis;

            public Closure_disable_0(SubscriptionDelegateBase _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public boolean invoke() {
                this._gthis.m_disabled = true;
                return true;
            }

            @Override
            public boolean hasSuperClass() {
                return this.invoke();
            }

            @Override
            public boolean get() {
                return this.invoke();
            }

            @Override
            public boolean call() {
                return this.invoke();
            }

            @Override
            public boolean run() {
                return this.invoke();
            }

            public boolean queueIdle() {
                return this.invoke();
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeBadgeReset_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnClientMachine _gthis;

        public Closure_encodeBadgeReset_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            RequestBuilder req = new RequestBuilder();
            this._gthis.mpn_badge_lastResetReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.mpn_badge_lastResetReqId));
            req.LS_op("reset_badge");
            req.PN_deviceId(NullTools.sure(this._gthis.mpn_deviceId));
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending MPNDevice badge reset: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_findMpnSubscription_0
    extends haxe.jvm.Function
    implements PrivilegedAction<LSMpnSubscription>,
    PrivilegedExceptionAction<LSMpnSubscription>,
    Callable<LSMpnSubscription>,
    Supplier<LSMpnSubscription>,
    Function0<LSMpnSubscription> {
        public final String subscriptionId;
        public final MpnClientMachine _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_findMpnSubscription_0(String subscriptionId, MpnClientMachine mpnClientMachine) {
            void _gthis;
            this.subscriptionId = subscriptionId;
            this._gthis = _gthis;
        }

        @Override
        public LSMpnSubscription invoke() {
            if (this.subscriptionId == null) {
                throw new IllegalArgumentException("Subscription id must be not null");
            }
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException(MpnClientMachine_Fields_.NO_DEVICE);
            }
            MyArray.MyArrayIterator<MpnSubscriptionManager> sm = new MyArray.MyArrayIterator<MpnSubscriptionManager>(this._gthis.mpnSubscriptionManagers);
            while (sm.hasNext()) {
                MpnSubscriptionManager sm2 = sm.next();
                if (Jvm.stringCompare(sm2.m_subscription.getSubscriptionId(), this.subscriptionId) != 0) continue;
                return sm2.m_subscription;
            }
            return null;
        }

        @Override
        public LSMpnSubscription get() {
            return this.invoke();
        }

        @Override
        public LSMpnSubscription call() {
            return this.invoke();
        }

        @Override
        public LSMpnSubscription run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_unsubscribeMpn_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final LSMpnSubscription mpnSubscription;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribeMpn_0(MpnClientMachine _gthis, LSMpnSubscription lSMpnSubscription) {
            void mpnSubscription;
            this._gthis = _gthis;
            this.mpnSubscription = mpnSubscription;
        }

        @Override
        public void invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException(MpnClientMachine_Fields_.NO_DEVICE);
            }
            MpnSubscriptionManager sm = this.mpnSubscription.fetch_subManager();
            if (sm != null) {
                if (!Lambda.has(this._gthis.mpnSubscriptionManagers, sm)) {
                    throw new IllegalStateException("The MPNSubscription is not subscribed to this Client");
                }
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.actionLogger.info("MPN Unsubscription requested: pnSubId: " + this.mpnSubscription.getSubscriptionId() + " " + Std.string(this.mpnSubscription), null);
                }
                sm.evtExtMpnUnsubscribe();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mpn_device_0
    extends haxe.jvm.Function
    implements PrivilegedAction<LSMpnDevice>,
    PrivilegedExceptionAction<LSMpnDevice>,
    Callable<LSMpnDevice>,
    Supplier<LSMpnDevice>,
    Function0<LSMpnDevice> {
        public final MpnClientMachine _gthis;

        public Closure_fetch_mpn_device_0(MpnClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public LSMpnDevice invoke() {
            return this._gthis.mpn_device;
        }

        @Override
        public LSMpnDevice get() {
            return this.invoke();
        }

        @Override
        public LSMpnDevice call() {
            return this.invoke();
        }

        @Override
        public LSMpnDevice run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_registerForMpn_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnDevice mpnDevice;
        public final MpnClientMachine _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_registerForMpn_0(LSMpnDevice mpnDevice, MpnClientMachine mpnClientMachine) {
            void _gthis;
            this.mpnDevice = mpnDevice;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this.mpnDevice == null) {
                throw new IllegalArgumentException("Device cannot be null");
            }
            this._gthis.mpn_candidate_devices.push(this.mpnDevice);
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("MPN registration requested: " + Std.string(this.mpnDevice), null);
            }
            this._gthis.evtExtMpnRegister();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_subscribeMpn_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final LSMpnSubscription mpnSubscription;
        public final boolean coalescing;

        /*
         * WARNING - void declaration
         */
        public Closure_subscribeMpn_0(MpnClientMachine _gthis, LSMpnSubscription lSMpnSubscription, boolean bl) {
            void coalescing;
            void mpnSubscription;
            this._gthis = _gthis;
            this.mpnSubscription = mpnSubscription;
            this.coalescing = coalescing;
        }

        @Override
        public void invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException(MpnClientMachine_Fields_.NO_DEVICE);
            }
            if (this.mpnSubscription.isActive()) {
                throw new IllegalArgumentException(MpnClientMachine_Fields_.IS_ACTIVE_MPN);
            }
            if (this.mpnSubscription.getNotificationFormat() == null) {
                throw new IllegalArgumentException(MpnClientMachine_Fields_.NO_FORMAT);
            }
            if (this.mpnSubscription.getItems() == null && this.mpnSubscription.getItemGroup() == null) {
                throw new IllegalArgumentException("Specify property 'items' or 'itemGroup'");
            }
            if (this.mpnSubscription.getFields() == null && this.mpnSubscription.getFieldSchema() == null) {
                throw new IllegalArgumentException("Specify property 'fields' or 'fieldSchema'");
            }
            MpnSubscriptionManager sm = new MpnSubscriptionManager(MpnSubscriptionManager.CtorArgs.Ctor1(this.mpnSubscription, this.coalescing, this._gthis));
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("MPN Subscription requested: subId: " + sm.m_subId + " " + Std.string(this.mpnSubscription) + " coalescing: " + Std.string(this.coalescing), null);
            }
            sm.evtExtMpnSubscribe();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtMpnError_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_evtMpnError_0(MpnClientMachine _gthis, int n, String string) {
            void msg;
            void code;
            this._gthis = _gthis;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("mpn.error");
            if (this._gthis.state.s_mpn.m == 405) {
                this._gthis.doRemoveMpnSpecialListeners();
                this._gthis.notifyDeviceError(this.code, this.msg);
                this._gthis.state.s_mpn.m = 401;
                this._gthis.state.s_mpn.st = null;
                this._gthis.state.s_mpn.sbs = null;
                this._gthis.state.s_mpn.ft = null;
                this._gthis.state.s_mpn.bg = null;
                this._gthis.state.s_mpn.tk = null;
                this._gthis.state.traceState();
                this._gthis.genUnsubscribeMpnSpecialItems();
                this._gthis.evtResetMpnDevice();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getPendingControls_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MpnSubscriptionManager>,
    Function<MpnSubscriptionManager, Boolean>,
    Predicate<MpnSubscriptionManager>,
    Function1<MpnSubscriptionManager, Boolean> {
        public static final Closure_getPendingControls_0 MpnClientMachine$Closure_getPendingControls_0 = new Closure_getPendingControls_0();

        Closure_getPendingControls_0() {
        }

        public boolean invoke(MpnSubscriptionManager sub) {
            return sub.isPending();
        }

        @Override
        public boolean test(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MpnSubscriptionManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    public static final class Closure_unrelate_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final MpnSubscriptionManager subManager;

        /*
         * WARNING - void declaration
         */
        public Closure_unrelate_0(MpnClientMachine _gthis, MpnSubscriptionManager mpnSubscriptionManager) {
            void subManager;
            this._gthis = _gthis;
            this.subManager = subManager;
        }

        @Override
        public void invoke() {
            this._gthis.mpnSubscriptionManagers.remove(this.subManager);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_relate_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnClientMachine _gthis;
        public final MpnSubscriptionManager subManager;

        /*
         * WARNING - void declaration
         */
        public Closure_relate_0(MpnClientMachine _gthis, MpnSubscriptionManager mpnSubscriptionManager) {
            void subManager;
            this._gthis = _gthis;
            this.subManager = subManager;
        }

        @Override
        public void invoke() {
            if (Lambda.has(this._gthis.mpnSubscriptionManagers, this.subManager)) {
                throw new IllegalStateException("Assertion failure: " + "!mpnSubscriptionManagers.contains(subManager)");
            }
            this._gthis.mpnSubscriptionManagers.values.push(new MyArray.Pair<MpnSubscriptionManager>(this.subManager));
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getMpnSubscriptions_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Array<LSMpnSubscription>>,
    PrivilegedExceptionAction<Array<LSMpnSubscription>>,
    Callable<Array<LSMpnSubscription>>,
    Supplier<Array<LSMpnSubscription>>,
    Function0<Array<LSMpnSubscription>> {
        public final MpnClientMachine _gthis;
        public final String filter;

        /*
         * WARNING - void declaration
         */
        public Closure_getMpnSubscriptions_0(MpnClientMachine _gthis, String string) {
            void filter;
            this._gthis = _gthis;
            this.filter = filter;
        }

        @Override
        public Array invoke() {
            if (this._gthis.mpn_device == null) {
                throw new IllegalStateException(MpnClientMachine_Fields_.NO_DEVICE);
            }
            MPNSubscriptionStatus filter = MpnClientMachine_Fields_.parseStatusFilter(this.filter);
            MyArray filteredSubs = null;
            switch (filter.ordinal()) {
                case 0: {
                    filteredSubs = this._gthis.mpnSubscriptionManagers.map(Closure_invoke_0.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_0).filter(Closure_invoke_1.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_1);
                    break;
                }
                case 1: {
                    filteredSubs = this._gthis.mpnSubscriptionManagers.map(Closure_invoke_2.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_2).filter(Closure_invoke_3.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_3);
                    break;
                }
                case 2: {
                    filteredSubs = this._gthis.mpnSubscriptionManagers.map(Closure_invoke_4.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_4).filter(Closure_invoke_5.MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_5);
                }
            }
            StringMap<Array<LSMpnSubscription>> mapBySubId = new StringMap<Array<LSMpnSubscription>>();
            MyArray.MyArrayIterator sub = new MyArray.MyArrayIterator(filteredSubs);
            while (sub.hasNext()) {
                LSMpnSubscription sub2 = (LSMpnSubscription)sub.next();
                String subId = sub2.getSubscriptionId();
                if (subId == null) continue;
                Array ls = (Array)mapBySubId.get(subId);
                if (ls == null) {
                    Array<LSMpnSubscription> v = Array.ofNative(new LSMpnSubscription[]{sub2});
                    mapBySubId.set(subId, v);
                    continue;
                }
                ls.push(sub2);
            }
            Array<LSMpnSubscription> res = Array.ofNative(new LSMpnSubscription[0]);
            IMap map = mapBySubId;
            Iterator _g_keys = map.keys();
            while (_g_keys.hasNext()) {
                String key = (String)_g_keys.next();
                Array _g_value = (Array)map.get(key);
                boolean assigned = false;
                for (int _g = 0; _g < _g_value.length; ++_g) {
                    LSMpnSubscription sub3 = (LSMpnSubscription)_g_value.__get(_g);
                    if (sub3.fetch_madeByServer()) continue;
                    res.push(sub3);
                    assigned = true;
                    break;
                }
                if (assigned || (LSMpnSubscription)_g_value.__get(0) == null) continue;
                res.push((LSMpnSubscription)_g_value.__get(0));
            }
            return res;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public static final class Closure_invoke_2
        extends haxe.jvm.Function
        implements Function<MpnSubscriptionManager, LSMpnSubscription>,
        Function1<MpnSubscriptionManager, LSMpnSubscription> {
            public static final Closure_invoke_2 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_2 = new Closure_invoke_2();

            Closure_invoke_2() {
            }

            public LSMpnSubscription invoke(MpnSubscriptionManager sub) {
                return sub.m_subscription;
            }

            @Override
            public LSMpnSubscription apply(MpnSubscriptionManager arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        public static final class Closure_invoke_5
        extends haxe.jvm.Function
        implements DirectoryStream.Filter<LSMpnSubscription>,
        Function<LSMpnSubscription, Boolean>,
        Predicate<LSMpnSubscription>,
        Function1<LSMpnSubscription, Boolean> {
            public static final Closure_invoke_5 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_5 = new Closure_invoke_5();

            Closure_invoke_5() {
            }

            public boolean invoke(LSMpnSubscription sub) {
                return sub.fetch_status() == MpnSubscriptionStatus.Triggered;
            }

            @Override
            public boolean test(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean test(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }

        public static final class Closure_invoke_0
        extends haxe.jvm.Function
        implements Function<MpnSubscriptionManager, LSMpnSubscription>,
        Function1<MpnSubscriptionManager, LSMpnSubscription> {
            public static final Closure_invoke_0 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_0 = new Closure_invoke_0();

            Closure_invoke_0() {
            }

            public LSMpnSubscription invoke(MpnSubscriptionManager sub) {
                return sub.m_subscription;
            }

            @Override
            public LSMpnSubscription apply(MpnSubscriptionManager arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        public static final class Closure_invoke_1
        extends haxe.jvm.Function
        implements DirectoryStream.Filter<LSMpnSubscription>,
        Function<LSMpnSubscription, Boolean>,
        Predicate<LSMpnSubscription>,
        Function1<LSMpnSubscription, Boolean> {
            public static final Closure_invoke_1 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_1 = new Closure_invoke_1();

            Closure_invoke_1() {
            }

            public boolean invoke(LSMpnSubscription sub) {
                if (sub.fetch_status() != MpnSubscriptionStatus.Subscribed) {
                    return sub.fetch_status() == MpnSubscriptionStatus.Triggered;
                }
                return true;
            }

            @Override
            public boolean test(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean test(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        public static final class Closure_invoke_3
        extends haxe.jvm.Function
        implements DirectoryStream.Filter<LSMpnSubscription>,
        Function<LSMpnSubscription, Boolean>,
        Predicate<LSMpnSubscription>,
        Function1<LSMpnSubscription, Boolean> {
            public static final Closure_invoke_3 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_3 = new Closure_invoke_3();

            Closure_invoke_3() {
            }

            public boolean invoke(LSMpnSubscription sub) {
                return sub.fetch_status() == MpnSubscriptionStatus.Subscribed;
            }

            @Override
            public boolean test(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(LSMpnSubscription arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean test(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean apply(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public boolean accept(Object arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }

        public static final class Closure_invoke_4
        extends haxe.jvm.Function
        implements Function<MpnSubscriptionManager, LSMpnSubscription>,
        Function1<MpnSubscriptionManager, LSMpnSubscription> {
            public static final Closure_invoke_4 MpnClientMachine$Closure_getMpnSubscriptions_0$Closure_invoke_4 = new Closure_invoke_4();

            Closure_invoke_4() {
            }

            public LSMpnSubscription invoke(MpnSubscriptionManager sub) {
                return sub.m_subscription;
            }

            @Override
            public LSMpnSubscription apply(MpnSubscriptionManager arg0) {
                return this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }
    }
}

