/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.thread;

import haxe.Exception;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;
import haxe.root.Sys;
import hx.concurrent.ServiceBase;
import hx.concurrent.ServiceState;
import hx.concurrent.atomic.AtomicInt;
import hx.concurrent.collection.Queue;
import hx.concurrent.thread.ThreadContext;
import hx.concurrent.thread.Threads;
import sys.thread.Thread;

@ClassReflectionInformation(hasSuperClass=true)
public class ThreadPool
extends ServiceBase {
    public static double DEFAULT_POLL_PERIOD;
    public static AtomicInt.AtomicIntImpl _threadIDs;
    public AtomicInt.AtomicIntImpl _spawnedThreadCount;
    public AtomicInt.AtomicIntImpl _workingThreadCount;
    public Queue<Function> _workQueue;
    public int threadCount;
    public double pollPeriod;

    public double set_pollPeriod(double value) throws Object {
        if (value <= 0.0) {
            throw (RuntimeException)Exception.thrown("[value] must be >= 0");
        }
        this.pollPeriod = value;
        return this.pollPeriod;
    }

    public int get_executingTasks() {
        return this._workingThreadCount._value.get();
    }

    public int get_pendingTasks() {
        return this._workQueue._length._value.get();
    }

    public boolean awaitCompletion(int timeoutMS) {
        ThreadPool _gthis = this;
        return Threads.await(new Closure_awaitCompletion_0(_gthis), timeoutMS, null);
    }

    public int cancelPendingTasks() {
        int canceled = 0;
        while (this._workQueue.pop(null) != null) {
            ++canceled;
        }
        return canceled;
    }

    @Override
    public void onStart() {
        this.set_state(ServiceState.RUNNING);
        ThreadPool _gthis = this;
        int _g1 = this.threadCount;
        for (int _g = 0; _g < _g1; ++_g) {
            Thread.HaxeThread.create(new Closure_onStart_0(_gthis), false);
        }
    }

    public void submit(Function task) throws Object {
        if (task == null) {
            throw (RuntimeException)Exception.thrown("[task] must not be null");
        }
        ThreadPool _gthis = this;
        this._stateLock.execute(new Closure_submit_0(_gthis, task), null);
    }

    @Override
    public void stop() {
        ThreadPool _gthis = this;
        this._stateLock.execute(new Closure_stop_0(_gthis), null);
    }

    public ThreadPool(int numThreads, Boolean autostart) throws Object {
        boolean autostart2;
        AtomicInt.AtomicIntImpl this1 = null;
        this._spawnedThreadCount = this1 = new AtomicInt.AtomicIntImpl(0);
        this1 = null;
        this._workingThreadCount = this1 = new AtomicInt.AtomicIntImpl(0);
        this._workQueue = new Queue();
        this.pollPeriod = DEFAULT_POLL_PERIOD;
        boolean bl = autostart2 = autostart == null ? true : Jvm.toBoolean(autostart);
        if (numThreads < 1) {
            throw (RuntimeException)Exception.thrown("[numThreads] must be > 0");
        }
        this.threadCount = numThreads;
        if (autostart2) {
            this.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        DEFAULT_POLL_PERIOD = 0.001;
        AtomicInt.AtomicIntImpl this1 = new AtomicInt.AtomicIntImpl(0);
        _threadIDs = var0;
    }

    public /* synthetic */ ThreadPool(EmptyConstructor _) {
        super(_);
    }

    public static final class Closure_stop_0
    extends Function
    implements Runnable {
        public final ThreadPool _gthis;

        public Closure_stop_0(ThreadPool _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._gthis.state == ServiceState.RUNNING) {
                this._gthis.set_state(ServiceState.STOPPING);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_onStart_0
    extends Function
    implements Runnable {
        public final ThreadPool _gthis;

        public Closure_onStart_0(ThreadPool _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis._spawnedThreadCount._value.getAndAdd(1);
            ThreadContext context = new ThreadContext(ThreadPool._threadIDs._value.addAndGet(1));
            while (true) {
                Function task;
                if ((task = this._gthis._workQueue.pop(null)) == null) {
                    if (this._gthis.state != ServiceState.RUNNING) break;
                    Sys.sleep(this._gthis.pollPeriod);
                    continue;
                }
                try {
                    this._gthis._workingThreadCount._value.getAndAdd(1);
                    task.invoke(context);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this._gthis._workingThreadCount._value.getAndAdd(-1);
            }
            this._gthis._spawnedThreadCount._value.getAndAdd(-1);
            if (this._gthis._spawnedThreadCount._value.get() == 0) {
                this._gthis._stateLock.execute(new Closure_invoke_0(this._gthis), null);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }

        public static final class Closure_invoke_0
        extends Function {
            public final ThreadPool _gthis;

            public Closure_invoke_0(ThreadPool _gthis) {
                this._gthis = _gthis;
            }

            public ServiceState invoke() {
                return this._gthis.set_state(ServiceState.STOPPED);
            }
        }
    }

    public static final class Closure_awaitCompletion_0
    extends Function {
        public final ThreadPool _gthis;

        public Closure_awaitCompletion_0(ThreadPool _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            if (this._gthis._workQueue._length._value.get() == 0) {
                return this._gthis._workingThreadCount._value.get() == 0;
            }
            return false;
        }
    }

    public static final class Closure_submit_0
    extends Function
    implements Runnable {
        public final ThreadPool _gthis;
        public final Function task;

        /*
         * WARNING - void declaration
         */
        public Closure_submit_0(ThreadPool _gthis, Function function) {
            void task;
            this._gthis = _gthis;
            this.task = task;
        }

        @Override
        public void invoke() throws Object {
            if (this._gthis.state != ServiceState.RUNNING) {
                throw (RuntimeException)Exception.thrown("ThreadPool is not in requried state [RUNNING] but [" + Std.string((Object)this._gthis.state) + "]");
            }
            this._gthis._workQueue.push(this.task);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

