/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal._ParseTools;

import com.fasterxml.jackson.databind.JsonNode;
import com.lightstreamer.client.internal.UpdateInfo;
import com.lightstreamer.internal.FieldValue;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.patch.Json;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.Exception;
import haxe.Int64;
import haxe.ds.IntMap;
import haxe.io.Bytes;
import haxe.io.Encoding;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;

@ClassReflectionInformation(hasSuperClass=false)
public final class ParseTools_Fields_
extends Object {
    public static int parseInt(String s) {
        return Jvm.toInt(NullTools.sure(Std.parseInt(s)));
    }

    public static double parseFloat(String s) {
        return Jvm.toDouble(NullTools.sure(Std.parseFloat(s)));
    }

    public static long parseLong(String s) {
        return Int64.Int64_Impl_.parseString(s);
    }

    public static UpdateInfo parseUpdate(String message) {
        int tableIndex = ParseTools_Fields_.checkedIndexOf(message, ",", null) + 1;
        int itemIndex = ParseTools_Fields_.checkedIndexOf(message, ",", tableIndex) + 1;
        int fieldsIndex = ParseTools_Fields_.checkedIndexOf(message, ",", itemIndex) + 1;
        int table = ParseTools_Fields_.parseInt(StringExt.substring(message, tableIndex, itemIndex - 1));
        int item = ParseTools_Fields_.parseInt(StringExt.substring(message, itemIndex, fieldsIndex - 1));
        IntMap<FieldValue> values = new IntMap<FieldValue>();
        int fieldStart = fieldsIndex - 1;
        int nextFieldIndex = 1;
        while (fieldStart < message.length()) {
            FieldValue v;
            String value;
            int fieldEnd = StringExt.indexOf(message, "|", fieldStart + 1);
            if (fieldEnd == -1) {
                fieldEnd = message.length();
            }
            if (Jvm.stringCompare(value = StringExt.substring(message, fieldStart + 1, fieldEnd), "") == 0) {
                v = FieldValue.unchanged;
                values.set(nextFieldIndex, v);
                ++nextFieldIndex;
            } else if (Jvm.stringCompare(value, "#") == 0) {
                v = FieldValue.changed(null);
                values.set(nextFieldIndex, v);
                ++nextFieldIndex;
            } else if (Jvm.stringCompare(value, "$") == 0) {
                v = FieldValue.changed("");
                values.set(nextFieldIndex, v);
                ++nextFieldIndex;
            } else if (Jvm.stringCompare(StringExt.charAt(value, 0), "^") == 0) {
                FieldValue v2;
                Integer endIndex;
                if (Jvm.stringCompare(StringExt.charAt(value, 1), "P") == 0) {
                    endIndex = null;
                    String unquoted = ParseTools_Fields_.unquote(StringExt.substring(value, 2, endIndex));
                    try {
                        JsonNode patch = Json.Json_Impl_._new(unquoted);
                        v2 = FieldValue.jsonPatch(patch);
                        values.set(nextFieldIndex, v2);
                        ++nextFieldIndex;
                    }
                    catch (Throwable _g) {
                        Exception _g2 = Exception.caught(_g);
                        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                            LoggerTools_Fields_.sessionLogger.error("Invalid JSON patch " + unquoted + ": " + _g2.get_message() + "\n" + _g2.details(), null);
                        }
                        throw new IllegalStateException("The JSON Patch for the field " + nextFieldIndex + " is not well-formed");
                    }
                } else if (Jvm.stringCompare(StringExt.charAt(value, 1), "T") == 0) {
                    String unquoted;
                    endIndex = null;
                    String patch = unquoted = ParseTools_Fields_.unquote(StringExt.substring(value, 2, endIndex));
                    v2 = FieldValue.diffPatch(patch);
                    values.set(nextFieldIndex, v2);
                    ++nextFieldIndex;
                } else {
                    endIndex = null;
                    int count = ParseTools_Fields_.parseInt(StringExt.substring(value, 1, endIndex));
                    int _g = 0;
                    while (_g < count) {
                        ++_g;
                        v2 = FieldValue.unchanged;
                        values.set(nextFieldIndex, v2);
                        ++nextFieldIndex;
                    }
                }
            } else {
                v = FieldValue.changed(ParseTools_Fields_.unquote(value));
                values.set(nextFieldIndex, v);
                ++nextFieldIndex;
            }
            fieldStart = fieldEnd;
        }
        return new UpdateInfo(table, item, values);
    }

    public static int checkedIndexOf(String s, String needle, Integer startIndex) {
        int i = StringExt.indexOf(s, needle, startIndex);
        if (i == -1) {
            throw new IllegalStateException("string not found");
        }
        return i;
    }

    public static String unquote(String s) {
        Bytes bb = Bytes.ofString(s, Encoding.UTF8);
        int i = 0;
        int j = 0;
        while (i < bb.length) {
            if ((bb.b[i] & 0xFF) == 37) {
                int firstHexDigit = ParseTools_Fields_.hexToNum(bb.b[i + 1] & 0xFF);
                int secondHexDigit = ParseTools_Fields_.hexToNum(bb.b[i + 2] & 0xFF);
                bb.b[j++] = (byte)((firstHexDigit << 4) + secondHexDigit);
                i += 3;
                continue;
            }
            bb.b[j++] = (byte)(bb.b[i++] & 0xFF);
        }
        String ss = bb.getString(0, j, Encoding.UTF8);
        return ss;
    }

    public static int hexToNum(int ascii) {
        int hex = 0;
        hex = ascii - 97 + 10;
        if (hex <= 9 && (hex = ascii - 65 + 10) <= 9) {
            hex = ascii - 48;
        }
        return hex;
    }

    public /* synthetic */ ParseTools_Fields_(EmptyConstructor _) {
    }
}

