/*
 * Decompiled with CFR 0.152.
 */
package com.light.permission.runtime;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.util.Log;
import com.light.permission.annotations.CheckPermissions;
import com.light.permission.annotations.IsPermissionHandler;
import com.light.permission.runtime.Operator;
import com.light.permission.runtime.OperatorFactory;
import com.light.permission.runtime.PermissionConfig;
import com.light.permission.runtime.PermissionGrantedResult;
import com.light.permission.runtime.PermissionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class PermissionProcessor {
    private static final String TAG = "PermissionProcessor";
    private static final int PERMISSION_REQUEST = 1200;

    public static Object process(ProceedingJoinPoint joinPoint, Object source) {
        String[] permissions = PermissionProcessor.getPermissionsRequired(joinPoint);
        if (permissions != null && permissions.length > 0) {
            Operator operator = OperatorFactory.getSuitableOperator(source);
            if (!operator.hasPermissions(source, permissions)) {
                new PermissionRequest(source, permissions).request();
                return null;
            }
        } else {
            Log.e((String)TAG, (String)"No found the permissions that you request!");
        }
        return PermissionProcessor.runOriginLogic(joinPoint, source);
    }

    private static String[] getPermissionsRequired(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        return method.getAnnotation(CheckPermissions.class).value();
    }

    private static Object runOriginLogic(ProceedingJoinPoint joinPoint, Object source) {
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static PermissionHandler findPermissionHandler(Object source) {
        if (source == null) {
            return null;
        }
        Class<?> clazz = source.getClass();
        if (clazz == null) {
            return null;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(IsPermissionHandler.class)) continue;
            field.setAccessible(true);
            try {
                PermissionHandler handler = (PermissionHandler)field.get(source);
                return handler;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)String.format("Error:%1s is not instance of %2s", field.getName(), PermissionHandler.class.getName()));
                return null;
            }
        }
        return null;
    }

    public static void handleResult(Context ctx, PermissionHandler handler, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (handler == null || permissions.length != grantResults.length) {
            return;
        }
        PermissionGrantedResult[] results = new PermissionGrantedResult[permissions.length];
        if (grantResults.length > 0) {
            Operator operator = OperatorFactory.getSuitableOperator(ctx);
            boolean hasNoGranted = false;
            for (int i = 0; i < grantResults.length; ++i) {
                boolean isGranted = grantResults[i] == 0;
                results[i] = new PermissionGrantedResult(permissions[i], isGranted, operator.shouldShowRequestPermissionRationale(ctx, permissions[i]));
                if (isGranted) continue;
                hasNoGranted = true;
            }
            if (hasNoGranted) {
                handler.onPermissionsFailed(results);
            } else {
                handler.onAllPermissionsGranted(permissions);
            }
        } else {
            handler.onPermissionsFailed(results);
        }
    }

    private static class PermissionRequest {
        private Object source;
        private String[] permissionsRequired;

        PermissionRequest(Object source, String[] permissionsRequired) {
            this.source = source;
            this.permissionsRequired = permissionsRequired;
        }

        void request() {
            final Operator operator = OperatorFactory.getSuitableOperator(this.source);
            PermissionHandler handler = PermissionProcessor.findPermissionHandler(this.source);
            if (handler == null) {
                operator.requestPermissions(this.source, this.permissionsRequired, 1200);
                return;
            }
            PermissionConfig config = this.getConfig(handler);
            if (config.showExplanationWhenNoPermission) {
                Dialog dialog;
                ArrayList<String> permissionsShouldShowRationale = new ArrayList<String>();
                for (String permission : this.permissionsRequired) {
                    if (config.referToSysDecisionAboutShowExplanation && !operator.shouldShowRequestPermissionRationale(this.source, permission)) continue;
                    permissionsShouldShowRationale.add(permission);
                }
                if (!permissionsShouldShowRationale.isEmpty() && (dialog = handler.getExplanationDialog(operator.getContext(this.source), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        operator.requestPermissions(PermissionRequest.this.source, PermissionRequest.this.permissionsRequired, 1200);
                    }
                }, permissionsShouldShowRationale.toArray(new String[0]))) != null) {
                    dialog.setCancelable(false);
                    dialog.show();
                    return;
                }
            }
            operator.requestPermissions(this.source, this.permissionsRequired, 1200);
        }

        private PermissionConfig getConfig(PermissionHandler handler) {
            PermissionConfig config = null;
            if (handler != null) {
                config = handler.getConfig();
            }
            if (config == null) {
                config = this.getDefaultConfig();
            }
            return config;
        }

        private PermissionConfig getDefaultConfig() {
            return new PermissionConfig();
        }
    }
}

