/*
 * Decompiled with CFR 0.152.
 */
package com.light.permission.runtime;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.light.permission.runtime.Operator;
import java.util.HashMap;
import java.util.Map;

public class OperatorFactory {
    private static Map<String, Operator> operators = new HashMap<String, Operator>();

    public static Operator getSuitableOperator(Object source) {
        if (source instanceof android.app.Activity) {
            Operator operator = operators.get("activity_operator");
            if (null == operator) {
                operator = new Activity();
            }
            operators.put("activity_operator", operator);
            return operator;
        }
        if (source instanceof Fragment) {
            Operator operator = operators.get("app_fragment_operator");
            if (operator == null) {
                operator = new AppFragment();
            }
            operators.put("app_fragment_operator", operator);
            return operator;
        }
        if (source instanceof android.support.v4.app.Fragment) {
            Operator operator = operators.get("v4_fragment_operator");
            if (operator == null) {
                operator = new V4Fragment();
            }
            operators.put("v4_fragment_operator", operator);
            return operator;
        }
        throw new IllegalArgumentException(String.format("This source(%s) is not supported!", source == null ? "null" : source.toString()));
    }

    public static void release() {
        if (operators != null) {
            operators.clear();
        }
    }

    static class Utils {
        private static final String TAG = "Operator.Utils";

        Utils() {
        }

        static boolean hasPermissions(Context context, String ... permissions) {
            if (Build.VERSION.SDK_INT < 23) {
                Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
                return true;
            }
            for (String perm : permissions) {
                boolean hasPerm;
                boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
                if (hasPerm) continue;
                return false;
            }
            return true;
        }
    }

    private static class V4Fragment
    implements Operator {
        static final String TAG = "v4_fragment_operator";

        private V4Fragment() {
        }

        @Override
        public Context getContext(Object source) {
            return ((android.support.v4.app.Fragment)source).getContext();
        }

        @Override
        public boolean hasPermissions(Object source, String ... permissions) {
            return Utils.hasPermissions(this.getContext(source), permissions);
        }

        @Override
        public void requestPermissions(Object source, @NonNull String[] permissions, int requestCode) {
            ((android.support.v4.app.Fragment)source).requestPermissions(permissions, requestCode);
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Object source, @NonNull String permission) {
            return ((android.support.v4.app.Fragment)source).shouldShowRequestPermissionRationale(permission);
        }
    }

    private static class AppFragment
    implements Operator {
        static final String TAG = "app_fragment_operator";

        private AppFragment() {
        }

        @Override
        @TargetApi(value=11)
        public Context getContext(Object source) {
            return ((Fragment)source).getActivity();
        }

        @Override
        public boolean hasPermissions(Object source, String ... permissions) {
            return Utils.hasPermissions(this.getContext(source), permissions);
        }

        @Override
        public void requestPermissions(Object source, @NonNull String[] permissions, int requestCode) {
            if (Build.VERSION.SDK_INT >= 23) {
                ((Fragment)source).requestPermissions(permissions, requestCode);
            }
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Object source, @NonNull String permission) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((Fragment)source).shouldShowRequestPermissionRationale(permission);
            }
            return false;
        }
    }

    private static class Activity
    implements Operator {
        static final String TAG = "activity_operator";

        private Activity() {
        }

        @Override
        public Context getContext(Object source) {
            return (Context)source;
        }

        @Override
        public boolean hasPermissions(Object source, String ... permissions) {
            return Utils.hasPermissions(this.getContext(source), permissions);
        }

        @Override
        public void requestPermissions(Object source, @NonNull String[] permissions, int requestCode) {
            if (Build.VERSION.SDK_INT >= 23) {
                ((android.app.Activity)source).requestPermissions(permissions, requestCode);
            } else {
                ActivityCompat.requestPermissions((android.app.Activity)((android.app.Activity)source), (String[])permissions, (int)requestCode);
            }
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Object source, @NonNull String permission) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((android.app.Activity)source).shouldShowRequestPermissionRationale(permission);
            }
            return ActivityCompat.shouldShowRequestPermissionRationale((android.app.Activity)((android.app.Activity)source), (String)permission);
        }
    }
}

