/*
 * Decompiled with CFR 0.152.
 */
package com.light.permission.runtime;

import android.os.Build;
import android.util.Log;
import com.light.permission.annotations.CheckPermissions;
import com.light.permission.runtime.PermissionProcessor;
import java.lang.reflect.Method;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class AspectProcessor {
    private static final String POINT_CUT_CHECK_PERMISSION = "execution(@com.light.permission.annotations.CheckPermissions * *(..))";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AspectProcessor ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.light.permission.annotations.CheckPermissions * *(..))")
    public void methodCheckPermission() {
    }

    @Around(value="methodCheckPermission() && this(source)")
    public Object CheckPermissions(ProceedingJoinPoint joinPoint, Object source) throws Throwable {
        Log.e((String)"TAGA", (String)("CheckPermission:" + source.toString()));
        Log.e((String)"TAGA", (String)("source.getClass:" + source.getClass()));
        Log.e((String)"TAGA", (String)("target:" + joinPoint.getTarget().getClass()));
        Log.e((String)"TAGA", (String)("this:" + joinPoint.getThis().getClass()));
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String[] permissionList = method.getAnnotation(CheckPermissions.class).value();
        Log.e((String)"TAGA", (String)(">>> " + signature.getName() + "() requires " + permissionList.length + " permission"));
        if (Build.VERSION.SDK_INT < 23) {
            return joinPoint.proceed();
        }
        return PermissionProcessor.process(joinPoint, source);
    }

    public static AspectProcessor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.light.permission.runtime.AspectProcessor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            AspectProcessor.ajc$perSingletonInstance = new AspectProcessor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

