/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sample;

import com.liferay.client.extension.util.spring.boot3.BaseRestController;

import org.json.JSONObject;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Andrea Sbarra
 */
@RequestMapping("/action")
@RestController
public class ActionRestController extends BaseRestController {

	@PostMapping
	public ResponseEntity<String> post(
		@AuthenticationPrincipal Jwt jwt, @RequestBody String json) {

		JSONObject jsonObject = new JSONObject(json);

		return new ResponseEntity<>(
			patch(
				"Bearer " + jwt.getTokenValue(),
				new JSONObject(
				).put(
					"purchaseOrderNumber", jsonObject.getString("pon")
				).toString(),
				createURI(
					"/o/headless-commerce-delivery-cart/v1.0/carts/",
					jsonObject.getLong("commerceOrderId"))),
			HttpStatus.OK);
	}

}