/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.axis;

import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.UncommittedServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.utils.cache.MethodCache;

public class AxisServlet
extends org.apache.axis.transport.http.AxisServlet {
    private static final Field _CACHE_FIELD;
    private static final String _HTML_BOTTOM_WRAPPER = "</body></html>";
    private static final String _HTML_TOP_WRAPPER = "<html><body>";
    private static Log _log;
    private String _correctLongArray;
    private String _correctOrderByComparator;
    private String _correctStringArray;
    private boolean _fixContent;
    private String _incorrectLongArray;
    private String _incorrectOrderByComparator;
    private String _incorrectStringArray;
    private boolean _ready;
    private ServletConfig _servletConfig;

    public void destroy() {
        if (ServerDetector.isWebLogic()) {
            this.doDestroy();
        } else {
            DestroyThread destroyThread = new DestroyThread();
            destroyThread.start();
            try {
                destroyThread.join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            Exception e = destroyThread.getException();
            if (e != null) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this._servletConfig = servletConfig;
        StringBundler sb = new StringBundler(9);
        sb.append("<complexType abstract=\"true\" name=\"OrderByComparator\">");
        sb.append("<sequence><element name=\"ascending\" ");
        sb.append("type=\"xsd:boolean\"/><element name=\"orderBy\" ");
        sb.append("nillable=\"true\" type=\"soapenc:string\"/><element ");
        sb.append("name=\"orderByConditionFields\" nillable=\"true\" ");
        sb.append("type=\"impl:ArrayOf_xsd_string\"/><element ");
        sb.append("name=\"orderByFields\" nillable=\"true\" ");
        sb.append("type=\"impl:ArrayOf_xsd_string\"/></sequence>");
        sb.append("</complexType>");
        this._correctOrderByComparator = sb.toString();
        sb = new StringBundler(5);
        sb.append("<complexType name=\"ArrayOf_xsd_long\"><complexContent>");
        sb.append("<restriction base=\"soapenc:Array\"><attribute ");
        sb.append("ref=\"soapenc:arrayType\" ");
        sb.append("wsdl:arrayType=\"soapenc:long[]\"/></restriction>");
        sb.append("</complexContent></complexType>");
        this._correctLongArray = sb.toString();
        sb = new StringBundler(5);
        sb.append("<complexType name=\"ArrayOf_xsd_string\"><complexContent>");
        sb.append("<restriction base=\"soapenc:Array\"><attribute ");
        sb.append("ref=\"soapenc:arrayType\" ");
        sb.append("wsdl:arrayType=\"soapenc:string[]\"/></restriction>");
        sb.append("</complexContent></complexType>");
        this._correctStringArray = sb.toString();
        sb = new StringBundler(2);
        sb.append("<complexType name=\"OrderByComparator\"><simpleContent>");
        sb.append("<extension/></simpleContent></complexType>");
        this._incorrectOrderByComparator = sb.toString();
        sb = new StringBundler(2);
        sb.append("<complexType name=\"ArrayOf_xsd_long\"><simpleContent>");
        sb.append("<extension/></simpleContent></complexType>");
        this._incorrectLongArray = sb.toString();
        sb = new StringBundler(2);
        sb.append("<complexType name=\"ArrayOf_xsd_string\"><simpleContent>");
        sb.append("<extension/></simpleContent></complexType>");
        this._incorrectStringArray = sb.toString();
        if (ServerDetector.isResin() || ServerDetector.isWebLogic()) {
            this.doInit();
        } else {
            InitThread initThread = new InitThread();
            initThread.start();
            try {
                initThread.join();
            }
            catch (InterruptedException ie) {
                throw new ServletException((Throwable)ie);
            }
            Exception e = initThread.getException();
            if (e != null) {
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (!this._ready) {
                return;
            }
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            super.service(request, (HttpServletResponse)bufferCacheServletResponse);
            String contentType = bufferCacheServletResponse.getContentType();
            response.setContentType(contentType);
            String content = bufferCacheServletResponse.getString();
            if (this._fixContent) {
                if (contentType.contains("text/html")) {
                    content = _HTML_TOP_WRAPPER.concat(content).concat(_HTML_BOTTOM_WRAPPER);
                } else if (contentType.contains("text/xml")) {
                    content = this.fixXml(content);
                }
            }
            ServletResponseUtil.write((HttpServletResponse)new UncommittedServletResponse(response), (byte[])content.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                ThreadLocal cache = (ThreadLocal)_CACHE_FIELD.get(null);
                if (cache != null) {
                    cache.remove();
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void doDestroy() {
        this._ready = false;
        super.destroy();
    }

    protected void doInit() throws ServletException {
        super.init(this._servletConfig);
        this._fixContent = GetterUtil.getBoolean((String)this._servletConfig.getInitParameter("fix-content"), (boolean)true);
        this._ready = true;
    }

    protected String fixXml(String xml) throws Exception {
        if (!xml.contains("<wsdl:definitions")) {
            return xml;
        }
        xml = StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "  ", "> <", this._incorrectOrderByComparator, this._incorrectLongArray, this._incorrectStringArray}, (String[])new String[]{"", "", "", "><", this._correctOrderByComparator, this._correctLongArray, this._correctStringArray});
        Document document = SAXReaderUtil.read((String)xml);
        return document.formattedString();
    }

    static {
        _log = LogFactoryUtil.getLog(AxisServlet.class);
        try {
            _CACHE_FIELD = ReflectionUtil.getDeclaredField(MethodCache.class, (String)"cache");
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError((Throwable)e);
        }
    }

    private class InitThread
    extends Thread {
        private Exception _exception;

        public InitThread() {
            this.setDaemon(true);
        }

        public Exception getException() {
            return this._exception;
        }

        @Override
        public void run() {
            try {
                AxisServlet.this.doInit();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }

    private class DestroyThread
    extends Thread {
        private Exception _exception;

        public DestroyThread() {
            this.setDaemon(true);
        }

        public Exception getException() {
            return this._exception;
        }

        @Override
        public void run() {
            try {
                AxisServlet.this.doDestroy();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }
}

