/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.freemarker;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.template.TemplateTaglibSupportProvider;
import com.liferay.portal.kernel.util.ServiceLoader;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class FreeMarkerPortlet
extends MVCPortlet {
    private static Log _log = LogFactoryUtil.getLog(FreeMarkerPortlet.class);
    private TemplateTaglibSupportProvider _templateTaglibSupportProvider;

    public void destroy() {
        super.destroy();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        TemplateManagerUtil.destroy((ClassLoader)clazz.getClassLoader());
    }

    protected TemplateTaglibSupportProvider getTaglibSupportProvider() throws Exception {
        if (this._templateTaglibSupportProvider != null) {
            return this._templateTaglibSupportProvider;
        }
        List templateTaglibSupportProviders = ServiceLoader.load(TemplateTaglibSupportProvider.class);
        if (!templateTaglibSupportProviders.isEmpty()) {
            this._templateTaglibSupportProvider = (TemplateTaglibSupportProvider)templateTaglibSupportProviders.get(0);
        }
        return this._templateTaglibSupportProvider;
    }

    @Override
    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletContext portletContext = this.getPortletContext();
        String servletContextName = portletContext.getPortletContextName();
        String resourcePath = servletContextName.concat("_SERVLET_CONTEXT_").concat(path);
        boolean resourceExists = false;
        try {
            resourceExists = TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath);
        }
        catch (TemplateException te) {
            throw new IOException(te.getMessage());
        }
        if (!resourceExists) {
            _log.error((Object)(String.valueOf(path) + " is not a valid include"));
        } else {
            try {
                TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)resourcePath);
                Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
                TemplateTaglibSupportProvider templateTaglibSupportProvider = this.getTaglibSupportProvider();
                if (templateTaglibSupportProvider != null) {
                    templateTaglibSupportProvider.addTaglibSupport(template, servletContextName, portletRequest, portletResponse);
                }
                template.put("portletContext", (Object)this.getPortletContext());
                template.put("userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
                UnsyncStringWriter writer = null;
                if (portletResponse instanceof MimeResponse) {
                    MimeResponse mimeResponse = (MimeResponse)portletResponse;
                    writer = UnsyncPrintWriterPool.borrow((Writer)mimeResponse.getWriter());
                } else {
                    writer = new UnsyncStringWriter();
                }
                template.processTemplate((Writer)writer);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", "true");
        }
    }
}

