/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.scripting;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class ScriptingPortlet
extends GenericPortlet {
    protected String actionFile;
    protected String editFile;
    protected String[] globalFiles;
    protected String globalScript;
    protected String helpFile;
    protected String language;
    protected String resourceFile;
    protected String viewFile;
    private static final String _ERROR = ScriptingPortlet.class + ".ERROR";
    private static Log _log = LogFactoryUtil.getLog(ScriptingPortlet.class);

    public void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String fileName = this.getFileName(renderRequest);
        if (fileName != null) {
            this.include(fileName, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        this.include(this.helpFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        this.include(this.viewFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void init() {
        this.actionFile = this.getInitParameter("action-file");
        this.editFile = this.getInitParameter("edit-file");
        this.helpFile = this.getInitParameter("help-file");
        this.resourceFile = this.getInitParameter("resource-file");
        this.viewFile = this.getInitParameter("view-file");
        this.language = this.getInitParameter("scripting-language");
        this.globalFiles = StringUtil.split((String)this.getInitParameter("global-files"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.include(this.actionFile, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.doRender(renderRequest, renderResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        this.include(this.resourceFile, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void declareBeans(InputStream is, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ScriptingException {
        String script = new String(FileUtil.getBytes((InputStream)is));
        this.declareBeans(script, portletRequest, portletResponse);
    }

    protected void declareBeans(String script, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ScriptingException {
        script = String.valueOf(this.getGlobalScript()) + script;
        PortletConfig portletConfig = this.getPortletConfig();
        PortletContext portletContext = this.getPortletContext();
        Map portletObjects = ScriptingUtil.getPortletObjects((PortletConfig)portletConfig, (PortletContext)portletContext, (PortletRequest)portletRequest, (PortletResponse)portletResponse);
        ScriptingUtil.exec(null, (Map)portletObjects, (String)this.language, (String)script, (ClassLoader[])new ClassLoader[0]);
    }

    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Object error = SessionErrors.get((PortletRequest)renderRequest, (String)_ERROR);
        if (error != null) {
            Exception e = (Exception)error;
            this.writeErrorMessage(renderRequest, renderResponse, e.getMessage());
            return;
        }
        super.render(renderRequest, renderResponse);
        error = SessionErrors.get((PortletRequest)renderRequest, (String)_ERROR);
        if (error != null) {
            Exception e = (Exception)error;
            this.writeErrorMessage(renderRequest, renderResponse, e.getMessage());
        }
    }

    protected String getFileName(RenderRequest renderRequest) {
        return renderRequest.getParameter("file");
    }

    protected String getGlobalScript() throws IOException {
        if (this.globalScript != null) {
            return this.globalScript;
        }
        if (this.globalFiles.length == 0) {
            this.globalScript = "";
            return this.globalScript;
        }
        StringBundler sb = new StringBundler();
        String[] stringArray = this.globalFiles;
        int n = this.globalFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String globalFile = stringArray[n2];
            InputStream is = this.getPortletContext().getResourceAsStream(globalFile);
            if (is == null && _log.isWarnEnabled()) {
                _log.warn((Object)("Global file " + globalFile + " does not exist"));
            }
            if (is != null) {
                String script = new String(FileUtil.getBytes((InputStream)is));
                sb.append(script);
                sb.append("\n");
            }
            ++n2;
        }
        this.globalScript = sb.toString();
        return this.globalScript;
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException {
        InputStream is = this.getPortletContext().getResourceAsStream(path);
        if (is == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid " + this.language + " file"));
            return;
        }
        try {
            try {
                this.declareBeans(is, portletRequest, portletResponse);
            }
            catch (ScriptingException se) {
                SessionErrors.add((PortletRequest)portletRequest, (String)_ERROR, (Object)((Object)se));
                is.close();
            }
        }
        finally {
            is.close();
        }
    }

    protected void writeErrorMessage(RenderRequest renderRequest, RenderResponse renderResponse, String errorMessage) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        StringBundler sb = new StringBundler(6);
        sb.append("<div class=\"alert alert-error\">");
        sb.append(themeDisplay.translate("an-unexpected-error-occurred"));
        sb.append("</div>");
        if (PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"CONFIGURATION")) {
            sb.append("<pre>");
            sb.append(HtmlUtil.escape((String)errorMessage));
            sb.append("</pre>");
        }
        renderResponse.setContentType("text/html");
        PortletResponseUtil.write((MimeResponse)renderResponse, (String)sb.toString());
    }
}

