/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.jsf.common;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.bridges.jsf.common.FacesMessageUtil;
import com.liferay.util.bridges.jsf.common.JSFPortletUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.PortletPreferences;

public class PortletPreferencesManagedBean {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesManagedBean.class);
    private PortletPreferences _portletPreferences;
    private Map<String, String> _preferences;

    public PortletPreferencesManagedBean() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this._portletPreferences = JSFPortletUtil.getPortletPreferences(facesContext);
        this._preferences = new HashMap<String, String>();
        Enumeration enu = this._portletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = this._portletPreferences.getValue(name, null);
            this._preferences.put(name, value);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("{name=" + name + ", value=" + value + "}"));
        }
    }

    public Map<String, String> getPreferences() {
        return this._preferences;
    }

    public String resetDefaultValues() {
        try {
            Enumeration enu = this._portletPreferences.getNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (this._portletPreferences.isReadOnly(name)) continue;
                this._portletPreferences.reset(name);
                String value = this._portletPreferences.getValue(name, null);
                this._preferences.put(name, value);
                this._portletPreferences.store();
            }
            this.addInfoMessage("you-have-successfully-reset-your-preferences");
            return "Success";
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.addErrorMessage("an-error-occurred-while-resetting-your-preferences");
            return "Failure";
        }
    }

    public String submit() {
        try {
            Enumeration enu = this._portletPreferences.getNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (this._portletPreferences.isReadOnly(name)) continue;
                String value = this._preferences.get(name);
                this._portletPreferences.setValue(name, value);
            }
            this._portletPreferences.store();
            this.addInfoMessage("you-have-successfully-updated-your-preferences");
            return "Success";
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.addErrorMessage("an-error-occurred-while-updating-your-preferences");
            return "Failure";
        }
    }

    protected void addErrorMessage(String key) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesMessageUtil.error(facesContext, key);
    }

    protected void addInfoMessage(String key) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesMessageUtil.info(facesContext, key);
    }
}

