/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.bsf;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public abstract class BaseBSFPortlet
extends GenericPortlet {
    protected String actionFile;
    protected BSFManager bsfManager;
    protected String editFile;
    protected String[] globalFiles;
    protected String helpFile;
    protected String resourceFile;
    protected String viewFile;
    private static Log _log = LogFactoryUtil.getLog(BaseBSFPortlet.class);

    public void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String file = renderRequest.getParameter(this.getFileParam());
        if (file != null) {
            this.include(file, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        this.include(this.helpFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        this.include(this.viewFile, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void init() {
        this.editFile = this.getInitParameter("edit-file");
        this.helpFile = this.getInitParameter("help-file");
        this.viewFile = this.getInitParameter("view-file");
        this.actionFile = this.getInitParameter("action-file");
        this.resourceFile = this.getInitParameter("resource-file");
        this.globalFiles = StringUtil.split((String)this.getInitParameter("global-files"));
        BSFManager.registerScriptingEngine((String)this.getScriptingEngineLanguage(), (String)this.getScriptingEngineClassName(), (String[])new String[]{this.getScriptingEngineExtension()});
        this.bsfManager = new BSFManager();
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.include(this.actionFile, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        this.include(this.resourceFile, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void declareBeans(InputStream is, PortletRequest portletRequest, PortletResponse portletResponse) throws BSFException, IOException {
        this.declareBeans(new String(FileUtil.getBytes((InputStream)is)), portletRequest, portletResponse);
    }

    protected void declareBeans(String code, PortletRequest portletRequest, PortletResponse portletResponse) throws BSFException, IOException {
        String script = this.getGlobalScript().concat(code);
        PortletConfig portletConfig = this.getPortletConfig();
        PortletContext portletContext = this.getPortletContext();
        PortletPreferences preferences = portletRequest.getPreferences();
        Map userInfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
        this.bsfManager.declareBean("portletConfig", (Object)portletConfig, PortletConfig.class);
        this.bsfManager.declareBean("portletContext", (Object)portletContext, PortletContext.class);
        this.bsfManager.declareBean("preferences", (Object)preferences, PortletPreferences.class);
        this.bsfManager.declareBean("userInfo", (Object)userInfo, Map.class);
        if (portletRequest instanceof ActionRequest) {
            this.bsfManager.declareBean("actionRequest", (Object)portletRequest, ActionRequest.class);
        } else if (portletRequest instanceof RenderRequest) {
            this.bsfManager.declareBean("renderRequest", (Object)portletRequest, RenderRequest.class);
        } else if (portletRequest instanceof ResourceRequest) {
            this.bsfManager.declareBean("resourceRequest", (Object)portletRequest, ResourceRequest.class);
        }
        if (portletResponse instanceof ActionResponse) {
            this.bsfManager.declareBean("actionResponse", (Object)portletResponse, ActionResponse.class);
        } else if (portletResponse instanceof RenderResponse) {
            this.bsfManager.declareBean("renderResponse", (Object)portletResponse, RenderResponse.class);
        } else if (portletResponse instanceof ResourceResponse) {
            this.bsfManager.declareBean("resourceResponse", (Object)portletResponse, ResourceResponse.class);
        }
        this.bsfManager.exec(this.getScriptingEngineLanguage(), "(java)", 1, 1, (Object)script);
    }

    protected abstract String getFileParam();

    protected String getGlobalScript() throws IOException {
        if (this.globalFiles.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler();
        int i = 0;
        while (i < this.globalFiles.length) {
            InputStream is = this.getPortletContext().getResourceAsStream(this.globalFiles[i]);
            if (is == null && _log.isWarnEnabled()) {
                _log.warn((Object)("Global file " + this.globalFiles[i] + " does not exist"));
            }
            if (is != null) {
                sb.append(new String(FileUtil.getBytes((InputStream)is)));
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    protected abstract String getScriptingEngineClassName();

    protected abstract String getScriptingEngineExtension();

    protected abstract String getScriptingEngineLanguage();

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException {
        InputStream is = this.getPortletContext().getResourceAsStream(path);
        if (is == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid " + this.getScriptingEngineLanguage() + " file"));
            return;
        }
        try {
            try {
                this.declareBeans(is, portletRequest, portletResponse);
            }
            catch (BSFException bsfe) {
                this.logBSFException(bsfe, path);
                is.close();
            }
        }
        finally {
            is.close();
        }
    }

    protected void logBSFException(BSFException bsfe, String path) {
        String message = "The script at " + path + " or one of the global files has errors.";
        Throwable t = bsfe.getTargetException();
        _log.error((Object)message, t);
    }
}

