/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.util.bridges.alloy.AlloyController;
import com.liferay.util.bridges.alloy.BaseAlloyControllerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class AlloyPortlet
extends GenericPortlet {
    private static Log _log = LogFactoryUtil.getLog(AlloyPortlet.class);
    private Set<AlloyController> _alloyControllers = new HashSet<AlloyController>();
    private Map<String, String> _defaultRouteParameters = new HashMap<String, String>();

    public void destroy() {
        for (AlloyController alloyController : this._alloyControllers) {
            MessageListener schedulerMessageListener;
            BaseAlloyControllerImpl baseAlloyControllerImpl = (BaseAlloyControllerImpl)alloyController;
            Indexer indexer = baseAlloyControllerImpl.indexer;
            if (indexer != null) {
                IndexerRegistryUtil.unregister((Indexer)indexer);
            }
            if ((schedulerMessageListener = baseAlloyControllerImpl.schedulerMessageListener) == null) continue;
            try {
                SchedulerEngineHelperUtil.unschedule((String)baseAlloyControllerImpl.getSchedulerJobName(), (String)baseAlloyControllerImpl.getSchedulerGroupName(), (StorageType)StorageType.MEMORY_CLUSTERED);
                MessageBusUtil.removeDestination((String)baseAlloyControllerImpl.getSchedulerDestinationName());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        Portlet portlet = liferayPortletConfig.getPortlet();
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        Router router = friendlyURLMapper.getRouter();
        router.urlToParameters("GET", this._defaultRouteParameters);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)actionRequest);
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest);
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)resourceRequest);
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected Map<String, String> getDefaultRouteParameters() {
        return this._defaultRouteParameters;
    }

    protected String getPath(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        Portlet portlet = liferayPortletConfig.getPortlet();
        String controllerPath = ParamUtil.getString((PortletRequest)portletRequest, (String)"controller");
        if (Validator.isNull((String)controllerPath)) {
            Map<String, String> defaultRouteParameters = this.getDefaultRouteParameters();
            controllerPath = defaultRouteParameters.get("controller");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("/WEB-INF/jsp/");
        sb.append(portlet.getFriendlyURLMapping());
        sb.append("/controllers/");
        sb.append(controllerPath);
        sb.append("_controller.jsp");
        return sb.toString();
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortletException {
        PortletContext portletContext = this.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
    }

    protected void registerAlloyController(AlloyController alloyController) {
        if (!this._alloyControllers.contains(alloyController)) {
            this._alloyControllers.add(alloyController);
        }
    }
}

