/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.php;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DynamicServletConfig;
import com.liferay.portal.kernel.servlet.PortletServletObjectsFactory;
import com.liferay.portal.kernel.servlet.ServletObjectsFactory;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.util.bridges.common.ScriptPostProcess;
import com.liferay.util.bridges.php.PHPServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PHPPortlet
extends GenericPortlet {
    private static final String _PHP_URI_PARAM = "phpURI";
    private static final String _QUERCUS_SERVLET = "com.caucho.quercus.servlet.QuercusServlet";
    private static Log _log = LogFactoryUtil.getLog(PHPPortlet.class);
    protected String editUri;
    protected String helpUri;
    protected String viewUri;
    protected boolean addPortletParams;
    protected ServletObjectsFactory servletObjectsFactory;
    protected HttpServlet quercusServlet;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.editUri = this.getInitParameter("edit-uri");
        this.helpUri = this.getInitParameter("help-uri");
        this.viewUri = this.getInitParameter("view-uri");
        this.addPortletParams = GetterUtil.getBoolean((String)portletConfig.getInitParameter("add-portlet-params"), (boolean)true);
        String servletObjectsFactoryName = GetterUtil.getString((String)this.getInitParameter("servlet-objects-factory"), (String)PortletServletObjectsFactory.class.getName());
        try {
            Class<?> servletObjectsFactoryClass = Class.forName(servletObjectsFactoryName);
            this.servletObjectsFactory = (ServletObjectsFactory)servletObjectsFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new PortletException("Unable to instantiate factory" + servletObjectsFactoryName, (Throwable)e);
        }
    }

    public void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String phpUri = renderRequest.getParameter(_PHP_URI_PARAM);
        if (phpUri != null) {
            this.processPHP(phpUri, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.processPHP(this.editUri, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) {
        this.processPHP(this.helpUri, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) {
        this.processPHP(this.viewUri, renderRequest, renderResponse);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        String phpURI = actionRequest.getParameter(_PHP_URI_PARAM);
        if (phpURI != null) {
            actionResponse.setRenderParameter(_PHP_URI_PARAM, phpURI);
        }
    }

    public void destroy() {
        if (this.quercusServlet != null) {
            this.quercusServlet.destroy();
        }
    }

    protected synchronized void initQuercus(ServletConfig servletConfig) throws PortletException {
        if (this.quercusServlet == null) {
            try {
                this.quercusServlet = (HttpServlet)Class.forName(_QUERCUS_SERVLET).newInstance();
                HashMap<String, String> params = new HashMap<String, String>();
                Enumeration enu = servletConfig.getInitParameterNames();
                while (enu.hasMoreElements()) {
                    String name = (String)enu.nextElement();
                    if (name.equals("portlet-class")) continue;
                    params.put(name, servletConfig.getInitParameter(name));
                }
                servletConfig = new DynamicServletConfig(servletConfig, params);
                this.quercusServlet.init(servletConfig);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    protected void processPHP(String phpURI, RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            ServletConfig servletConfig = this.servletObjectsFactory.getServletConfig(this.getPortletConfig(), (PortletRequest)renderRequest);
            this.initQuercus(servletConfig);
            HttpServletRequest request = this.servletObjectsFactory.getServletRequest((PortletRequest)renderRequest);
            HttpServletResponse response = this.servletObjectsFactory.getServletResponse((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            PHPServletRequest phpRequest = new PHPServletRequest(request, servletConfig, renderRequest, renderResponse, this.getPortletConfig(), phpURI, this.addPortletParams);
            StringServletResponse stringResponse = new StringServletResponse(response);
            this.quercusServlet.service((ServletRequest)phpRequest, (ServletResponse)stringResponse);
            String result = stringResponse.getString();
            if (stringResponse.getContentType().startsWith("text/")) {
                result = this.rewriteURLs(result, renderResponse.createRenderURL());
            }
            renderResponse.setContentType(stringResponse.getContentType());
            PrintWriter writer = renderResponse.getWriter();
            writer.write(result.toCharArray());
        }
        catch (Exception e) {
            _log.error((Object)"Error processing PHP", (Throwable)e);
        }
    }

    protected String rewriteURLs(String page, PortletURL portletURL) {
        ScriptPostProcess scriptPostProcess = new ScriptPostProcess();
        scriptPostProcess.setInitalPage(new StringBundler(page));
        scriptPostProcess.postProcessPage(portletURL, _PHP_URI_PARAM);
        return scriptPostProcess.getFinalizedPage();
    }
}

