/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAlloyIndexer
extends BaseIndexer {
    protected String[] classNames;
    protected MethodKey getModelMethodKey;
    protected MethodKey getModelsCountMethodKey;
    protected MethodKey getModelsMethodKey;
    protected String portletId;

    public BaseAlloyIndexer(String portletId, String className) {
        this.portletId = portletId;
        this.classNames = new String[]{className};
        this.getModelMethodKey = new MethodKey("XxxLocalServiceUtil", "getXxx", new Class[]{Long.TYPE});
        this.getModelsCountMethodKey = new MethodKey("XxxLocalServiceUtil", "getXxxsCount", new Class[0]);
        this.getModelsMethodKey = new MethodKey("XxxLocalServiceUtil", "getXxxs", new Class[]{Integer.TYPE, Integer.TYPE});
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        BaseModel baseModel = (BaseModel)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.portletId, String.valueOf(baseModel.getPrimaryKeyObj()));
        AuditedModel auditedModel = (AuditedModel)obj;
        SearchEngineUtil.deleteDocument((long)auditedModel.getCompanyId(), (String)document.get("uid"));
    }

    protected void doReindex(Object obj) throws Exception {
        Document document = this.getDocument(obj);
        AuditedModel auditedModel = (AuditedModel)obj;
        SearchEngineUtil.updateDocument((long)auditedModel.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MethodHandler methodHandler = new MethodHandler(this.getModelMethodKey, new Object[]{classPK});
        Object model = methodHandler.invoke(false);
        this.doReindex(model);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexModels(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return this.portletId;
    }

    protected void reindexModels(long companyId) throws Exception {
        MethodHandler methodHandler = new MethodHandler(this.getModelsCountMethodKey, new Object[0]);
        int count = (Integer)methodHandler.invoke(false);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexModels(companyId, start, end);
            ++i;
        }
    }

    protected void reindexModels(long companyId, int start, int end) throws Exception {
        MethodHandler methodHandler = new MethodHandler(this.getModelsMethodKey, new Object[]{start, end});
        List models = (List)methodHandler.invoke(false);
        if (models.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Object model : models) {
            Document document = this.getDocument(model);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

