/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.alloy.AlloyController;
import com.liferay.util.bridges.alloy.AlloyPortlet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAlloyControllerImpl
implements AlloyController {
    protected static final String CALLED_PROCESS_ACTION = "CALLED_PROCESS_ACTION";
    protected static final String VIEW_PATH = "VIEW_PATH";
    protected static Log log = LogFactoryUtil.getLog(BaseAlloyControllerImpl.class);
    protected String actionPath;
    protected ActionRequest actionRequest;
    protected ActionResponse actionResponse;
    protected AlloyPortlet alloyPortlet;
    protected ClassLoader classLoader;
    protected Class<?> classObject;
    protected String controllerPath;
    protected EventRequest eventRequest;
    protected EventResponse eventResponse;
    protected String lifecycle;
    protected LiferayPortletConfig liferayPortletConfig;
    protected LiferayPortletResponse liferayPortletResponse;
    protected Map<String, Method> methodsMap;
    protected PageContext pageContext;
    protected Portlet portlet;
    protected PortletContext portletContext;
    protected PortletRequest portletRequest;
    protected PortletResponse portletResponse;
    protected String redirect;
    protected RenderRequest renderRequest;
    protected RenderResponse renderResponse;
    protected HttpServletRequest request;
    protected ResourceRequest resourceRequest;
    protected ResourceResponse resourceResponse;
    protected HttpServletResponse response;
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected String viewPath;

    @Override
    public void afterPropertiesSet() {
        this.initClass();
        this.initServletVariables();
        this.initPortletVariables();
        this.initMethods();
        this.initPaths();
    }

    @Override
    public void execute() throws Exception {
        Method method = this.getMethod(this.actionPath, new Class[0]);
        if (method == null && log.isDebugEnabled()) {
            log.debug((Object)("No method found for action " + this.actionPath));
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.executeAction(method);
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.executeRender(method);
        }
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    protected void addSuccessMessage() {
        String successMessage = ParamUtil.getString((PortletRequest)this.portletRequest, (String)"successMessage");
        SessionMessages.add((PortletRequest)this.portletRequest, (String)"request_processed", (Object)successMessage);
    }

    protected String buildIncludePath(String viewPath) {
        StringBundler sb = new StringBundler(5);
        sb.append("/WEB-INF/jsp/views/");
        sb.append(this.controllerPath);
        sb.append("/");
        sb.append(viewPath);
        sb.append(".jsp");
        return sb.toString();
    }

    protected void executeAction(Method method) throws Exception {
        if (method != null) {
            method.invoke((Object)this, new Object[0]);
        }
        this.actionRequest.setAttribute(CALLED_PROCESS_ACTION, (Object)Boolean.TRUE.toString());
        if (Validator.isNotNull((String)this.viewPath)) {
            this.actionRequest.setAttribute(VIEW_PATH, (Object)this.viewPath);
            PortalUtil.copyRequestParameters((ActionRequest)this.actionRequest, (ActionResponse)this.actionResponse);
        } else if (Validator.isNotNull((String)this.redirect)) {
            this.actionResponse.sendRedirect(this.redirect);
        }
    }

    protected void executeRender(Method method) throws Exception {
        String includePath;
        PortletRequestDispatcher portletRequestDispatcher;
        boolean calledProcessAction = GetterUtil.getBoolean((String)((String)this.request.getAttribute(CALLED_PROCESS_ACTION)));
        if (!calledProcessAction && method != null) {
            method.invoke((Object)this, new Object[0]);
        }
        if (Validator.isNull((String)this.viewPath)) {
            this.viewPath = this.actionPath;
        }
        if ((portletRequestDispatcher = this.portletContext.getRequestDispatcher(includePath = this.buildIncludePath(this.viewPath))) == null) {
            log.error((Object)(includePath + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(this.portletRequest, this.portletResponse);
        }
    }

    protected Method getMethod(String methodName, Class<?> ... parameterTypes) {
        String methodKey = this.getMethodKey(methodName, parameterTypes);
        return this.methodsMap.get(methodKey);
    }

    protected String getMethodKey(String methodName, Class<?> ... parameterTypes) {
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 2);
        sb.append(methodName);
        sb.append("#");
        for (Class<?> parameterType : parameterTypes) {
            sb.append(parameterType.getName());
            sb.append("#");
        }
        return sb.toString();
    }

    protected void initClass() {
        this.classObject = this.getClass();
        this.classLoader = this.classObject.getClassLoader();
    }

    protected void initMethods() {
        Method[] methods;
        this.methodsMap = new HashMap<String, Method>();
        for (Method method : methods = this.classObject.getMethods()) {
            String methodKey = this.getMethodKey(method.getName(), method.getParameterTypes());
            this.methodsMap.put(methodKey, method);
        }
    }

    protected void initPaths() {
        Map<String, String> defaultRouteParameters;
        this.controllerPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"controller");
        if (Validator.isNull((String)this.controllerPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.controllerPath = defaultRouteParameters.get("controller");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Controller path " + this.controllerPath));
        }
        this.actionPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"action");
        if (Validator.isNull((String)this.actionPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.actionPath = defaultRouteParameters.get("action");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action path " + this.actionPath));
        }
        this.viewPath = GetterUtil.getString((String)((String)this.request.getAttribute(VIEW_PATH)));
        this.request.removeAttribute(VIEW_PATH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("View path " + this.viewPath));
        }
    }

    protected void initPortletVariables() {
        this.liferayPortletConfig = (LiferayPortletConfig)this.request.getAttribute("javax.portlet.config");
        this.portletContext = this.liferayPortletConfig.getPortletContext();
        this.portlet = this.liferayPortletConfig.getPortlet();
        this.alloyPortlet = (AlloyPortlet)((Object)this.request.getAttribute("javax.portlet.portlet"));
        this.portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        this.portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        this.liferayPortletResponse = (LiferayPortletResponse)this.portletResponse;
        this.lifecycle = GetterUtil.getString((String)((String)this.request.getAttribute("javax.portlet.lifecycle_phase")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lifecycle " + this.lifecycle));
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.actionRequest = (ActionRequest)this.portletRequest;
            this.actionResponse = (ActionResponse)this.portletResponse;
        } else if (this.lifecycle.equals("EVENT_PHASE")) {
            this.eventRequest = (EventRequest)this.portletRequest;
            this.eventResponse = (EventResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.renderRequest = (RenderRequest)this.portletRequest;
            this.renderResponse = (RenderResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RESOURCE_PHASE")) {
            this.resourceRequest = (ResourceRequest)this.portletRequest;
            this.resourceResponse = (ResourceResponse)this.portletResponse;
        }
    }

    protected void initServletVariables() {
        this.servletConfig = this.pageContext.getServletConfig();
        this.servletContext = this.pageContext.getServletContext();
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        this.response = (HttpServletResponse)this.pageContext.getResponse();
    }

    protected void redirectTo(PortletURL portletURL) {
        this.redirectTo(portletURL.toString());
    }

    protected void redirectTo(String redirect) {
        if (!this.lifecycle.equals("ACTION_PHASE")) {
            throw new IllegalArgumentException("redirectTo can only be called during the action phase");
        }
        if (Validator.isNotNull((String)this.viewPath)) {
            throw new IllegalArgumentException("redirectTo cannot be called if render has been called");
        }
        this.redirect = redirect;
    }

    protected void render(String actionPath) {
        if (Validator.isNotNull((String)this.redirect)) {
            throw new IllegalArgumentException("render cannot be called if redirectTo has been called");
        }
        this.viewPath = actionPath;
    }
}

