/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.util.PortalUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlloyFriendlyURLMapper
extends DefaultFriendlyURLMapper {
    private static Log _log = LogFactoryUtil.getLog(AlloyFriendlyURLMapper.class);

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        String lifecycle = liferayPortletURL.getLifecycle();
        if (lifecycle.equals("ACTION_PHASE")) {
            routeParameters.put("method", "POST");
        } else {
            routeParameters.put("method", "GET");
        }
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (friendlyURLPath == null) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        int pos = friendlyURLPath.indexOf("/");
        friendlyURLPath = friendlyURLPath.substring(pos);
        friendlyURLPath = "/".concat(this.getMapping()).concat(friendlyURLPath);
        return friendlyURLPath;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        HashMap routeParameters;
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        String method = request.getMethod();
        friendlyURLPath = method + friendlyURLPath.substring(this.getMapping().length() + 1);
        if (friendlyURLPath.endsWith("/")) {
            friendlyURLPath = friendlyURLPath.substring(0, friendlyURLPath.length() - 1);
        }
        if (!this.router.urlToParameters(friendlyURLPath, routeParameters = new HashMap())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No route could be found to match URL " + friendlyURLPath));
            }
            return;
        }
        String portletId = this.getPortletId(routeParameters);
        if (portletId == null) {
            return;
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        this.addParameter(namespace, parameterMap, "p_p_id", portletId);
        this.addParameter(parameterMap, "p_p_lifecycle", this.getLifecycle(method));
        this.populateParams(parameterMap, namespace, routeParameters);
    }

    protected String getLifecycle(String method) {
        if (method.equalsIgnoreCase("POST")) {
            return "1";
        }
        return "0";
    }
}

