/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.journal.model.JournalArticle;

public class ArticleTitleComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "title ASC";
    public static final String ORDER_BY_DESC = "title DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"title"};
    private boolean _ascending;

    public ArticleTitleComparator() {
        this(false);
    }

    public ArticleTitleComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        JournalArticle article1 = (JournalArticle)obj1;
        JournalArticle article2 = (JournalArticle)obj2;
        String title1 = StringUtil.toLowerCase(article1.getTitle());
        String title2 = StringUtil.toLowerCase(article2.getTitle());
        int value = title1.compareTo(title2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

