/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import java.io.InputStream;

public class PDFProcessorUtil {
    public static void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor != null) {
            pdfProcessor.generateImages(sourceFileVersion, destinationFileVersion);
        }
    }

    public static PDFProcessor getPDFProcessor() {
        return (PDFProcessor)((Object)DLProcessorRegistryUtil.getDLProcessor("PDFProcessor"));
    }

    public static InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return null;
        }
        return pdfProcessor.getPreviewAsStream(fileVersion, index);
    }

    public static int getPreviewFileCount(FileVersion fileVersion) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return 0;
        }
        return pdfProcessor.getPreviewFileCount(fileVersion);
    }

    public static long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return 0L;
        }
        return pdfProcessor.getPreviewFileSize(fileVersion, index);
    }

    public static InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return null;
        }
        return pdfProcessor.getThumbnailAsStream(fileVersion, index);
    }

    public static long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return 0L;
        }
        return pdfProcessor.getThumbnailFileSize(fileVersion, index);
    }

    public static boolean hasImages(FileVersion fileVersion) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return false;
        }
        return pdfProcessor.hasImages(fileVersion);
    }

    public static boolean isDocumentSupported(FileVersion fileVersion) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return false;
        }
        return pdfProcessor.isDocumentSupported(fileVersion);
    }

    public static boolean isDocumentSupported(String mimeType) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return false;
        }
        return pdfProcessor.isDocumentSupported(mimeType);
    }

    public static boolean isSupported(String mimeType) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor == null) {
            return false;
        }
        return pdfProcessor.isSupported(mimeType);
    }

    public static void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        PDFProcessor pdfProcessor = PDFProcessorUtil.getPDFProcessor();
        if (pdfProcessor != null) {
            pdfProcessor.trigger(sourceFileVersion, destinationFileVersion);
        }
    }

    public void setPDFProcessor(PDFProcessor pdfProcessor) {
    }
}

