/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.Store;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseStore
implements Store {
    private static Log _log = LogFactoryUtil.getLog(BaseStore.class);

    @Override
    public abstract void addDirectory(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException, SystemException {
        File file = null;
        try {
            try {
                file = FileUtil.createTempFile(bytes);
                this.addFile(companyId, repositoryId, fileName, file);
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to write temporary file", ioe);
            }
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException, SystemException {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                this.addFile(companyId, repositoryId, fileName, is);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    @Override
    public abstract void addFile(long var1, long var3, String var5, InputStream var6) throws PortalException, SystemException;

    @Override
    public abstract void checkRoot(long var1) throws SystemException;

    @Override
    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException, SystemException {
        InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this.updateFile(companyId, repositoryId, fileName, toVersionLabel, is);
    }

    @Override
    public abstract void deleteDirectory(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public abstract void deleteFile(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public abstract void deleteFile(long var1, long var3, String var5, String var6) throws PortalException, SystemException;

    @Override
    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.getFile(companyId, repositoryId, fileName, "");
    }

    @Override
    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    @Override
    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        byte[] bytes = null;
        try {
            InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    @Override
    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.getFileAsStream(companyId, repositoryId, fileName, "");
    }

    @Override
    public abstract InputStream getFileAsStream(long var1, long var3, String var5, String var6) throws PortalException, SystemException;

    @Override
    public abstract String[] getFileNames(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public abstract long getFileSize(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public abstract boolean hasDirectory(long var1, long var3, String var5) throws PortalException, SystemException;

    @Override
    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hasFile(companyId, repositoryId, fileName, "1.0");
    }

    @Override
    public abstract boolean hasFile(long var1, long var3, String var5, String var6) throws PortalException, SystemException;

    @Override
    public abstract void move(String var1, String var2) throws SystemException;

    @Override
    public abstract void updateFile(long var1, long var3, long var5, String var7) throws PortalException, SystemException;

    @Override
    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, byte[] bytes) throws PortalException, SystemException {
        File file = null;
        try {
            try {
                file = FileUtil.createTempFile(bytes);
                this.updateFile(companyId, repositoryId, fileName, versionLabel, file);
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to write temporary file", ioe);
            }
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException, SystemException {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                this.updateFile(companyId, repositoryId, fileName, versionLabel, is);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                _log.error(ioe);
            }
        }
    }

    @Override
    public abstract void updateFile(long var1, long var3, String var5, String var6, InputStream var7) throws PortalException, SystemException;

    @Override
    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException, SystemException {
        InputStream is = this.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel);
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
        }
        this.updateFile(companyId, repositoryId, fileName, toVersionLabel, is);
        this.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }
}

