/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;

public class AssetEntryQuery {
    public static final String[] ORDER_BY_COLUMNS = new String[]{"title", "createDate", "modifiedDate", "publishDate", "expirationDate", "priority", "viewCount", "ratings"};
    private static Log _log = LogFactoryUtil.getLog(AssetEntryQuery.class);
    private long[] _allCategoryIds = new long[0];
    private long[] _allTagIds = new long[0];
    private long[][] _allTagIdsArray = new long[0][];
    private long[] _anyCategoryIds = new long[0];
    private long[] _anyTagIds = new long[0];
    private Map<String, Serializable> _attributes = new HashMap<String, Serializable>();
    private long[] _classNameIds = new long[0];
    private long[] _classTypeIds = new long[0];
    private String _description;
    private boolean _enablePermissions;
    private int _end = -1;
    private boolean _excludeZeroViewCount;
    private Date _expirationDate;
    private long[] _groupIds = new long[0];
    private String _keywords;
    private Layout _layout;
    private long _linkedAssetEntryId = 0L;
    private long[] _notAllCategoryIds = new long[0];
    private long[] _notAllTagIds = new long[0];
    private long[][] _notAllTagIdsArray = new long[0][];
    private long[] _notAnyCategoryIds = new long[0];
    private long[] _notAnyTagIds = new long[0];
    private String _orderByCol1;
    private String _orderByCol2;
    private String _orderByType1;
    private String _orderByType2;
    private String _paginationType;
    private Date _publishDate;
    private int _start = -1;
    private String _title;
    private String _toString;
    private Boolean _visible = Boolean.TRUE;

    public static String checkOrderByCol(String orderByCol) {
        if (ArrayUtil.contains(ORDER_BY_COLUMNS, orderByCol) || orderByCol != null && orderByCol.startsWith("ddm/")) {
            return orderByCol;
        }
        return ORDER_BY_COLUMNS[2];
    }

    public static String checkOrderByType(String orderByType) {
        if (orderByType == null || StringUtil.equalsIgnoreCase(orderByType, "DESC")) {
            return "DESC";
        }
        return "ASC";
    }

    public AssetEntryQuery() {
        Date now;
        this._expirationDate = now = new Date();
        this._publishDate = now;
    }

    public AssetEntryQuery(AssetEntryQuery assetEntryQuery) {
        this.setAllCategoryIds(assetEntryQuery.getAllCategoryIds());
        this.setAllTagIdsArray(assetEntryQuery.getAllTagIdsArray());
        this.setAnyCategoryIds(assetEntryQuery.getAnyCategoryIds());
        this.setAnyTagIds(assetEntryQuery.getAnyTagIds());
        this.setAttributes(assetEntryQuery.getAttributes());
        this.setClassNameIds(assetEntryQuery.getClassNameIds());
        this.setClassTypeIds(assetEntryQuery.getClassTypeIds());
        this.setDescription(assetEntryQuery.getDescription());
        this.setEnablePermissions(assetEntryQuery.isEnablePermissions());
        this.setEnd(assetEntryQuery.getEnd());
        this.setExcludeZeroViewCount(assetEntryQuery.isExcludeZeroViewCount());
        this.setExpirationDate(assetEntryQuery.getExpirationDate());
        this.setGroupIds(assetEntryQuery.getGroupIds());
        this.setKeywords(assetEntryQuery.getKeywords());
        this.setLayout(assetEntryQuery.getLayout());
        this.setLinkedAssetEntryId(assetEntryQuery.getLinkedAssetEntryId());
        this.setNotAllCategoryIds(assetEntryQuery.getNotAllCategoryIds());
        this.setNotAllTagIdsArray(assetEntryQuery.getNotAllTagIdsArray());
        this.setNotAnyCategoryIds(assetEntryQuery.getNotAnyCategoryIds());
        this.setNotAnyTagIds(assetEntryQuery.getNotAnyTagIds());
        this.setOrderByCol1(assetEntryQuery.getOrderByCol1());
        this.setOrderByCol2(assetEntryQuery.getOrderByCol2());
        this.setOrderByType1(assetEntryQuery.getOrderByType1());
        this.setOrderByType2(assetEntryQuery.getOrderByType2());
        this.setPaginationType(assetEntryQuery.getPaginationType());
        this.setPublishDate(assetEntryQuery.getPublishDate());
        this.setStart(assetEntryQuery.getStart());
        this.setTitle(assetEntryQuery.getTitle());
        this.setVisible(assetEntryQuery.isVisible());
    }

    public AssetEntryQuery(long[] classNameIds, SearchContainer<?> searchContainer) throws PortalException, SystemException {
        this();
        String tagName;
        this.setClassNameIds(classNameIds);
        this._start = searchContainer.getStart();
        this._end = searchContainer.getEnd();
        if (Validator.isNotNull(searchContainer.getOrderByCol())) {
            this.setOrderByCol1(searchContainer.getOrderByCol());
            this.setOrderByType1(searchContainer.getOrderByType());
        }
        PortletRequest portletRequest = searchContainer.getPortletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._groupIds = new long[]{themeDisplay.getScopeGroupId()};
        long categoryId = ParamUtil.getLong(portletRequest, "categoryId");
        if (categoryId > 0L) {
            this._allCategoryIds = new long[]{categoryId};
        }
        if (Validator.isNotNull(tagName = ParamUtil.getString(portletRequest, "tag"))) {
            this._allTagIds = AssetTagLocalServiceUtil.getTagIds(themeDisplay.getSiteGroupId(), new String[]{tagName});
            this._allTagIdsArray = new long[][]{this._allTagIds};
        }
    }

    public AssetEntryQuery(String className, SearchContainer<?> searchContainer) throws PortalException, SystemException {
        this(new long[]{PortalUtil.getClassNameId(className)}, searchContainer);
    }

    public void addAllTagIdsArray(long[] allTagsIds) {
        if (allTagsIds.length == 0) {
            return;
        }
        this._allTagIdsArray = ArrayUtil.append(this._allTagIdsArray, allTagsIds);
        this._allTagIds = this._flattenTagIds(this._allTagIdsArray);
    }

    public void addNotAllTagIdsArray(long[] notAllTagsIds) {
        if (notAllTagsIds.length == 0) {
            return;
        }
        this._notAllTagIdsArray = ArrayUtil.append(this._notAllTagIdsArray, notAllTagsIds);
        this._notAllTagIds = this._flattenTagIds(this._notAllTagIdsArray);
    }

    public long[] getAllCategoryIds() {
        return this._allCategoryIds;
    }

    public long[] getAllLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._allCategoryIds);
    }

    public long[] getAllTagIds() {
        return this._allTagIds;
    }

    public long[][] getAllTagIdsArray() {
        return this._allTagIdsArray;
    }

    public long[] getAnyCategoryIds() {
        return this._anyCategoryIds;
    }

    public long[] getAnyLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._anyCategoryIds);
    }

    public long[] getAnyTagIds() {
        return this._anyTagIds;
    }

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public long[] getClassNameIds() {
        return this._classNameIds;
    }

    public long[] getClassTypeIds() {
        return this._classTypeIds;
    }

    public String getDescription() {
        return this._description;
    }

    public int getEnd() {
        return this._end;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public long[] getGroupIds() {
        return this._groupIds;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public long getLinkedAssetEntryId() {
        return this._linkedAssetEntryId;
    }

    public long[] getNotAllCategoryIds() {
        return this._notAllCategoryIds;
    }

    public long[] getNotAllLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._notAllCategoryIds);
    }

    public long[] getNotAllTagIds() {
        return this._notAllTagIds;
    }

    public long[][] getNotAllTagIdsArray() {
        return this._notAllTagIdsArray;
    }

    public long[] getNotAnyCategoryIds() {
        return this._notAnyCategoryIds;
    }

    public long[] getNotAnyLeftAndRightCategoryIds() {
        return this._getLeftAndRightCategoryIds(this._notAnyCategoryIds);
    }

    public long[] getNotAnyTagIds() {
        return this._notAnyTagIds;
    }

    public String getOrderByCol1() {
        return AssetEntryQuery.checkOrderByCol(this._orderByCol1);
    }

    public String getOrderByCol2() {
        return AssetEntryQuery.checkOrderByCol(this._orderByCol2);
    }

    public String getOrderByType1() {
        return AssetEntryQuery.checkOrderByType(this._orderByType1);
    }

    public String getOrderByType2() {
        return AssetEntryQuery.checkOrderByType(this._orderByType2);
    }

    public String getPaginationType() {
        return this._paginationType;
    }

    public Date getPublishDate() {
        return this._publishDate;
    }

    public int getStart() {
        return this._start;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isEnablePermissions() {
        return this._enablePermissions;
    }

    public boolean isExcludeZeroViewCount() {
        return this._excludeZeroViewCount;
    }

    public Boolean isVisible() {
        return this._visible;
    }

    public void setAllCategoryIds(long[] allCategoryIds) {
        this._allCategoryIds = allCategoryIds;
        this._toString = null;
    }

    public void setAllTagIds(long[] allTagIds) {
        this._allTagIds = allTagIds;
        this._allTagIdsArray = this._expandTagIds(allTagIds);
        this._toString = null;
    }

    public void setAllTagIdsArray(long[][] allTagIdsArray) {
        this._allTagIdsArray = allTagIdsArray;
        this._allTagIds = this._flattenTagIds(allTagIdsArray);
        this._toString = null;
    }

    public void setAnyCategoryIds(long[] anyCategoryIds) {
        this._anyCategoryIds = anyCategoryIds;
        this._toString = null;
    }

    public void setAnyTagIds(long[] anyTagIds) {
        this._anyTagIds = anyTagIds;
        this._toString = null;
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this._attributes = this._attributes == null ? new HashMap<String, Serializable>() : attributes;
    }

    public void setClassName(String className) {
        long classNameId = PortalUtil.getClassNameId(className);
        this._classNameIds = new long[]{classNameId};
        this._toString = null;
    }

    public void setClassNameIds(long[] classNameIds) {
        this._classNameIds = classNameIds;
        this._toString = null;
    }

    public void setClassTypeIds(long[] classTypeIds) {
        this._classTypeIds = classTypeIds;
        this._toString = null;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setEnablePermissions(boolean enablePermissions) {
        this._enablePermissions = enablePermissions;
    }

    public void setEnd(int end) {
        this._end = end;
        this._toString = null;
    }

    public void setExcludeZeroViewCount(boolean excludeZeroViewCount) {
        this._excludeZeroViewCount = excludeZeroViewCount;
        this._toString = null;
    }

    public void setExpirationDate(Date expirationDate) {
        this._expirationDate = expirationDate;
        this._toString = null;
    }

    public void setGroupIds(long[] groupIds) {
        this._groupIds = groupIds;
        this._toString = null;
    }

    public void setKeywords(String keywords) {
        this._keywords = keywords;
    }

    public void setLayout(Layout layout) {
        this._layout = layout;
        this._toString = null;
    }

    public void setLinkedAssetEntryId(long linkedAssetEntryId) {
        this._linkedAssetEntryId = linkedAssetEntryId;
        this._toString = null;
    }

    public void setNotAllCategoryIds(long[] notAllCategoryIds) {
        this._notAllCategoryIds = notAllCategoryIds;
        this._toString = null;
    }

    public void setNotAllTagIds(long[] notAllTagIds) {
        this._notAllTagIds = notAllTagIds;
        this._notAllTagIdsArray = this._expandTagIds(notAllTagIds);
        this._toString = null;
    }

    public void setNotAllTagIdsArray(long[][] notAllTagIdsArray) {
        this._notAllTagIdsArray = notAllTagIdsArray;
        this._notAllTagIds = this._flattenTagIds(notAllTagIdsArray);
        this._toString = null;
    }

    public void setNotAnyCategoryIds(long[] notAnyCategoryIds) {
        this._notAnyCategoryIds = notAnyCategoryIds;
        this._toString = null;
    }

    public void setNotAnyTagIds(long[] notAnyTagIds) {
        this._notAnyTagIds = notAnyTagIds;
        this._toString = null;
    }

    public void setOrderByCol1(String orderByCol1) {
        this._orderByCol1 = orderByCol1;
        this._toString = null;
    }

    public void setOrderByCol2(String orderByCol2) {
        this._orderByCol2 = orderByCol2;
        this._toString = null;
    }

    public void setOrderByType1(String orderByType1) {
        this._orderByType1 = orderByType1;
        this._toString = null;
    }

    public void setOrderByType2(String orderByType2) {
        this._orderByType2 = orderByType2;
        this._toString = null;
    }

    public void setPaginationType(String paginationType) {
        this._paginationType = paginationType;
        this._toString = null;
    }

    public void setPublishDate(Date publishDate) {
        this._publishDate = publishDate;
        this._toString = null;
    }

    public void setStart(int start) {
        this._start = start;
        this._toString = null;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setVisible(Boolean visible) {
        this._visible = visible;
        this._toString = null;
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        StringBundler sb = new StringBundler(55);
        sb.append("{allCategoryIds=");
        sb.append(StringUtil.merge(this._allCategoryIds));
        sb.append(", allTagIds=");
        sb.append(StringUtil.merge(this._allTagIds));
        sb.append(", anyCategoryIds=");
        sb.append(StringUtil.merge(this._anyCategoryIds));
        sb.append(", anyTagIds=");
        sb.append(StringUtil.merge(this._anyTagIds));
        sb.append(", classNameIds=");
        sb.append(StringUtil.merge(this._classNameIds));
        sb.append(", classTypeIds=");
        sb.append(StringUtil.merge(this._classTypeIds));
        sb.append(this._description);
        sb.append(", description=");
        if (this._layout != null) {
            sb.append(", layout=");
            sb.append(this._layout.getPlid());
        }
        sb.append(", end=");
        sb.append(this._end);
        sb.append(", excludeZeroViewCount=");
        sb.append(this._excludeZeroViewCount);
        sb.append(", expirationDate=");
        sb.append(this._expirationDate);
        sb.append(", groupIds=");
        sb.append(this._keywords);
        sb.append(", keywords=");
        sb.append(StringUtil.merge(this._groupIds));
        sb.append(", linkedAssetEntryId=");
        sb.append(this._linkedAssetEntryId);
        sb.append(", notAllCategoryIds=");
        sb.append(StringUtil.merge(this._notAllCategoryIds));
        sb.append(", notAllTagIds=");
        sb.append(StringUtil.merge(this._notAllTagIds));
        sb.append(", notAnyCategoryIds=");
        sb.append(StringUtil.merge(this._notAnyCategoryIds));
        sb.append(", notAnyTagIds=");
        sb.append(StringUtil.merge(this._notAnyTagIds));
        sb.append(", orderByCol1=");
        sb.append(this._orderByCol1);
        sb.append(", orderByCol2=");
        sb.append(this._orderByCol2);
        sb.append(", orderByType1=");
        sb.append(this._orderByType1);
        sb.append(", orderByType2=");
        sb.append(this._orderByType2);
        sb.append(", paginationType=");
        sb.append(this._paginationType);
        sb.append(", publishDate=");
        sb.append(this._publishDate);
        sb.append(", start=");
        sb.append(this._start);
        sb.append(this._title);
        sb.append(", title=");
        sb.append(", visible=");
        sb.append(this._visible);
        sb.append("}");
        this._toString = sb.toString();
        return this._toString;
    }

    private long[][] _expandTagIds(long[] tagIds) {
        long[][] tagIdsArray = new long[tagIds.length][1];
        int i = 0;
        while (i < tagIds.length) {
            tagIdsArray[i][0] = tagIds[i];
            ++i;
        }
        return tagIdsArray;
    }

    private long[] _flattenTagIds(long[][] tagIdsArray) {
        ArrayList<Long> tagIdsList = new ArrayList<Long>();
        int i = 0;
        while (i < tagIdsArray.length) {
            long[] tagIds = tagIdsArray[i];
            int j = 0;
            while (j < tagIds.length) {
                long tagId = tagIds[j];
                tagIdsList.add(tagId);
                ++j;
            }
            ++i;
        }
        return ArrayUtil.toArray(tagIdsList.toArray(new Long[tagIdsList.size()]));
    }

    private long[] _getLeftAndRightCategoryIds(long[] categoryIds) {
        long[] leftRightIds = new long[categoryIds.length * 3];
        int i = 0;
        while (i < categoryIds.length) {
            long categoryId = categoryIds[i];
            try {
                AssetCategory category = AssetCategoryLocalServiceUtil.getCategory(categoryId);
                leftRightIds[3 * i] = category.getGroupId();
                leftRightIds[3 * i + 1] = category.getLeftCategoryId();
                leftRightIds[3 * i + 2] = category.getRightCategoryId();
            }
            catch (Exception exception) {
                _log.warn("Error retrieving category " + categoryId);
            }
            ++i;
        }
        return leftRightIds;
    }
}

