/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.User;

public class UserLastNameComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "lastName ASC, firstName ASC, middleName ASC";
    public static final String ORDER_BY_DESC = "lastName DESC, firstName DESC, middleName DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"lastName", "firstName", "middleName"};
    private boolean _ascending;

    public UserLastNameComparator() {
        this(false);
    }

    public UserLastNameComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        String lastName2;
        User user1 = (User)obj1;
        User user2 = (User)obj2;
        String lastName1 = user1.getLastName();
        int value = lastName1.compareTo(lastName2 = user2.getLastName());
        if (value == 0) {
            String firstName1 = user1.getFirstName();
            String firstName2 = user2.getFirstName();
            value = firstName1.compareTo(firstName2);
        }
        if (value == 0) {
            String middleName1 = user1.getMiddleName();
            String middleName2 = user2.getMiddleName();
            value = middleName1.compareTo(middleName2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

