/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.BaseLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.LayoutPersistence;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseLocalServiceImpl
implements BaseLocalService {
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    protected String getLayoutURL(Layout layout, ServiceContext serviceContext) {
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            return PortalUtil.getLayoutURL(layout, themeDisplay);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String getLayoutURL(long groupId, String portletId, ServiceContext serviceContext) throws PortalException, SystemException {
        long controlPanelPlid;
        String layoutURL = "";
        long plid = serviceContext.getPlid();
        if (plid == (controlPanelPlid = PortalUtil.getControlPanelPlid(serviceContext.getCompanyId())) && (plid = PortalUtil.getPlidFromPortletId(groupId, portletId)) != 0L) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
            layoutURL = this.getLayoutURL(layout, serviceContext);
        }
        return layoutURL;
    }
}

