/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicy;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.persistence.OrganizationActionableDynamicQuery;
import com.liferay.portal.service.persistence.UserGroupRoleActionableDynamicQuery;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseOrganizationMembershipPolicy
implements OrganizationMembershipPolicy {
    @Override
    public void checkRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException, SystemException {
    }

    @Override
    public boolean isMembershipAllowed(long userId, long organizationId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{organizationId}, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipProtected(PermissionChecker permissionChecker, long userId, long organizationId) throws PortalException, SystemException {
        if (permissionChecker.isOrganizationOwner(organizationId)) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        Group group = organization.getGroup();
        Role organizationAdministratorRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Organization Administrator");
        if (UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), organizationAdministratorRole.getRoleId())) {
            return true;
        }
        Role organizationOwnerRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Organization Owner");
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), organizationOwnerRole.getRoleId());
    }

    @Override
    public boolean isMembershipRequired(long userId, long organizationId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{organizationId});
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isRoleAllowed(long userId, long organizationId, long roleId) throws PortalException, SystemException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, organization.getGroupId(), roleId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(userGroupRolePK);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(userGroupRoles, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoleProtected(PermissionChecker permissionChecker, long userId, long organizationId, long roleId) throws PortalException, SystemException {
        if (permissionChecker.isOrganizationOwner(organizationId)) {
            return false;
        }
        Role role = RoleLocalServiceUtil.getRole(roleId);
        String roleName = role.getName();
        if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        Group group = organization.getGroup();
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), role.getRoleId());
    }

    @Override
    public boolean isRoleRequired(long userId, long organizationId, long roleId) throws PortalException, SystemException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, organization.getGroupId(), roleId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(userGroupRolePK);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(null, userGroupRoles);
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public void propagateRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) {
    }

    @Override
    public void verifyPolicy() throws PortalException, SystemException {
        OrganizationActionableDynamicQuery organizationActionableDynamicQuery = new OrganizationActionableDynamicQuery(){

            @Override
            protected void performAction(Object object) throws PortalException, SystemException {
                Organization organization = (Organization)object;
                BaseOrganizationMembershipPolicy.this.verifyPolicy(organization);
                UserGroupRoleActionableDynamicQuery userGroupRoleActionableDynamicQuery = new UserGroupRoleActionableDynamicQuery(){

                    @Override
                    protected void performAction(Object object) throws PortalException, SystemException {
                        UserGroupRole userGroupRole = (UserGroupRole)object;
                        BaseOrganizationMembershipPolicy.this.verifyPolicy(userGroupRole.getRole());
                    }
                };
                userGroupRoleActionableDynamicQuery.setGroupId(organization.getGroupId());
                userGroupRoleActionableDynamicQuery.performActions();
            }
        };
        organizationActionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(Organization organization) throws PortalException, SystemException {
        this.verifyPolicy(organization, null, null, null, null);
    }

    @Override
    public void verifyPolicy(Role role) {
    }

    @Override
    public void verifyPolicy(Role role, Role oldRole, Map<String, Serializable> oldExpandoAttributes) {
    }
}

