/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;

public class URLCodec {
    private static Log _log = LogFactoryUtil.getLog(URLCodec.class);
    private static BitSet _validChars = new BitSet(256);

    static {
        int i = 97;
        while (i <= 122) {
            _validChars.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            _validChars.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            _validChars.set(i);
            ++i;
        }
        _validChars.set(45);
        _validChars.set(95);
        _validChars.set(46);
        _validChars.set(42);
    }

    public static String decodeURL(String encodedURLString) {
        return URLCodec.decodeURL(encodedURLString, "UTF-8", false);
    }

    public static String decodeURL(String encodedURLString, boolean unescapeSpaces) {
        return URLCodec.decodeURL(encodedURLString, "UTF-8", unescapeSpaces);
    }

    public static String decodeURL(String encodedURLString, String charsetName, boolean unescapeSpaces) {
        if (encodedURLString == null) {
            return null;
        }
        if (encodedURLString.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        CharsetDecoder charsetDecoder = null;
        int i = 0;
        while (i < encodedURLString.length()) {
            char c = encodedURLString.charAt(i);
            switch (c) {
                case '%': {
                    ByteBuffer byteBuffer = URLCodec._getEncodedByteBuffer(encodedURLString, i);
                    if (charsetDecoder == null) {
                        charsetDecoder = CharsetDecoderUtil.getCharsetDecoder(charsetName);
                    }
                    CharBuffer charBuffer = null;
                    try {
                        charBuffer = charsetDecoder.decode(byteBuffer);
                    }
                    catch (CharacterCodingException cce) {
                        _log.error(cce, cce);
                        return "";
                    }
                    if (sb == null) {
                        sb = new StringBuilder(encodedURLString.length());
                        if (i > 0) {
                            sb.append(encodedURLString, 0, i);
                        }
                    }
                    sb.append(charBuffer);
                    i += byteBuffer.capacity() * 3 - 1;
                    break;
                }
                case '+': {
                    if (sb == null) {
                        sb = new StringBuilder(encodedURLString.length());
                        if (i > 0) {
                            sb.append(encodedURLString, 0, i);
                        }
                    }
                    sb.append(' ');
                    break;
                }
                default: {
                    if (sb == null) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        if (sb == null) {
            return encodedURLString;
        }
        return sb.toString();
    }

    public static String encodeURL(String rawURLString) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", false);
    }

    public static String encodeURL(String rawURLString, boolean escapeSpaces) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", escapeSpaces);
    }

    public static String encodeURL(String rawURLString, String charsetName, boolean escapeSpaces) {
        if (rawURLString == null) {
            return null;
        }
        if (rawURLString.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        CharsetEncoder charsetEncoder = null;
        char[] hexes = new char[2];
        int i = 0;
        while (i < rawURLString.length()) {
            char c = rawURLString.charAt(i);
            if (_validChars.get(c)) {
                if (sb != null) {
                    sb.append(c);
                }
            } else {
                if (sb == null) {
                    sb = new StringBuilder(rawURLString.length());
                    sb.append(rawURLString.substring(0, i));
                }
                switch (c) {
                    case '/': {
                        sb.append("%2F");
                        break;
                    }
                    case '=': {
                        sb.append("%3D");
                        break;
                    }
                    case '&': {
                        sb.append("%26");
                        break;
                    }
                    case '%': {
                        sb.append("%25");
                        break;
                    }
                    case ' ': {
                        if (escapeSpaces) {
                            sb.append("%20");
                            break;
                        }
                        sb.append('+');
                        break;
                    }
                    case ':': {
                        sb.append("%3A");
                        break;
                    }
                    case '?': {
                        sb.append("%3F");
                        break;
                    }
                    default: {
                        CharBuffer charBuffer = URLCodec._getRawCharBuffer(rawURLString, i, escapeSpaces);
                        if (charsetEncoder == null) {
                            charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
                        }
                        i += charBuffer.length() - 1;
                        ByteBuffer byteBuffer = null;
                        try {
                            byteBuffer = charsetEncoder.encode(charBuffer);
                        }
                        catch (CharacterCodingException cce) {
                            _log.error(cce, cce);
                            return "";
                        }
                        int j = byteBuffer.position();
                        while (j < byteBuffer.limit()) {
                            sb.append('%');
                            sb.append(UnicodeFormatter.byteToHex(byteBuffer.get(), hexes, true));
                            ++j;
                        }
                        break block1;
                    }
                }
            }
            ++i;
        }
        if (sb == null) {
            return rawURLString;
        }
        return sb.toString();
    }

    private static int _charToHex(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException(String.valueOf(c) + " is not a hex char");
    }

    private static ByteBuffer _getEncodedByteBuffer(String encodedString, int start) {
        int count = 1;
        int i = start + 3;
        while (i < encodedString.length()) {
            if (encodedString.charAt(i) != '%') break;
            ++count;
            i += 3;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(count);
        int i2 = start;
        while (i2 < start + count * 3) {
            int high = URLCodec._charToHex(encodedString.charAt(i2 + 1));
            int low = URLCodec._charToHex(encodedString.charAt(i2 + 2));
            byteBuffer.put((byte)((high << 4) + low));
            i2 += 3;
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private static CharBuffer _getRawCharBuffer(String rawString, int start, boolean includeSpaces) {
        int count = 0;
        int i = start;
        while (i < rawString.length()) {
            char rawChar = rawString.charAt(i);
            if (_validChars.get(rawChar) || rawChar == ' ' && !includeSpaces) break;
            ++count;
            if (Character.isHighSurrogate(rawChar) && i + 1 < rawString.length() && Character.isLowSurrogate(rawString.charAt(i + 1))) {
                ++count;
            }
            ++i;
        }
        return CharBuffer.wrap(rawString, start, start + count);
    }
}

