/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.SystemEventLocalServiceUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.trash.model.TrashEntry;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;

public abstract class BaseTrashHandler
implements TrashHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseTrashHandler.class);

    @Override
    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException, SystemException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("inTrash", true);
        return SystemEventLocalServiceUtil.addSystemEvent(userId, groupId, this.getSystemEventClassName(), classPK, classUuid, referrerClassName, 1, extraDataJSONObject.toString());
    }

    @Override
    public void checkDuplicateEntry(long classPK, long containerModelId, String newName) throws PortalException, SystemException {
    }

    @Override
    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
    }

    @Override
    public ContainerModel getContainerModel(long containerModelId) throws PortalException, SystemException {
        return null;
    }

    @Override
    public String getContainerModelClassName() {
        return "";
    }

    @Override
    public String getContainerModelName() {
        return "";
    }

    @Override
    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException, SystemException {
        return Collections.emptyList();
    }

    @Override
    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException, SystemException {
        return 0;
    }

    @Override
    public String getDeleteMessage() {
        return "deleted-in-x";
    }

    @Override
    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        return null;
    }

    @Override
    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException, SystemException {
        if (trashedModel == null || !(trashedModel instanceof ContainerModel)) {
            return null;
        }
        ContainerModel containerModel = (ContainerModel)((Object)trashedModel);
        return this.getContainerModel(containerModel.getParentContainerModelId());
    }

    @Override
    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException, SystemException {
        return Collections.emptyList();
    }

    @Override
    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        return "";
    }

    @Override
    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        return "";
    }

    @Override
    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        return "";
    }

    @Override
    public String getRootContainerModelName() {
        return "";
    }

    @Override
    public String getSubcontainerModelName() {
        return "";
    }

    @Override
    public String getSystemEventClassName() {
        return this.getClassName();
    }

    @Override
    public String getTrashContainedModelName() {
        return "";
    }

    @Override
    public int getTrashContainedModelsCount(long classPK) throws PortalException, SystemException {
        return 0;
    }

    @Override
    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        return Collections.emptyList();
    }

    @Override
    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        return null;
    }

    @Override
    public String getTrashContainerModelName() {
        return "";
    }

    @Override
    public int getTrashContainerModelsCount(long classPK) throws PortalException, SystemException {
        return 0;
    }

    @Override
    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        return Collections.emptyList();
    }

    @Override
    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        return null;
    }

    @Override
    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        AssetRenderer assetRenderer;
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null && (assetRenderer = assetRendererFactory.getAssetRenderer(classPK)) instanceof TrashRenderer) {
            return (TrashRenderer)((Object)assetRenderer);
        }
        return null;
    }

    @Override
    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        String actionId = trashActionId;
        if (trashActionId.equals("DELETE")) {
            actionId = "DELETE";
        } else if (trashActionId.equals("OVERWRITE")) {
            actionId = "DELETE";
        } else {
            if (trashActionId.equals("MOVE")) {
                return false;
            }
            if (trashActionId.equals("RENAME")) {
                actionId = "UPDATE";
            } else if (trashActionId.equals("RESTORE")) {
                actionId = "DELETE";
            }
        }
        return this.hasPermission(permissionChecker, classPK, actionId);
    }

    @Override
    public boolean isContainerModel() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        return false;
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        return true;
    }

    @Override
    public boolean isTrashEntry(TrashEntry trashEntry, ClassedModel classedModel) {
        if (trashEntry == null || classedModel == null) {
            return false;
        }
        String className = this.getClassName();
        if (!className.equals(trashEntry.getClassName())) {
            return false;
        }
        Serializable primaryKeyObj = classedModel.getPrimaryKeyObj();
        if (!(primaryKeyObj instanceof Long)) {
            return false;
        }
        return trashEntry.getClassPK() == ((Long)primaryKeyObj).longValue();
    }

    @Override
    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
    }

    @Override
    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        if (this.isRestorable(classPK)) {
            this.restoreTrashEntry(userId, classPK);
        }
        _log.error("moveTrashEntry() is not implemented in " + this.getClass().getName());
        throw new SystemException();
    }

    @Override
    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException, SystemException {
    }

    @Override
    public void updateTitle(long classPK, String title) throws PortalException, SystemException {
    }

    protected AssetRendererFactory getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    protected abstract boolean hasPermission(PermissionChecker var1, long var2, String var4) throws PortalException, SystemException;
}

