/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.LiferayFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LiferayFilterTracker {
    private static Map<String, Set<LiferayFilter>> _liferayFilters = new HashMap<String, Set<LiferayFilter>>();

    public static void addLiferayFilter(LiferayFilter liferayFilter) {
        Class<?> clazz = liferayFilter.getClass();
        Set<LiferayFilter> liferayFilters = _liferayFilters.get(clazz.getName());
        if (liferayFilters == null) {
            liferayFilters = new HashSet<LiferayFilter>();
            _liferayFilters.put(clazz.getName(), liferayFilters);
        }
        liferayFilters.add(liferayFilter);
    }

    public static Set<String> getClassNames() {
        return Collections.unmodifiableSet(_liferayFilters.keySet());
    }

    public static Set<LiferayFilter> getLiferayFilters(String className) {
        Set<LiferayFilter> liferayFilters = _liferayFilters.get(className);
        if (liferayFilters == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(liferayFilters);
    }

    public static void removeLiferayFilter(LiferayFilter liferayFilter) {
        Class<?> clazz = liferayFilter.getClass();
        Set<LiferayFilter> liferayFilters = _liferayFilters.get(clazz.getName());
        if (liferayFilters != null) {
            liferayFilters.remove(liferayFilter);
        }
    }
}

