/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;

public class QueryIndexingHitsProcessor
implements HitsProcessor {
    private Document _document;

    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQueryIndexingEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQueryIndexingThreshold()) {
            this.addDocument(searchContext.getCompanyId(), searchContext.getKeywords(), searchContext.getLocale());
        }
        return true;
    }

    public void setDocument(Document document) {
        this._document = document;
    }

    protected void addDocument(long companyId, String keywords, Locale locale) throws SearchException {
        Document document = (Document)this._document.clone();
        document.addKeyword("companyId", companyId);
        document.addKeyword("keywordSearch", keywords);
        document.addKeyword("languageId", LocaleUtil.toLanguageId(locale));
        document.addKeyword("portletId", "3");
        SearchEngineUtil.addDocument(SearchEngineUtil.getDefaultSearchEngineId(), companyId, document);
    }
}

