/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseSpellCheckIndexWriter;
import com.liferay.portal.kernel.search.DictionaryEntry;
import com.liferay.portal.kernel.search.DictionaryReader;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilderUtil;
import com.liferay.portal.kernel.search.SearchException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseGenericSpellCheckIndexWriter
extends BaseSpellCheckIndexWriter {
    private static final int _DEFAULT_BATCH_SIZE = 1000;
    private static Log _log = LogFactoryUtil.getLog(BaseGenericSpellCheckIndexWriter.class);
    private int _batchSize = 1000;
    private Document _documentPrototype = new DocumentImpl();
    private IndexWriter _indexWriter;

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void setDocumentPrototype(Document documentPrototype) {
        this._documentPrototype = documentPrototype;
    }

    public void setIndexWriter(IndexWriter indexWriter) {
        this._indexWriter = indexWriter;
    }

    protected void addNGramFields(Document document, Map<String, String> nGrams) {
        for (Map.Entry<String, String> nGramEntry : nGrams.entrySet()) {
            document.addKeyword(nGramEntry.getKey(), nGramEntry.getValue());
        }
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String keywords, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws SearchException {
        Document document = (Document)this._documentPrototype.clone();
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("languageId", languageId);
        document.addKeyword("portletId", "3");
        document.addKeyword("priority", String.valueOf(weight));
        document.addKeyword(keywordFieldName, keywords);
        document.addKeyword("type", typeFieldValue);
        document.addKeyword("uid", this.getUID(companyId, languageId, keywords, new String[0]));
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder(keywords, maxNGramLength);
        this.addNGramFields(document, nGramHolder.getNGramEnds());
        Map<String, List<String>> nGrams = nGramHolder.getNGrams();
        for (Map.Entry<String, List<String>> entry : nGrams.entrySet()) {
            String fieldName = entry.getKey();
            for (String nGram : entry.getValue()) {
                document.addKeyword(fieldName, nGram);
            }
        }
        this.addNGramFields(document, nGramHolder.getNGramStarts());
        return document;
    }

    @Override
    protected void indexKeywords(long companyId, long groupId, String languageId, InputStream inputStream, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        HashSet<Document> documents = new HashSet<Document>();
        try {
            DictionaryReader dictionaryReader = new DictionaryReader(inputStream, "UTF-8");
            Iterator<DictionaryEntry> iterator = dictionaryReader.getDictionaryEntriesIterator();
            int counter = 0;
            while (iterator.hasNext()) {
                DictionaryEntry dictionaryEntry = iterator.next();
                Document document = this.createDocument(companyId, groupId, languageId, dictionaryEntry.getWord(), dictionaryEntry.getWeight(), keywordFieldName, typeFieldValue, maxNGramLength);
                documents.add(document);
                if (++counter != this._batchSize && iterator.hasNext()) continue;
                this._indexWriter.addDocuments(null, documents);
                documents.clear();
                counter = 0;
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to index dictionaries", e);
            }
            throw new SearchException(e.getMessage(), e);
        }
    }
}

