/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.agent.annotation;

import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Distributed;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.MatchType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DistributedRegistry {
    private static Map<String, Direction> _exactDirections = new ConcurrentHashMap<String, Direction>();
    private static Map<String, Direction> _postfixDirections = new ConcurrentHashMap<String, Direction>();
    private static Map<String, Direction> _prefixDirections = new ConcurrentHashMap<String, Direction>();

    public static boolean isDistributed(String name, Direction direction) {
        Direction registeredDirection = _exactDirections.get(name);
        if (registeredDirection == direction || registeredDirection == Direction.DUPLEX) {
            return true;
        }
        if (registeredDirection != null) {
            return false;
        }
        for (Map.Entry<String, Direction> entry : _postfixDirections.entrySet()) {
            String postfix = entry.getKey();
            if (!name.endsWith(postfix) || (registeredDirection = entry.getValue()) != direction && registeredDirection != Direction.DUPLEX) continue;
            return true;
        }
        for (Map.Entry<String, Direction> entry : _prefixDirections.entrySet()) {
            String prefix = entry.getKey();
            if (!name.startsWith(prefix) || (registeredDirection = entry.getValue()) != direction && registeredDirection != Direction.DUPLEX) continue;
            return true;
        }
        return false;
    }

    public static void registerDistributed(Class<?> clazz) {
        LinkedList queue = new LinkedList();
        queue.offer(clazz);
        Class currentClass = null;
        while ((currentClass = (Class)queue.poll()) != null) {
            Class<?>[] interfaceClasses;
            Field[] fields;
            Field[] fieldArray = fields = currentClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                int modifiers;
                Field field = fieldArray[n2];
                Distributed distributed = field.getAnnotation(Distributed.class);
                if (distributed != null && Modifier.isPublic(modifiers = field.getModifiers()) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType() == String.class) {
                    try {
                        String name = (String)field.get(null);
                        DistributedRegistry.registerDistributed(name, distributed.direction(), distributed.matchType());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
                ++n2;
            }
            Class supperClass = currentClass.getSuperclass();
            if (supperClass != null && supperClass != Object.class) {
                queue.offer(supperClass);
            }
            Class<?>[] classArray = interfaceClasses = currentClass.getInterfaces();
            int n3 = interfaceClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> interfaceClass = classArray[n4];
                if (!queue.contains(interfaceClass)) {
                    queue.offer(interfaceClass);
                }
                ++n4;
            }
        }
    }

    public static void registerDistributed(String name, Direction direction, MatchType matchType) {
        if (matchType.equals((Object)MatchType.POSTFIX)) {
            _postfixDirections.put(name, direction);
        } else if (matchType.equals((Object)MatchType.PREFIX)) {
            _prefixDirections.put(name, direction);
        } else {
            _exactDirections.put(name, direction);
        }
    }
}

