/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.cmis.search;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.cmis.search.CMISBetweenExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISConjunction;
import com.liferay.portal.kernel.repository.cmis.search.CMISContainsExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISCriterion;
import com.liferay.portal.kernel.repository.cmis.search.CMISDisjunction;
import com.liferay.portal.kernel.repository.cmis.search.CMISInFolderExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISInTreeExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISJunction;
import com.liferay.portal.kernel.repository.cmis.search.CMISNotExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISParameterValueUtil;
import com.liferay.portal.kernel.repository.cmis.search.CMISSearchQueryBuilder;
import com.liferay.portal.kernel.repository.cmis.search.CMISSimpleExpression;
import com.liferay.portal.kernel.repository.cmis.search.CMISSimpleExpressionOperator;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseCmisSearchQueryBuilder
implements CMISSearchQueryBuilder {
    private static Map<String, String> _cmisFields = new HashMap<String, String>();
    private static Set<String> _supportedFields;

    static {
        _cmisFields.put("createDate", "cmis:creationDate");
        _cmisFields.put("modified", "cmis:lastModificationDate");
        _cmisFields.put("name", "cmis:name");
        _cmisFields.put("title", "cmis:name");
        _cmisFields.put("userId", "cmis:createdBy");
        _cmisFields.put("userName", "cmis:createdBy");
        _supportedFields = new HashSet<String>();
        _supportedFields.add("content");
        _supportedFields.add("createDate");
        _supportedFields.add("folderId");
        _supportedFields.add("modified");
        _supportedFields.add("name");
        _supportedFields.add("title");
        _supportedFields.add("userId");
        _supportedFields.add("userName");
    }

    @Override
    public String buildQuery(SearchContext searchContext, Query query) throws SearchException {
        StringBundler sb = new StringBundler();
        sb.append("SELECT cmis:objectId");
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (queryConfig.isScoreEnabled()) {
            sb.append(", SCORE() AS HITS");
        }
        sb.append(" FROM cmis:document");
        CMISConjunction cmisConjunction = new CMISConjunction();
        this.traverseQuery(cmisConjunction, query, queryConfig);
        if (!cmisConjunction.isEmpty()) {
            sb.append(" WHERE ");
            sb.append(cmisConjunction.toQueryFragment());
        }
        Object[] sorts = searchContext.getSorts();
        if (queryConfig.isScoreEnabled() || ArrayUtil.isNotEmpty(sorts)) {
            sb.append(" ORDER BY ");
        }
        if (ArrayUtil.isNotEmpty(sorts)) {
            int i = 0;
            Object[] objectArray = sorts;
            int n = sorts.length;
            int n2 = 0;
            while (n2 < n) {
                Object sort = objectArray[n2];
                String fieldName = ((Sort)sort).getFieldName();
                if (this.isSupportedField(fieldName)) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.getCmisField(fieldName));
                    if (((Sort)sort).isReverse()) {
                        sb.append(" DESC");
                    } else {
                        sb.append(" ASC");
                    }
                    ++i;
                }
                ++n2;
            }
        } else if (queryConfig.isScoreEnabled()) {
            sb.append("HITS DESC");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CMISCriterion buildFieldExpression(String field, String value, CMISSimpleExpressionOperator cmisSimpleExpressionOperator) throws SearchException {
        void var4_9;
        boolean wildcard;
        Object var4_4 = null;
        boolean bl = wildcard = CMISSimpleExpressionOperator.LIKE == cmisSimpleExpressionOperator;
        if (field.equals("content")) {
            value = CMISParameterValueUtil.formatParameterValue(field, value);
            CMISContainsExpression cMISContainsExpression = new CMISContainsExpression(value);
            return var4_9;
        } else if (field.equals("folderId")) {
            long folderId = GetterUtil.getLong(value);
            try {
                RepositoryEntry repositoryEntry = RepositoryEntryLocalServiceUtil.fetchRepositoryEntry(folderId);
                if (repositoryEntry == null) return var4_9;
                String objectId = repositoryEntry.getMappedId();
                objectId = CMISParameterValueUtil.formatParameterValue(field, objectId, wildcard);
                CMISInFolderExpression cMISInFolderExpression = new CMISInFolderExpression(objectId);
                return var4_9;
            }
            catch (SystemException se) {
                throw new SearchException("Unable to determine folder {folderId=" + folderId + "}", se);
            }
        } else if (field.equals("userId")) {
            try {
                long userId = GetterUtil.getLong(value);
                User user = UserLocalServiceUtil.getUserById(userId);
                String screenName = CMISParameterValueUtil.formatParameterValue(field, user.getScreenName(), wildcard);
                CMISSimpleExpression cMISSimpleExpression = new CMISSimpleExpression(this.getCmisField(field), screenName, cmisSimpleExpressionOperator);
                return var4_9;
            }
            catch (Exception e) {
                if (!(e instanceof SearchException)) throw new SearchException("Unable to determine user {" + field + "=" + value + "}", e);
                throw (SearchException)e;
            }
        } else {
            value = CMISParameterValueUtil.formatParameterValue(field, value, wildcard);
            CMISSimpleExpression cMISSimpleExpression = new CMISSimpleExpression(this.getCmisField(field), value, cmisSimpleExpressionOperator);
        }
        return var4_9;
    }

    protected String getCmisField(String field) {
        return _cmisFields.get(field);
    }

    protected boolean isSupportedField(String field) {
        return _supportedFields.contains(field);
    }

    protected boolean isSupportsFullText(QueryConfig queryConfig) {
        String capabilityQuery = (String)((Object)queryConfig.getAttribute("capabilityQuery"));
        if (Validator.isNull(capabilityQuery)) {
            return false;
        }
        return capabilityQuery.equals("bothcombined") || capabilityQuery.equals("fulltextonly");
    }

    protected boolean isSupportsOnlyFullText(QueryConfig queryConfig) {
        String capabilityQuery = (String)((Object)queryConfig.getAttribute("capabilityQuery"));
        if (Validator.isNull(capabilityQuery)) {
            return false;
        }
        return capabilityQuery.equals("fulltextonly");
    }

    protected void traverseQuery(CMISJunction criterion, Query query, QueryConfig queryConfig) throws SearchException {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List<BooleanClause> booleanClauses = booleanQuery.clauses();
            CMISConjunction anyCMISConjunction = new CMISConjunction();
            CMISConjunction notCMISConjunction = new CMISConjunction();
            CMISDisjunction cmisDisjunction = new CMISDisjunction();
            for (BooleanClause booleanClause : booleanClauses) {
                CMISJunction cmisJunction = cmisDisjunction;
                BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
                if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
                    cmisJunction = anyCMISConjunction;
                } else if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
                    cmisJunction = notCMISConjunction;
                }
                Query booleanClauseQuery = booleanClause.getQuery();
                this.traverseQuery(cmisJunction, booleanClauseQuery, queryConfig);
            }
            if (!anyCMISConjunction.isEmpty()) {
                criterion.add(anyCMISConjunction);
            }
            if (!cmisDisjunction.isEmpty()) {
                criterion.add(cmisDisjunction);
            }
            if (!notCMISConjunction.isEmpty()) {
                criterion.add(new CMISNotExpression(notCMISConjunction));
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            QueryTerm queryTerm = termQuery.getQueryTerm();
            if (!this.isSupportedField(queryTerm.getField())) {
                return;
            }
            CMISCriterion cmisExpression = this.buildFieldExpression(queryTerm.getField(), queryTerm.getValue(), CMISSimpleExpressionOperator.EQ);
            if (cmisExpression != null) {
                boolean add = true;
                if (cmisExpression instanceof CMISContainsExpression && !this.isSupportsFullText(queryConfig)) {
                    add = false;
                } else if (!(cmisExpression instanceof CMISContainsExpression) && !(cmisExpression instanceof CMISInFolderExpression) && !(cmisExpression instanceof CMISInTreeExpression) && this.isSupportsOnlyFullText(queryConfig)) {
                    add = false;
                }
                if (add) {
                    criterion.add(cmisExpression);
                }
            }
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery = (TermRangeQuery)query;
            if (!this.isSupportedField(termRangeQuery.getField())) {
                return;
            }
            String fieldName = termRangeQuery.getField();
            String cmisField = this.getCmisField(fieldName);
            String cmisLowerTerm = CMISParameterValueUtil.formatParameterValue(fieldName, termRangeQuery.getLowerTerm());
            String cmisUpperTerm = CMISParameterValueUtil.formatParameterValue(fieldName, termRangeQuery.getUpperTerm());
            CMISBetweenExpression cmisCriterion = new CMISBetweenExpression(cmisField, cmisLowerTerm, cmisUpperTerm, termRangeQuery.includesLower(), termRangeQuery.includesUpper());
            criterion.add(cmisCriterion);
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            QueryTerm queryTerm = wildcardQuery.getQueryTerm();
            if (!this.isSupportedField(queryTerm.getField())) {
                return;
            }
            CMISCriterion cmisCriterion = this.buildFieldExpression(queryTerm.getField(), queryTerm.getValue(), CMISSimpleExpressionOperator.LIKE);
            if (cmisCriterion != null) {
                boolean add = true;
                if (cmisCriterion instanceof CMISContainsExpression && !this.isSupportsFullText(queryConfig)) {
                    add = false;
                } else if (!(cmisCriterion instanceof CMISContainsExpression) && !(cmisCriterion instanceof CMISInFolderExpression) && !(cmisCriterion instanceof CMISInTreeExpression) && this.isSupportsOnlyFullText(queryConfig)) {
                    add = false;
                }
                if (add) {
                    criterion.add(cmisCriterion);
                }
            }
        }
    }
}

