/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository;

import com.liferay.counter.service.CounterLocalService;
import com.liferay.portal.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.DefaultLocalRepositoryImpl;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryBuilderUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.service.CompanyLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.persistence.RepositoryEntryUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRepositoryImpl
implements BaseRepository {
    protected AssetEntryLocalService assetEntryLocalService;
    protected CompanyLocalService companyLocalService;
    protected CounterLocalService counterLocalService;
    protected DLAppHelperLocalService dlAppHelperLocalService;
    protected UserLocalService userLocalService;
    private long _companyId;
    private long _groupId;
    private LocalRepository _localRepository = new DefaultLocalRepositoryImpl(this);
    private long _repositoryId;
    private UnicodeProperties _typeSettingsProperties;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        FileInputStream is = null;
        long size = 0L;
        try {
            is = new FileInputStream(file);
            size = file.length();
            fileEntry = this.addFileEntry(folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
            if (is == null) return fileEntry;
        }
        catch (IOException ioe) {
            try {
                throw new SystemException(ioe);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
            return fileEntry;
        }
        catch (IOException iOException) {}
        return fileEntry;
    }

    @Override
    public void checkInFileEntry(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        this.checkInFileEntry(fileEntryId, lockUuid, new ServiceContext());
    }

    @Override
    public void deleteFileEntry(long folderId, String title) throws PortalException, SystemException {
        FileEntry fileEntry = this.getFileEntry(folderId, title);
        this.deleteFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public void deleteFileVersion(long fileEntryId, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFolder(long parentFolderId, String title) throws PortalException, SystemException {
        Folder folder = this.getFolder(parentFolderId, title);
        this.deleteFolder(folder.getFolderId());
    }

    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException, SystemException {
        return new ArrayList<Object>(this.getFileEntries(folderId, start, end, null));
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws SystemException {
        return this.getFileEntriesCount(folderId);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException, SystemException {
        return this.getFileEntriesCount(folderId, mimeTypes);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFolders(parentFolderId, includeMountfolders, start, end, obc);
    }

    public abstract List<Object> getFoldersAndFileEntries(long var1, int var3, int var4, OrderByComparator var5) throws SystemException;

    public abstract List<Object> getFoldersAndFileEntries(long var1, String[] var3, int var4, int var5, OrderByComparator var6) throws PortalException, SystemException;

    @Override
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        return this.getFoldersAndFileEntries(folderId, start, end, obc);
    }

    @Override
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFoldersAndFileEntries(folderId, mimeTypes, start, end, obc);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws SystemException {
        return this.getFoldersAndFileEntriesCount(folderId);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException, SystemException {
        return this.getFoldersAndFileEntriesCount(folderId, mimeTypes);
    }

    public abstract int getFoldersAndFileEntriesCount(long var1) throws SystemException;

    public abstract int getFoldersAndFileEntriesCount(long var1, String[] var3) throws PortalException, SystemException;

    @Override
    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException, SystemException {
        return this.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public long getGroupId() {
        return this._groupId;
    }

    @Override
    public LocalRepository getLocalRepository() {
        return this._localRepository;
    }

    public Object[] getRepositoryEntryIds(String objectId) throws SystemException {
        boolean newRepositoryEntry = false;
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.fetchByR_M(this.getRepositoryId(), objectId);
        if (repositoryEntry == null) {
            long repositoryEntryId = this.counterLocalService.increment();
            repositoryEntry = RepositoryEntryUtil.create(repositoryEntryId);
            repositoryEntry.setGroupId(this.getGroupId());
            repositoryEntry.setRepositoryId(this.getRepositoryId());
            repositoryEntry.setMappedId(objectId);
            RepositoryEntryUtil.update(repositoryEntry);
            newRepositoryEntry = true;
        }
        return new Object[]{repositoryEntry.getRepositoryEntryId(), repositoryEntry.getUuid(), newRepositoryEntry};
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFileEntries(rootFolderId, start, end, obc);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFileEntries(rootFolderId, mimeTypes, start, end, obc);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws SystemException {
        return this.getFileEntriesCount(rootFolderId);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException, SystemException {
        return this.getFileEntriesCount(rootFolderId, mimeTypes);
    }

    @Override
    public long getRepositoryId() {
        return this._repositoryId;
    }

    public UnicodeProperties getTypeSettingsProperties() {
        return this._typeSettingsProperties;
    }

    @Override
    public abstract void initRepository() throws PortalException, SystemException;

    @Override
    public Lock lockFileEntry(long fileEntryId) throws PortalException, SystemException {
        this.checkOutFileEntry(fileEntryId, new ServiceContext());
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        return fileEntry.getLock();
    }

    @Override
    public Lock lockFileEntry(long fileEntryId, String owner, long expirationTime) throws PortalException, SystemException {
        FileEntry fileEntry = this.checkOutFileEntry(fileEntryId, owner, expirationTime, new ServiceContext());
        return fileEntry.getLock();
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        searchContext.setSearchEngineId("GENERIC_ENGINE");
        BooleanQuery fullQuery = RepositorySearchQueryBuilderUtil.getFullQuery(searchContext);
        return this.search(searchContext, fullQuery);
    }

    @Override
    public void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this.assetEntryLocalService = assetEntryLocalService;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @Override
    public void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this.companyLocalService = companyLocalService;
    }

    @Override
    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    @Override
    public void setDLAppHelperLocalService(DLAppHelperLocalService dlAppHelperLocalService) {
        this.dlAppHelperLocalService = dlAppHelperLocalService;
    }

    @Override
    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    @Override
    public void setRepositoryId(long repositoryId) {
        this._repositoryId = repositoryId;
    }

    @Override
    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
    }

    @Override
    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    @Override
    public void unlockFolder(long parentFolderId, String title, String lockUuid) throws PortalException, SystemException {
        Folder folder = this.getFolder(parentFolderId, title);
        this.unlockFolder(folder.getFolderId(), lockUuid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry;
        FileInputStream is = null;
        long size = 0L;
        try {
            is = new FileInputStream(file);
            size = file.length();
            fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
            if (is == null) return fileEntry;
        }
        catch (IOException ioe) {
            try {
                throw new SystemException(ioe);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
            return fileEntry;
        }
        catch (IOException iOException) {}
        return fileEntry;
    }

    @Override
    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    protected void clearManualCheckInRequired(long fileEntryId, ServiceContext serviceContext) throws NoSuchRepositoryEntryException, SystemException {
        boolean webDAVCheckInMode = GetterUtil.getBoolean(serviceContext.getAttribute("webDAVCheckInMode"));
        if (webDAVCheckInMode) {
            return;
        }
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByPrimaryKey(fileEntryId);
        boolean manualCheckInRequired = repositoryEntry.getManualCheckInRequired();
        if (!manualCheckInRequired) {
            return;
        }
        repositoryEntry.setManualCheckInRequired(false);
        RepositoryEntryUtil.update(repositoryEntry);
    }

    protected void setManualCheckInRequired(long fileEntryId, ServiceContext serviceContext) throws NoSuchRepositoryEntryException, SystemException {
        boolean manualCheckInRequired = GetterUtil.getBoolean(serviceContext.getAttribute("manualCheckInRequired"));
        if (!manualCheckInRequired) {
            return;
        }
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByPrimaryKey(fileEntryId);
        repositoryEntry.setManualCheckInRequired(manualCheckInRequired);
        RepositoryEntryUtil.update(repositoryEntry);
    }
}

