/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ClassPathUtil {
    private static Log _log = LogFactoryUtil.getLog(ClassPathUtil.class);
    private static String _globalClassPath;
    private static String _portalClassPath;

    public static Set<URL> getClassPathURLs(ClassLoader classLoader) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                urls.addAll(Arrays.asList(urlClassLoader.getURLs()));
            }
            classLoader = classLoader.getParent();
        }
        return urls;
    }

    public static URL[] getClassPathURLs(String classPath) throws MalformedURLException {
        String[] paths = StringUtil.split(classPath, File.pathSeparatorChar);
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            URI uri = file.toURI();
            urls.add(uri.toURL());
            ++n2;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String getGlobalClassPath() {
        return _globalClassPath;
    }

    public static String getJVMClassPath(boolean includeBootClassPath) {
        String jvmClassPath = System.getProperty("java.class.path");
        if (includeBootClassPath) {
            String bootClassPath = System.getProperty("sun.boot.class.path");
            jvmClassPath = jvmClassPath.concat(File.pathSeparator).concat(bootClassPath);
        }
        return jvmClassPath;
    }

    public static String getPortalClassPath() {
        return _portalClassPath;
    }

    public static void initializeClassPaths(ServletContext servletContext) {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (classLoader == null) {
            _log.error("Portal ClassLoader is null");
            return;
        }
        StringBundler sb = new StringBundler(8);
        String appServerGlobalClassPath = ClassPathUtil._buildClassPath(classLoader, ServletException.class.getName());
        sb.append(appServerGlobalClassPath);
        sb.append(File.pathSeparator);
        String portalGlobalClassPath = ClassPathUtil._buildClassPath(classLoader, PortalException.class.getName());
        sb.append(portalGlobalClassPath);
        _globalClassPath = sb.toString();
        sb.append(File.pathSeparator);
        sb.append(ClassPathUtil._buildClassPath(classLoader, "com.liferay.portal.servlet.MainServlet"));
        sb.append(File.pathSeparator);
        sb.append(servletContext.getRealPath(""));
        sb.append("/WEB-INF/classes");
        _portalClassPath = sb.toString();
    }

    private static String _buildClassPath(ClassLoader classloader, String className) {
        String protocol;
        String pathOfClass = StringUtil.replace(className, '.', '/');
        pathOfClass = pathOfClass.concat(".class");
        URL url = classloader.getResource(pathOfClass);
        if (_log.isDebugEnabled()) {
            _log.debug("Build class path from " + url);
        }
        if ((protocol = url.getProtocol()).equals("bundle") || protocol.equals("bundleresource")) {
            try {
                URLConnection urlConnection = url.openConnection();
                Class<?> clazz = urlConnection.getClass();
                Method getLocalURLMethod = clazz.getDeclaredMethod("getLocalURL", new Class[0]);
                getLocalURLMethod.setAccessible(true);
                url = (URL)getLocalURLMethod.invoke((Object)urlConnection, new Object[0]);
            }
            catch (Exception e) {
                _log.error("Unable to resolve local URL from bundle", e);
                return "";
            }
        }
        String path = URLCodec.decodeURL(url.getPath());
        if (_log.isDebugEnabled()) {
            _log.debug("Path " + path);
        }
        path = StringUtil.replace(path, '\\', '/');
        if (_log.isDebugEnabled()) {
            _log.debug("Decoded path " + path);
        }
        if (ServerDetector.isWebLogic() && protocol.equals("zip")) {
            path = "file:".concat(path);
        }
        if (ServerDetector.isJBoss() && (protocol.equals("vfs") || protocol.equals("vfsfile"))) {
            String jarFilePath;
            File jarFile;
            int pos = path.indexOf(".jar/");
            if (pos != -1 && (jarFile = new File(jarFilePath = path.substring(0, pos + 4))).isFile()) {
                path = String.valueOf(jarFilePath) + '!' + path.substring(pos + 4);
            }
            path = "file:".concat(path);
        }
        File dir = null;
        int pos = -1;
        if (!path.startsWith("file:") || (pos = path.indexOf(33)) == -1) {
            if (!path.endsWith(pathOfClass)) {
                _log.error("Class " + className + " is not loaded from a JAR file");
                return "";
            }
            String classesDirName = path.substring(0, path.length() - pathOfClass.length());
            if (!classesDirName.endsWith("/WEB-INF/classes/")) {
                _log.error("Class " + className + " is not loaded from a standard " + "location (/WEB-INF/classes)");
                return "";
            }
            String libDirName = classesDirName.substring(0, classesDirName.length() - "classes/".length());
            libDirName = String.valueOf(libDirName) + "/lib";
            dir = new File(libDirName);
        } else {
            pos = path.lastIndexOf(47, pos);
            dir = new File(path.substring("file:".length(), pos));
        }
        if (!dir.isDirectory()) {
            _log.error(String.valueOf(dir.toString()) + " is not a directory");
            return "";
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        StringBundler sb = new StringBundler(files.length * 2);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            sb.append(((File)file).getAbsolutePath());
            sb.append(File.pathSeparator);
            ++n2;
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

