/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.rpc;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCException;
import com.liferay.portal.kernel.process.ProcessCallable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class IntrabandRPCUtil {
    public static <V extends Serializable> V execute(RegistrationReference registrationReference, ProcessCallable<V> processCallable) throws IntrabandRPCException {
        Intraband intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.RPC;
        Serializer serializer = new Serializer();
        serializer.writeObject(processCallable);
        try {
            Datagram responseDatagram = intraband.sendSyncDatagram(registrationReference, Datagram.createRequestDatagram(systemDataType.getValue(), serializer.toByteBuffer()));
            Deserializer deserializer = new Deserializer(responseDatagram.getDataByteBuffer());
            return (V)deserializer.readObject();
        }
        catch (Exception e) {
            throw new IntrabandRPCException(e);
        }
    }

    public static <V extends Serializable> V execute(RegistrationReference registrationReference, ProcessCallable<V> processCallable, long timeout, TimeUnit timeUnit) throws IntrabandRPCException {
        Intraband intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.RPC;
        Serializer serializer = new Serializer();
        serializer.writeObject(processCallable);
        try {
            Datagram responseDatagram = intraband.sendSyncDatagram(registrationReference, Datagram.createRequestDatagram(systemDataType.getValue(), serializer.toByteBuffer()), timeout, timeUnit);
            Deserializer deserializer = new Deserializer(responseDatagram.getDataByteBuffer());
            return (V)deserializer.readObject();
        }
        catch (Exception e) {
            throw new IntrabandRPCException(e);
        }
    }
}

