/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogSanitizerException;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.ArrayList;

public class SanitizerLogWrapper
extends LogWrapper {
    private static final String _SANITIZED = " [Sanitized]";
    private static boolean _LOG_SANITIZER_ENABLED = GetterUtil.getBoolean(SystemProperties.get("log.sanitizer.enabled"));
    private static boolean _LOG_SANITIZER_ESCAPE_HTML_ENABLED = false;
    private static char _LOG_SANITIZER_REPLACEMENT_CHARACTER = (char)95;
    private static int[] _whitelistCharacters = new int[128];

    public static void init() {
        int[] whitelistCharacters;
        if (!_LOG_SANITIZER_ENABLED) {
            return;
        }
        _LOG_SANITIZER_ESCAPE_HTML_ENABLED = GetterUtil.getBoolean(SystemProperties.get("log.sanitizer.escape.html.enabled"));
        _LOG_SANITIZER_REPLACEMENT_CHARACTER = (char)GetterUtil.getInteger(SystemProperties.get("log.sanitizer.replacement.character"));
        int[] nArray = whitelistCharacters = GetterUtil.getIntegerValues(SystemProperties.getArray("log.sanitizer.whitelist.characters"));
        int n = whitelistCharacters.length;
        int n2 = 0;
        while (n2 < n) {
            int whitelistCharacter = nArray[n2];
            if (whitelistCharacter >= 0 && whitelistCharacter < _whitelistCharacters.length) {
                SanitizerLogWrapper._whitelistCharacters[whitelistCharacter] = 1;
            } else {
                System.err.println("Unable to register log whitelist character " + whitelistCharacter);
            }
            ++n2;
        }
    }

    public static boolean isEnabled() {
        return _LOG_SANITIZER_ENABLED;
    }

    public SanitizerLogWrapper(Log log) {
        super(log);
    }

    @Override
    public void debug(Object msg) {
        super.debug(this.sanitize(msg));
    }

    @Override
    public void debug(Object msg, Throwable t) {
        super.debug(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void debug(Throwable t) {
        super.debug(this.sanitize(t));
    }

    @Override
    public void error(Object msg) {
        super.error(this.sanitize(msg));
    }

    @Override
    public void error(Object msg, Throwable t) {
        super.error(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void error(Throwable t) {
        super.error(this.sanitize(t));
    }

    @Override
    public void fatal(Object msg) {
        super.fatal(this.sanitize(msg));
    }

    @Override
    public void fatal(Object msg, Throwable t) {
        super.fatal(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void fatal(Throwable t) {
        super.fatal(this.sanitize(t));
    }

    @Override
    public void info(Object msg) {
        super.info(this.sanitize(msg));
    }

    @Override
    public void info(Object msg, Throwable t) {
        super.info(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void info(Throwable t) {
        super.info(this.sanitize(t));
    }

    @Override
    public void trace(Object msg) {
        super.trace(this.sanitize(msg));
    }

    @Override
    public void trace(Object msg, Throwable t) {
        super.trace(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void trace(Throwable t) {
        super.trace(this.sanitize(t));
    }

    @Override
    public void warn(Object msg) {
        super.warn(this.sanitize(msg));
    }

    @Override
    public void warn(Object msg, Throwable t) {
        super.warn(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void warn(Throwable t) {
        super.warn(this.sanitize(t));
    }

    protected String sanitize(Object obj) {
        if (obj == null) {
            return null;
        }
        String message = obj.toString();
        return this.sanitize(message, message);
    }

    protected String sanitize(String message, String defaultResult) {
        if (message == null) {
            return null;
        }
        char[] chars = message.toCharArray();
        boolean sanitized = false;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c >= '\u0000' && c < _whitelistCharacters.length && _whitelistCharacters[c] == 0) {
                chars[i] = _LOG_SANITIZER_REPLACEMENT_CHARACTER;
                sanitized = true;
            }
            ++i;
        }
        if (sanitized) {
            String sanitizedMessage = new String(chars);
            sanitizedMessage = sanitizedMessage.concat(_SANITIZED);
            if (_LOG_SANITIZER_ESCAPE_HTML_ENABLED) {
                return HtmlUtil.escape(sanitizedMessage);
            }
            return sanitizedMessage;
        }
        return defaultResult;
    }

    protected Throwable sanitize(Throwable throwable) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        Throwable tempThrowable = throwable;
        while (tempThrowable != null) {
            throwables.add(tempThrowable);
            tempThrowable = tempThrowable.getCause();
        }
        Throwable resultThrowable = null;
        boolean sanitized = false;
        int i = throwables.size() - 1;
        while (i > -1) {
            Throwable curThrowable = (Throwable)throwables.get(i);
            String message = curThrowable.toString();
            String sanitizedMessage = this.sanitize(message, null);
            if (!sanitized && sanitizedMessage == null) {
                resultThrowable = curThrowable;
            } else {
                if (sanitizedMessage == null) {
                    sanitizedMessage = message;
                }
                sanitized = true;
                resultThrowable = new LogSanitizerException(sanitizedMessage, curThrowable.getStackTrace(), resultThrowable);
            }
            --i;
        }
        return resultThrowable;
    }
}

