/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.StagedGroupedModel;
import com.liferay.portal.model.StagedModel;
import java.io.Serializable;

public class ExportImportPathUtil {
    public static final String PATH_PREFIX_COMPANY = "company";
    public static final String PATH_PREFIX_GROUP = "group";
    public static final String PATH_PREFIX_LAYOUT = "layout";
    public static final String PATH_PREFIX_PORTLET = "portlet";
    private static final String _FILE_EXTENSION_XML = ".xml";

    public static String getExpandoPath(String path) {
        if (!Validator.isFilePath(path, false)) {
            throw new IllegalArgumentException(String.valueOf(path) + " is located outside of the LAR");
        }
        int pos = path.lastIndexOf(_FILE_EXTENSION_XML);
        if (pos == -1) {
            throw new IllegalArgumentException(String.valueOf(path) + " is not an XML file");
        }
        return path.substring(0, pos).concat("-expando").concat(path.substring(pos));
    }

    public static String getLayoutPath(PortletDataContext portletDataContext, long plid) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_LAYOUT);
        sb.append("/");
        sb.append(plid);
        sb.append(_FILE_EXTENSION_XML);
        return sb.toString();
    }

    public static String getModelPath(long groupId, String className, long classPK) {
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, groupId, className, Long.valueOf(classPK), null);
    }

    public static String getModelPath(PortletDataContext portletDataContext, String className, long classPK) {
        return ExportImportPathUtil.getModelPath(portletDataContext, className, classPK, null);
    }

    public static String getModelPath(PortletDataContext portletDataContext, String className, long classPK, String dependentFileName) {
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, portletDataContext.getSourceGroupId(), className, Long.valueOf(classPK), dependentFileName);
    }

    public static String getModelPath(StagedModel stagedModel) {
        return ExportImportPathUtil.getModelPath(stagedModel, null);
    }

    public static String getModelPath(StagedModel stagedModel, String dependentFileName) {
        StagedModelType stagedModelType = stagedModel.getStagedModelType();
        if (stagedModel instanceof StagedGroupedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)stagedModel;
            return ExportImportPathUtil.getModelPath(PATH_PREFIX_GROUP, stagedGroupedModel.getGroupId(), stagedModelType.getClassName(), stagedModel.getPrimaryKeyObj(), dependentFileName);
        }
        return ExportImportPathUtil.getModelPath(PATH_PREFIX_COMPANY, stagedModel.getCompanyId(), stagedModelType.getClassName(), stagedModel.getPrimaryKeyObj(), dependentFileName);
    }

    public static String getPortletPath(PortletDataContext portletDataContext, String portletId) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_PORTLET);
        sb.append("/");
        sb.append(portletId);
        return sb.toString();
    }

    public static String getRootPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getRootPath(PATH_PREFIX_GROUP, portletDataContext.getScopeGroupId());
    }

    public static String getSourceLayoutPath(PortletDataContext portletDataContext, long layoutId) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getSourceRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_LAYOUT);
        sb.append("/");
        sb.append(layoutId);
        return sb.toString();
    }

    public static String getSourcePortletPath(PortletDataContext portletDataContext, String portletId) {
        StringBundler sb = new StringBundler(5);
        sb.append(ExportImportPathUtil.getSourceRootPath(portletDataContext));
        sb.append("/");
        sb.append(PATH_PREFIX_PORTLET);
        sb.append("/");
        sb.append(portletId);
        return sb.toString();
    }

    public static String getSourceRootPath(PortletDataContext portletDataContext) {
        return ExportImportPathUtil.getRootPath(PATH_PREFIX_GROUP, portletDataContext.getSourceGroupId());
    }

    protected static String getModelPath(String pathPrefix, long pathPrimaryKey, String className, Serializable primaryKeyObj, String dependentFileName) {
        StringBundler sb = new StringBundler(7);
        sb.append(ExportImportPathUtil.getRootPath(pathPrefix, pathPrimaryKey));
        sb.append("/");
        sb.append(className);
        sb.append("/");
        sb.append(primaryKeyObj.toString());
        if (dependentFileName == null) {
            sb.append(_FILE_EXTENSION_XML);
        } else {
            sb.append("/");
            sb.append(dependentFileName);
        }
        return sb.toString();
    }

    protected static String getRootPath(String pathPrefix, long pathPrimaryKey) {
        StringBundler sb = new StringBundler(4);
        sb.append("/");
        sb.append(pathPrefix);
        sb.append("/");
        sb.append(pathPrimaryKey);
        return sb.toString();
    }
}

