/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.model.WorkflowedModel;

public abstract class BaseStagedModelDataHandler<T extends StagedModel>
implements StagedModelDataHandler<T> {
    private static Log _log = LogFactoryUtil.getLog(BaseStagedModelDataHandler.class);

    @Override
    public abstract void deleteStagedModel(String var1, long var2, String var4, String var5) throws PortalException, SystemException;

    @Override
    public void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        if (!this.isExportable(portletDataContext, stagedModel)) {
            return;
        }
        try {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            this.doExportStagedModel(portletDataContext, (StagedModel)stagedModel.clone());
            if (this.countStagedModel(portletDataContext, stagedModel)) {
                manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
            }
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public abstract String[] getClassNames();

    @Override
    public String getDisplayName(T stagedModel) {
        return stagedModel.getUuid();
    }

    @Override
    public int[] getExportableStatuses() {
        return new int[1];
    }

    @Override
    public void importCompanyStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        try {
            this.doImportCompanyStagedModel(portletDataContext, stagedModel);
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        String path = ExportImportPathUtil.getModelPath(stagedModel);
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        try {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            if (stagedModel instanceof TrashedModel) {
                this.restoreStagedModel(portletDataContext, stagedModel);
            }
            this.doImportStagedModel(portletDataContext, stagedModel);
            manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        try {
            this.doRestoreStagedModel(portletDataContext, stagedModel);
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public boolean validateReference(PortletDataContext portletDataContext, Element rootElement, Element referenceElement) {
        String elementName = referenceElement.getName();
        if (elementName.equals("missing-reference")) {
            String uuid = referenceElement.attributeValue("uuid");
            try {
                boolean valid = this.validateMissingReference(uuid, portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId());
                if (!valid) {
                    valid = this.validateMissingReference(uuid, portletDataContext.getCompanyId(), portletDataContext.getCompanyGroupId());
                }
                return valid;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, T stagedModel) {
        return !portletDataContext.isStagedModelCounted((StagedModel)stagedModel);
    }

    protected abstract void doExportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, T stagedModel) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract void doImportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean isExportable(PortletDataContext portletDataContext, T stagedModel) {
        block7: {
            TrashHandler trashHandler;
            String path = ExportImportPathUtil.getModelPath(stagedModel);
            if (portletDataContext.isPathExportedInScope(path)) {
                return false;
            }
            if (stagedModel instanceof WorkflowedModel) {
                WorkflowedModel workflowedModel = (WorkflowedModel)stagedModel;
                if (!ArrayUtil.contains(this.getExportableStatuses(), workflowedModel.getStatus())) {
                    return false;
                }
            }
            if ((trashHandler = TrashHandlerRegistryUtil.getTrashHandler(stagedModel.getModelClassName())) != null) {
                try {
                    long classPK = (Long)stagedModel.getPrimaryKeyObj();
                    if (trashHandler.isInTrash(classPK) || trashHandler.isInTrashContainer(classPK)) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn("Unable to check trash status for " + stagedModel.getModelClassName());
                }
            }
        }
        return true;
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        return true;
    }
}

