/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jsonwebservice;

import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Set;

public class JSONWebServiceNaming {
    protected Set<String> excludedMethodNames = SetUtil.fromArray(new String[]{"getBeanIdentifier", "setBeanIdentifier"});
    protected Set<Class<?>> excludedTypes = SetUtil.fromArray(new Class[]{InputStream.class, OutputStream.class});
    protected Set<String> invalidHttpMethods = SetUtil.fromArray(PropsUtil.getArray("jsonws.web.service.invalid.http.methods"));
    protected Set<String> prefixes = SetUtil.fromArray(new String[]{"get", "has", "is"});

    public String convertClassNameToPath(Class<?> clazz) {
        String className = clazz.getSimpleName();
        className = StringUtil.replace(className, "Impl", "");
        className = StringUtil.replace(className, "Service", "");
        return StringUtil.toLowerCase(className);
    }

    public String convertImplClassNameToUtilClassName(Class<?> implementationClass) {
        String implementationClassName = implementationClass.getName();
        if (implementationClassName.endsWith("Impl")) {
            implementationClassName = implementationClassName.substring(0, implementationClassName.length() - 4);
        }
        String utilClassName = String.valueOf(implementationClassName) + "Util";
        utilClassName = StringUtil.replace(utilClassName, ".impl.", ".");
        return utilClassName;
    }

    public String convertMethodNameToHttpMethod(Method method) {
        String methodName = method.getName();
        String methodNamePrefix = this.getMethodNamePrefix(methodName);
        if (this.prefixes.contains(methodNamePrefix)) {
            return "GET";
        }
        return "POST";
    }

    public String convertMethodNameToPath(Method method) {
        return CamelCaseUtil.fromCamelCase(method.getName());
    }

    public boolean isIncludedMethod(Method method) {
        Class<?>[] parameterTypes;
        if (this.excludedMethodNames != null && this.excludedMethodNames.contains(method.getName())) {
            return false;
        }
        if (this.excludedTypes == null) {
            return true;
        }
        Class<?>[] classArray = parameterTypes = method.getParameterTypes();
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            if (this.excludedTypes.contains(parameterType)) {
                return false;
            }
            ++n2;
        }
        return !this.excludedTypes.contains(method.getReturnType());
    }

    public boolean isValidHttpMethod(String httpMethod) {
        return !this.invalidHttpMethods.contains(httpMethod);
    }

    protected String getMethodNamePrefix(String methodName) {
        int i = 0;
        while (i < methodName.length()) {
            if (Character.isUpperCase(methodName.charAt(i))) break;
            ++i;
        }
        return methodName.substring(0, i);
    }
}

