/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployScanner;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class AutoDeployDir {
    public static final String DEFAULT_NAME = "defaultAutoDeployDir";
    private static Log _log = LogFactoryUtil.getLog(AutoDeployDir.class);
    private List<AutoDeployListener> _autoDeployListeners;
    private AutoDeployScanner _autoDeployScanner;
    private Map<String, Long> _blacklistFileTimestamps;
    private File _deployDir;
    private File _destDir;
    private long _interval;
    private String _name;

    public static void deploy(AutoDeploymentContext autoDeploymentContext, List<AutoDeployListener> autoDeployListeners) throws AutoDeployException {
        ArrayList<String> duplicateApplicableAutoDeployListenerClassNames = new ArrayList<String>();
        for (AutoDeployListener autoDeployListener : autoDeployListeners) {
            if (autoDeployListener.deploy(autoDeploymentContext) == 0) continue;
            Class<?> autoDeployListenerClass = autoDeployListener.getClass();
            duplicateApplicableAutoDeployListenerClassNames.add(autoDeployListenerClass.getName());
        }
        if (duplicateApplicableAutoDeployListenerClassNames.size() > 1) {
            StringBundler sb = new StringBundler();
            sb.append("The auto deploy listeners ");
            sb.append(StringUtil.merge(duplicateApplicableAutoDeployListenerClassNames, ", "));
            sb.append(" all deployed ");
            sb.append(autoDeploymentContext.getFile());
            sb.append(", but only one should have.");
            throw new AutoDeployException(sb.toString());
        }
    }

    public AutoDeployDir(String name, File deployDir, File destDir, long interval, List<AutoDeployListener> autoDeployListeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._destDir = destDir;
        this._interval = interval;
        this._autoDeployListeners = new CopyOnWriteArrayList<AutoDeployListener>(autoDeployListeners);
        this._blacklistFileTimestamps = new HashMap<String, Long>();
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getDestDir() {
        return this._destDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public List<AutoDeployListener> getListeners() {
        return this._autoDeployListeners;
    }

    public String getName() {
        return this._name;
    }

    public void registerListener(AutoDeployListener listener) {
        this._autoDeployListeners.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (this._interval > 0L) {
            try {
                Thread currentThread = Thread.currentThread();
                this._autoDeployScanner = new AutoDeployScanner(currentThread.getThreadGroup(), AutoDeployScanner.class.getName(), this);
                this._autoDeployScanner.start();
                if (!_log.isInfoEnabled()) return;
                _log.info("Auto deploy scanner started for " + this._deployDir);
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                this.stop();
                return;
            }
        } else {
            if (!_log.isInfoEnabled()) return;
            _log.info("Auto deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (this._autoDeployScanner != null) {
            this._autoDeployScanner.pause();
        }
    }

    public void unregisterListener(AutoDeployListener autoDeployListener) {
        this._autoDeployListeners.remove(autoDeployListener);
    }

    protected AutoDeploymentContext buildAutoDeploymentContext(File file) {
        AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
        autoDeploymentContext.setFile(file);
        return autoDeploymentContext;
    }

    protected void processFile(File file) {
        String fileName = file.getName();
        if (!file.canRead()) {
            _log.error("Unable to read " + fileName);
            return;
        }
        if (!file.canWrite()) {
            _log.error("Unable to write " + fileName);
            return;
        }
        if (this._blacklistFileTimestamps.containsKey(fileName) && this._blacklistFileTimestamps.get(fileName).longValue() == file.lastModified()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip processing of " + fileName + " because it is " + "blacklisted");
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Processing " + fileName);
        }
        try {
            AutoDeploymentContext autoDeploymentContext = this.buildAutoDeploymentContext(file);
            AutoDeployDir.deploy(autoDeploymentContext, this._autoDeployListeners);
            if (file.delete()) {
                return;
            }
            _log.error("Auto deploy failed to remove " + fileName);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isInfoEnabled()) {
            _log.info("Add " + fileName + " to the blacklist");
        }
        this._blacklistFileTimestamps.put(fileName, file.lastModified());
    }

    protected void scanDirectory() {
        File[] files = this._deployDir.listFiles();
        if (files == null) {
            return;
        }
        Set<String> blacklistedFileNames = this._blacklistFileTimestamps.keySet();
        Iterator<String> iterator = blacklistedFileNames.iterator();
        while (iterator.hasNext()) {
            String blacklistedFileName = iterator.next();
            boolean blacklistedFileExists = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (StringUtil.equalsIgnoreCase(blacklistedFileName, file.getName())) {
                    blacklistedFileExists = true;
                }
                ++n2;
            }
            if (blacklistedFileExists) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("Remove blacklisted file " + blacklistedFileName + " because it was deleted");
            }
            iterator.remove();
        }
        File[] fileArray = files;
        int n = files.length;
        int n3 = 0;
        while (n3 < n) {
            File file = fileArray[n3];
            String fileName = file.getName();
            fileName = StringUtil.toLowerCase(fileName);
            if (file.isFile() && (fileName.endsWith(".jar") || fileName.endsWith(".lpkg") || fileName.endsWith(".war") || fileName.endsWith(".xml") || fileName.endsWith(".zip"))) {
                this.processFile(file);
            }
            ++n3;
        }
    }
}

