/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.shard;

import com.liferay.portal.kernel.dao.shard.Shard;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import javax.sql.DataSource;

public class ShardUtil {
    private static final String[] _DEFAULT_SHARD_ARRAY = new String[0];
    private static Shard _shard;

    public static String[] getAvailableShardNames() {
        String[] availableShardNames;
        Shard shard = ShardUtil.getShard();
        if (shard != null && (availableShardNames = shard.getAvailableShardNames()) != null) {
            return availableShardNames;
        }
        return _DEFAULT_SHARD_ARRAY;
    }

    public static String getCurrentShardName() {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            return shard.getCurrentShardName();
        }
        return "";
    }

    public static DataSource getDataSource() {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            return shard.getDataSource();
        }
        return null;
    }

    public static String getDefaultShardName() {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            return shard.getDefaultShardName();
        }
        return null;
    }

    public static Shard getShard() {
        PortalRuntimePermission.checkGetBeanProperty(ShardUtil.class);
        return _shard;
    }

    public static boolean isEnabled() {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            return shard.isEnabled();
        }
        return false;
    }

    public static String popCompanyService() {
        String value = null;
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            value = shard.popCompanyService();
        }
        return value;
    }

    public static void pushCompanyService(long companyId) {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            shard.pushCompanyService(companyId);
        }
    }

    public static void pushCompanyService(String shardName) {
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            shard.pushCompanyService(shardName);
        }
    }

    public static String setTargetSource(String shardName) {
        String value = null;
        Shard shard = ShardUtil.getShard();
        if (shard != null) {
            value = shard.setTargetSource(shardName);
        }
        return value;
    }

    public void setShard(Shard shard) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _shard = shard;
    }
}

