/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.documentlibrary.model;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;

/**
 * @author Samuel Kong
 */
public class DLFileEntryConstants {

	public static final int DEFAULT_READ_COUNT = 0;

	public static final long LOCK_EXPIRATION_TIME =
		GetterUtil.getLong(
			PropsUtil.get("lock.expiration.time." + getClassName()));

	public static final String PRIVATE_WORKING_COPY_VERSION = "PWC";

	public static final String VERSION_DEFAULT = "1.0";

	public static String getClassName() {
		return DLFileEntry.class.getName();
	}

}