/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.service;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.ReferenceRegistry;

/**
 * The utility for the c m i s repository local service. This utility wraps {@link com.liferay.portal.service.impl.CMISRepositoryLocalServiceImpl} and is the primary access point for service operations in application layer code running on the local server.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CMISRepositoryLocalService
 * @see com.liferay.portal.service.base.CMISRepositoryLocalServiceBaseImpl
 * @see com.liferay.portal.service.impl.CMISRepositoryLocalServiceImpl
 * @generated
 */
public class CMISRepositoryLocalServiceUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to {@link com.liferay.portal.service.impl.CMISRepositoryLocalServiceImpl} and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	* Returns the Spring bean ID for this bean.
	*
	* @return the Spring bean ID for this bean
	*/
	public static java.lang.String getBeanIdentifier() {
		return getService().getBeanIdentifier();
	}

	/**
	* Sets the Spring bean ID for this bean.
	*
	* @param beanIdentifier the Spring bean ID for this bean
	*/
	public static void setBeanIdentifier(java.lang.String beanIdentifier) {
		getService().setBeanIdentifier(beanIdentifier);
	}

	public static java.lang.Object getSession(long repositoryId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().getSession(repositoryId);
	}

	public static com.liferay.portal.kernel.repository.model.FileEntry toFileEntry(
		long repositoryId, java.lang.Object object)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().toFileEntry(repositoryId, object);
	}

	public static com.liferay.portal.kernel.repository.model.FileVersion toFileVersion(
		long repositoryId, java.lang.Object object)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().toFileVersion(repositoryId, object);
	}

	public static com.liferay.portal.kernel.repository.model.Folder toFolder(
		long repositoryId, java.lang.Object object)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().toFolder(repositoryId, object);
	}

	public static CMISRepositoryLocalService getService() {
		if (_service == null) {
			_service = (CMISRepositoryLocalService)PortalBeanLocatorUtil.locate(CMISRepositoryLocalService.class.getName());

			ReferenceRegistry.registerReference(CMISRepositoryLocalServiceUtil.class,
				"_service");
			MethodCache.remove(CMISRepositoryLocalService.class);
		}

		return _service;
	}

	public void setService(CMISRepositoryLocalService service) {
		MethodCache.remove(CMISRepositoryLocalService.class);

		_service = service;

		ReferenceRegistry.registerReference(CMISRepositoryLocalServiceUtil.class,
			"_service");
		MethodCache.remove(CMISRepositoryLocalService.class);
	}

	private static CMISRepositoryLocalService _service;
}