/**
 * Copyright (c) 2000-2011 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.social.model;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the SocialEquityAssetEntry service. Represents a row in the &quot;SocialEquityAssetEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.social.model.impl.SocialEquityAssetEntryModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.social.model.impl.SocialEquityAssetEntryImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this interface directly. All methods that expect a social equity asset entry model instance should use the {@link SocialEquityAssetEntry} interface instead.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialEquityAssetEntry
 * @see com.liferay.portlet.social.model.impl.SocialEquityAssetEntryImpl
 * @see com.liferay.portlet.social.model.impl.SocialEquityAssetEntryModelImpl
 * @generated
 */
public interface SocialEquityAssetEntryModel extends BaseModel<SocialEquityAssetEntry> {
	/**
	 * Gets the primary key of this social equity asset entry.
	 *
	 * @return the primary key of this social equity asset entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this social equity asset entry
	 *
	 * @param pk the primary key of this social equity asset entry
	 */
	public void setPrimaryKey(long pk);

	/**
	 * Gets the equity asset entry id of this social equity asset entry.
	 *
	 * @return the equity asset entry id of this social equity asset entry
	 */
	public long getEquityAssetEntryId();

	/**
	 * Sets the equity asset entry id of this social equity asset entry.
	 *
	 * @param equityAssetEntryId the equity asset entry id of this social equity asset entry
	 */
	public void setEquityAssetEntryId(long equityAssetEntryId);

	/**
	 * Gets the group id of this social equity asset entry.
	 *
	 * @return the group id of this social equity asset entry
	 */
	public long getGroupId();

	/**
	 * Sets the group id of this social equity asset entry.
	 *
	 * @param groupId the group id of this social equity asset entry
	 */
	public void setGroupId(long groupId);

	/**
	 * Gets the company id of this social equity asset entry.
	 *
	 * @return the company id of this social equity asset entry
	 */
	public long getCompanyId();

	/**
	 * Sets the company id of this social equity asset entry.
	 *
	 * @param companyId the company id of this social equity asset entry
	 */
	public void setCompanyId(long companyId);

	/**
	 * Gets the user id of this social equity asset entry.
	 *
	 * @return the user id of this social equity asset entry
	 */
	public long getUserId();

	/**
	 * Sets the user id of this social equity asset entry.
	 *
	 * @param userId the user id of this social equity asset entry
	 */
	public void setUserId(long userId);

	/**
	 * Gets the user uuid of this social equity asset entry.
	 *
	 * @return the user uuid of this social equity asset entry
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this social equity asset entry.
	 *
	 * @param userUuid the user uuid of this social equity asset entry
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Gets the asset entry id of this social equity asset entry.
	 *
	 * @return the asset entry id of this social equity asset entry
	 */
	public long getAssetEntryId();

	/**
	 * Sets the asset entry id of this social equity asset entry.
	 *
	 * @param assetEntryId the asset entry id of this social equity asset entry
	 */
	public void setAssetEntryId(long assetEntryId);

	/**
	 * Gets the information k of this social equity asset entry.
	 *
	 * @return the information k of this social equity asset entry
	 */
	public double getInformationK();

	/**
	 * Sets the information k of this social equity asset entry.
	 *
	 * @param informationK the information k of this social equity asset entry
	 */
	public void setInformationK(double informationK);

	/**
	 * Gets the information b of this social equity asset entry.
	 *
	 * @return the information b of this social equity asset entry
	 */
	public double getInformationB();

	/**
	 * Sets the information b of this social equity asset entry.
	 *
	 * @param informationB the information b of this social equity asset entry
	 */
	public void setInformationB(double informationB);

	/**
	 * Gets a copy of this social equity asset entry as an escaped model instance by wrapping it with an {@link com.liferay.portal.kernel.bean.AutoEscapeBeanHandler}.
	 *
	 * @return the escaped model instance
	 * @see com.liferay.portal.kernel.bean.AutoEscapeBeanHandler
	 */
	public SocialEquityAssetEntry toEscapedModel();

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public void setEscapedModel(boolean escapedModel);

	public Serializable getPrimaryKeyObj();

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(SocialEquityAssetEntry socialEquityAssetEntry);

	public int hashCode();

	public String toString();

	public String toXmlString();
}