/**
 * Copyright (c) 2000-2011 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.enterpriseadmin.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.permission.PermissionChecker;

import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Brian Wing Shun Chan
 * @author Jorge Ferrer
 * @author Julio Camarero
 */
public interface EnterpriseAdmin {

	public static final String CUSTOM_QUESTION = "write-my-own-question";

	public void addPortletBreadcrumbEntries(
			Organization organization, HttpServletRequest request,
			RenderResponse renderResponse)
		throws Exception;

	public String getCssClassName(Role role);

	public long[] addRequiredRoles(long userId, long[] roleIds)
		throws PortalException, SystemException;

	public long[] addRequiredRoles(User user, long[] roleIds)
		throws PortalException, SystemException;

	public List<Role> filterGroupRoles(
			PermissionChecker permissionChecker, long groupId, List<Role> roles)
		throws PortalException, SystemException;

	public List<Group> filterGroups(
			PermissionChecker permissionChecker, List<Group> groups)
		throws PortalException, SystemException;

	public List<Organization> filterOrganizations(
			PermissionChecker permissionChecker,
			List<Organization> organizations)
		throws PortalException, SystemException;

	public List<Role> filterRoles(
		PermissionChecker permissionChecker, List<Role> roles);

	public List<UserGroupRole> filterUserGroupRoles(
			PermissionChecker permissionChecker,
			List<UserGroupRole> userGroupRoles)
		throws PortalException, SystemException;

	public List<UserGroup> filterUserGroups(
		PermissionChecker permissionChecker, List<UserGroup> userGroups);

	public List<Address> getAddresses(ActionRequest actionRequest);

	public List<EmailAddress> getEmailAddresses(ActionRequest actionRequest);

	public OrderByComparator getGroupOrderByComparator(
		String orderByCol, String orderByType);

	public Long[][] getLeftAndRightOrganizationIds(long organizationId)
		throws PortalException, SystemException;

	public Long[][] getLeftAndRightOrganizationIds(Organization organization);

	public Long[][] getLeftAndRightOrganizationIds(
		List<Organization> organizations);

	public Long[] getOrganizationIds(List<Organization> organizations);

	public OrderByComparator getOrganizationOrderByComparator(
		String orderByCol, String orderByType);

	public List<OrgLabor> getOrgLabors(ActionRequest actionRequest);

	public OrderByComparator getPasswordPolicyOrderByComparator(
		String orderByCol, String orderByType);

	public List<Phone> getPhones(ActionRequest actionRequest);

	public OrderByComparator getRoleOrderByComparator(
		String orderByCol, String orderByType);

	public OrderByComparator getUserGroupOrderByComparator(
		String orderByCol, String orderByType);

	public List<UserGroupRole> getUserGroupRoles(PortletRequest portletRequest)
		throws SystemException, PortalException;

	public OrderByComparator getUserOrderByComparator(
		String orderByCol, String orderByType);

	public List<Website> getWebsites(ActionRequest actionRequest);

	public boolean hasUpdateEmailAddress(
			PermissionChecker permissionChecker, User user)
		throws PortalException, SystemException;

	public boolean hasUpdateScreenName(
			PermissionChecker permissionChecker, User user)
		throws PortalException, SystemException;

	public long[] removeRequiredRoles(long userId, long[] roleIds)
		throws PortalException, SystemException;

	public long[] removeRequiredRoles(User user, long[] roleIds)
		throws PortalException, SystemException;

	public void updateAddresses(
			String className, long classPK, List<Address> addresses)
		throws PortalException, SystemException;

	public void updateEmailAddresses(
			String className, long classPK, List<EmailAddress> emailAddresses)
		throws PortalException, SystemException;

	public void updateOrgLabors(long classPK, List<OrgLabor> orgLabors)
		throws PortalException, SystemException;

	public void updatePhones(String className, long classPK, List<Phone> phones)
		throws PortalException, SystemException;

	public void updateWebsites(
			String className, long classPK, List<Website> websites)
		throws PortalException, SystemException;

}